/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.service.xml.xpath.comparators;

import io.sirix.api.Axis;
import io.sirix.api.xml.XmlNodeReadOnlyTrx;
import io.sirix.exception.SirixXPathException;
import io.sirix.service.xml.xpath.AbstractAxis;
import io.sirix.service.xml.xpath.AtomicValue;
import io.sirix.service.xml.xpath.comparators.CompKind;
import io.sirix.service.xml.xpath.comparators.GeneralComp;
import io.sirix.service.xml.xpath.comparators.NodeComp;
import io.sirix.service.xml.xpath.comparators.ValueComp;
import io.sirix.service.xml.xpath.expr.LiteralExpr;
import io.sirix.service.xml.xpath.types.Type;

public abstract class AbstractComparator
extends AbstractAxis {
    private final CompKind mComp;
    private final Axis operand1;
    private final Axis operand2;
    private boolean isFirst;

    public AbstractComparator(XmlNodeReadOnlyTrx mRtx, Axis mOperand1, Axis mOperand2, CompKind mComp) {
        super(mRtx);
        this.mComp = mComp;
        this.operand1 = mOperand1;
        this.operand2 = mOperand2;
        this.isFirst = true;
    }

    @Override
    public final void reset(long mNodeKey) {
        super.reset(mNodeKey);
        this.isFirst = true;
        if (this.operand1 != null) {
            this.operand1.reset(mNodeKey);
        }
        if (this.operand2 != null) {
            this.operand2.reset(mNodeKey);
        }
    }

    @Override
    public final boolean hasNext() {
        block8: {
            this.resetToLastKey();
            if (this.isFirst) {
                this.isFirst = false;
                if (!(this.operand1 instanceof LiteralExpr)) {
                    this.operand1.reset(this.asXmlNodeReadTrx().getNodeKey());
                }
                if (!(this.operand2 instanceof LiteralExpr)) {
                    this.operand2.reset(this.asXmlNodeReadTrx().getNodeKey());
                }
                if (this.operand1.hasNext()) {
                    this.key = this.operand1.nextLong();
                    try {
                        AtomicValue[] operandOne = this.atomize(this.operand1);
                        if (!this.operand2.hasNext()) break block8;
                        this.key = this.operand2.nextLong();
                        AtomicValue[] operandTwo = this.atomize(this.operand2);
                        this.hook(operandOne, operandTwo);
                        try {
                            boolean resultValue = this.compare(operandOne, operandTwo);
                            AtomicValue result = new AtomicValue(resultValue);
                            int itemKey = this.asXmlNodeReadTrx().getItemList().addItem(result);
                            this.key = itemKey;
                        }
                        catch (SirixXPathException e) {
                            throw new RuntimeException(e);
                        }
                        return true;
                    }
                    catch (SirixXPathException exc) {
                        throw new RuntimeException(exc);
                    }
                }
            }
        }
        this.resetToStartKey();
        return false;
    }

    protected void hook(AtomicValue[] paramOperandOne, AtomicValue[] paramOperandTwo) {
    }

    protected abstract boolean compare(AtomicValue[] var1, AtomicValue[] var2) throws SirixXPathException;

    protected abstract AtomicValue[] atomize(Axis var1) throws SirixXPathException;

    protected abstract Type getType(int var1, int var2) throws SirixXPathException;

    public final CompKind getCompKind() {
        return this.mComp;
    }

    public static final AbstractComparator getComparator(XmlNodeReadOnlyTrx paramRtx, Axis paramOperandOne, Axis paramOperandTwo, CompKind paramKind, String paramVal) {
        if ("eq".equals(paramVal) || "lt".equals(paramVal) || "le".equals(paramVal) || "gt".equals(paramVal) || "ge".equals(paramVal)) {
            return new ValueComp(paramRtx, paramOperandOne, paramOperandTwo, paramKind);
        }
        if ("=".equals(paramVal) || "!=".equals(paramVal) || "<".equals(paramVal) || "<=".equals(paramVal) || ">".equals(paramVal) || ">=".equals(paramVal)) {
            return new GeneralComp(paramRtx, paramOperandOne, paramOperandTwo, paramKind);
        }
        if ("is".equals(paramVal) || "<<".equals(paramVal) || ">>".equals(paramVal)) {
            new NodeComp(paramRtx, paramOperandOne, paramOperandTwo, paramKind);
        }
        throw new IllegalStateException(paramVal + " is not a valid comparison.");
    }
}

