/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.service.xml.xpath.comparators;

import io.sirix.exception.SirixXPathException;
import io.sirix.service.xml.xpath.EXPathError;
import io.sirix.service.xml.xpath.types.Type;
import java.util.HashMap;
import java.util.Map;

public enum CompKind {
    EQ(new String[]{"eq", "="}){

        @Override
        public boolean compare(String mOperand1, String mOperand2, Type mType) throws SirixXPathException {
            switch (mType) {
                case FLOAT: {
                    return Float.parseFloat(mOperand1) == Float.parseFloat(mOperand2);
                }
                case DECIMAL: 
                case DOUBLE: {
                    return Double.parseDouble(mOperand1) == Double.parseDouble(mOperand2);
                }
                case INTEGER: {
                    return (int)Double.parseDouble(mOperand1) == (int)Double.parseDouble(mOperand2);
                }
                case BOOLEAN: {
                    return Boolean.parseBoolean(mOperand1) == Boolean.parseBoolean(mOperand2);
                }
                case STRING: 
                case ANY_URI: {
                    return mOperand1.compareTo(mOperand2) == 0;
                }
                case DATE: 
                case DATE_TIME: 
                case TIME: 
                case DURATION: 
                case HEX_BINARY: 
                case BASE_64_BINARY: 
                case QNAME: 
                case NOTATION: 
                case G_DAY: 
                case G_MONTH_DAY: 
                case G_MONTH: 
                case G_YEAR: 
                case G_YEAR_MONTH: {
                    throw new IllegalStateException("Not implemented for this type yet");
                }
            }
            throw EXPathError.XPTY0004.getEncapsulatedException();
        }
    }
    ,
    NE(new String[]{"ne", "!="}){

        @Override
        public boolean compare(String mOperand1, String mOperand2, Type mType) throws SirixXPathException {
            switch (mType) {
                case FLOAT: {
                    return Float.parseFloat(mOperand1) != Float.parseFloat(mOperand2);
                }
                case DECIMAL: 
                case DOUBLE: {
                    return Double.parseDouble(mOperand1) != Double.parseDouble(mOperand2);
                }
                case INTEGER: {
                    return (int)Double.parseDouble(mOperand1) != (int)Double.parseDouble(mOperand2);
                }
                case BOOLEAN: {
                    return Boolean.parseBoolean(mOperand1) != Boolean.parseBoolean(mOperand2);
                }
                case STRING: 
                case ANY_URI: {
                    return mOperand1.compareTo(mOperand2) != 0;
                }
                case DATE: 
                case DATE_TIME: 
                case TIME: 
                case DURATION: 
                case HEX_BINARY: 
                case BASE_64_BINARY: 
                case QNAME: 
                case NOTATION: 
                case G_DAY: 
                case G_MONTH_DAY: 
                case G_MONTH: 
                case G_YEAR: 
                case G_YEAR_MONTH: {
                    throw new IllegalStateException("Not implemented for this type yet");
                }
            }
            throw EXPathError.XPTY0004.getEncapsulatedException();
        }
    }
    ,
    LT(new String[]{"lt", "<"}){

        @Override
        public boolean compare(String mOperand1, String mOperand2, Type mType) throws SirixXPathException {
            switch (mType) {
                case FLOAT: {
                    return Float.parseFloat(mOperand1) < Float.parseFloat(mOperand2);
                }
                case DECIMAL: 
                case DOUBLE: {
                    return Double.parseDouble(mOperand1) < Double.parseDouble(mOperand2);
                }
                case INTEGER: {
                    return (int)Double.parseDouble(mOperand1) < (int)Double.parseDouble(mOperand2);
                }
                case BOOLEAN: {
                    return !Boolean.parseBoolean(mOperand1) && Boolean.parseBoolean(mOperand2);
                }
                case STRING: 
                case ANY_URI: {
                    return mOperand1.compareTo(mOperand2) < 0;
                }
                case DATE: 
                case DATE_TIME: 
                case TIME: 
                case YEAR_MONTH_DURATION: 
                case DAY_TIME_DURATION: {
                    throw new IllegalStateException("Not implemented for this type yet");
                }
            }
            throw EXPathError.XPTY0004.getEncapsulatedException();
        }
    }
    ,
    LE(new String[]{"le", "<="}){

        @Override
        public boolean compare(String mOperand1, String mOperand2, Type mType) throws SirixXPathException {
            switch (mType) {
                case FLOAT: {
                    return Float.parseFloat(mOperand1) <= Float.parseFloat(mOperand2);
                }
                case DECIMAL: 
                case DOUBLE: {
                    return Double.parseDouble(mOperand1) <= Double.parseDouble(mOperand2);
                }
                case INTEGER: {
                    return (int)Double.parseDouble(mOperand1) <= (int)Double.parseDouble(mOperand2);
                }
                case BOOLEAN: {
                    return !Boolean.parseBoolean(mOperand1) || Boolean.parseBoolean(mOperand2);
                }
                case STRING: 
                case ANY_URI: {
                    return mOperand1.compareTo(mOperand2) < 1;
                }
                case DATE: 
                case DATE_TIME: 
                case TIME: 
                case YEAR_MONTH_DURATION: 
                case DAY_TIME_DURATION: {
                    throw new IllegalStateException("Not implemented for this type yet");
                }
            }
            throw EXPathError.XPTY0004.getEncapsulatedException();
        }
    }
    ,
    GT(new String[]{"gt", ">"}){

        @Override
        public boolean compare(String mOperand1, String mOperand2, Type mType) throws SirixXPathException {
            switch (mType) {
                case FLOAT: {
                    return Float.parseFloat(mOperand1) > Float.parseFloat(mOperand2);
                }
                case DECIMAL: 
                case DOUBLE: {
                    return Double.parseDouble(mOperand1) > Double.parseDouble(mOperand2);
                }
                case INTEGER: {
                    return (int)Double.parseDouble(mOperand1) > (int)Double.parseDouble(mOperand2);
                }
                case BOOLEAN: {
                    return Boolean.parseBoolean(mOperand1) && !Boolean.parseBoolean(mOperand2);
                }
                case STRING: 
                case ANY_URI: {
                    return mOperand1.compareTo(mOperand2) > 0;
                }
                case DATE: 
                case DATE_TIME: 
                case TIME: 
                case YEAR_MONTH_DURATION: 
                case DAY_TIME_DURATION: {
                    throw new IllegalStateException("Not implemented for this type yet");
                }
            }
            throw EXPathError.XPTY0004.getEncapsulatedException();
        }
    }
    ,
    GE(new String[]{"ge", ">="}){

        @Override
        public boolean compare(String mOperand1, String mOperand2, Type mType) throws SirixXPathException {
            switch (mType) {
                case FLOAT: {
                    return Float.parseFloat(mOperand1) >= Float.parseFloat(mOperand2);
                }
                case DECIMAL: 
                case DOUBLE: {
                    return Double.parseDouble(mOperand1) >= Double.parseDouble(mOperand2);
                }
                case INTEGER: {
                    return (int)Double.parseDouble(mOperand1) >= (int)Double.parseDouble(mOperand2);
                }
                case BOOLEAN: {
                    return Boolean.parseBoolean(mOperand1) || !Boolean.parseBoolean(mOperand2);
                }
                case STRING: 
                case ANY_URI: {
                    return mOperand1.compareTo(mOperand2) > -1;
                }
                case DATE: 
                case DATE_TIME: 
                case TIME: 
                case YEAR_MONTH_DURATION: 
                case DAY_TIME_DURATION: {
                    throw new IllegalStateException("Not implemented for this type yet");
                }
            }
            throw EXPathError.XPTY0004.getEncapsulatedException();
        }
    }
    ,
    FO(new String[]{">>"}){

        @Override
        public boolean compare(String mOperand1, String mOperand2, Type mType) throws SirixXPathException {
            throw new IllegalStateException("Evaluation of node comparisons not possible");
        }
    }
    ,
    PRE(new String[]{"<<"}){

        @Override
        public boolean compare(String mOperand1, String mOperand2, Type mType) throws SirixXPathException {
            throw new IllegalStateException("Evaluation of node comparisons not possible");
        }
    }
    ,
    IS(new String[]{"is"}){

        @Override
        public boolean compare(String mOperand1, String mOperand2, Type mType) throws SirixXPathException {
            return (int)Double.parseDouble(mOperand1) == (int)Double.parseDouble(mOperand2);
        }
    };

    private final String[] mCompAsString;
    private static final Map<String, CompKind> STRINGTOENUM;

    private CompKind(String ... paramCompAsString) {
        this.mCompAsString = paramCompAsString;
    }

    public abstract boolean compare(String var1, String var2, Type var3) throws SirixXPathException;

    public static CompKind fromString(String paramName) {
        return STRINGTOENUM.get(paramName);
    }

    static {
        STRINGTOENUM = new HashMap<String, CompKind>();
        for (CompKind kind : CompKind.values()) {
            for (String compAsString : kind.mCompAsString) {
                STRINGTOENUM.put(compAsString, kind);
            }
        }
    }
}

