/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.service.xml.xpath.comparators;

import io.sirix.api.Axis;
import io.sirix.api.xml.XmlNodeReadOnlyTrx;
import io.sirix.exception.SirixXPathException;
import io.sirix.service.xml.xpath.AtomicValue;
import io.sirix.service.xml.xpath.comparators.AbstractComparator;
import io.sirix.service.xml.xpath.comparators.CompKind;
import io.sirix.service.xml.xpath.functions.Function;
import io.sirix.service.xml.xpath.types.Type;
import java.util.ArrayList;

public class GeneralComp
extends AbstractComparator {
    public GeneralComp(XmlNodeReadOnlyTrx rtx, Axis mOperand1, Axis mOperand2, CompKind mCom) {
        super(rtx, mOperand1, mOperand2, mCom);
    }

    @Override
    protected boolean compare(AtomicValue[] mOperand1, AtomicValue[] mOperand2) throws SirixXPathException {
        assert (mOperand1.length >= 1 && mOperand2.length >= 1);
        for (AtomicValue op1 : mOperand1) {
            for (AtomicValue op2 : mOperand2) {
                String value1 = new String(op1.getRawValue());
                String value2 = new String(op2.getRawValue());
                if (!this.getCompKind().compare(value1, value2, this.getType(op1.getTypeKey(), op2.getTypeKey()))) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected AtomicValue[] atomize(Axis mOperand) {
        XmlNodeReadOnlyTrx rtx = this.asXmlNodeReadTrx();
        ArrayList<AtomicValue> op = new ArrayList<AtomicValue>();
        boolean convert = this.getCompKind() != CompKind.EQ && this.getCompKind() != CompKind.EQ;
        boolean first = true;
        do {
            if (first) {
                first = false;
            } else {
                mOperand.next();
            }
            if (convert) {
                Function.fnnumber(rtx);
            }
            AtomicValue atomized = new AtomicValue(rtx.getValue().getBytes(), rtx.getTypeKey());
            op.add(atomized);
        } while (mOperand.hasNext());
        return op.toArray(new AtomicValue[op.size()]);
    }

    @Override
    protected Type getType(int mKey1, int mKey2) throws SirixXPathException {
        Type mType1 = Type.getType(mKey1).getPrimitiveBaseType();
        Type mType2 = Type.getType(mKey2).getPrimitiveBaseType();
        if (mType1.isNumericType() || mType2.isNumericType()) {
            return Type.DOUBLE;
        }
        if (mType1 == Type.STRING || mType2 == Type.STRING || mType1 == Type.UNTYPED_ATOMIC && mType2 == Type.UNTYPED_ATOMIC) {
            return Type.STRING;
        }
        if (mType1 == Type.UNTYPED_ATOMIC || mType2 == Type.UNTYPED_ATOMIC) {
            return Type.UNTYPED_ATOMIC;
        }
        return Type.getLeastCommonType(mType1, mType2);
    }
}

