/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.service.xml.xpath.expr;

import io.sirix.api.Axis;
import io.sirix.api.xml.XmlNodeReadOnlyTrx;
import io.sirix.service.xml.xpath.AbstractAxis;
import io.sirix.service.xml.xpath.AtomicValue;
import io.sirix.service.xml.xpath.types.Type;
import io.sirix.utils.TypedValue;

public class RangeAxis
extends AbstractAxis {
    private final Axis mFrom;
    private final Axis mTo;
    private boolean mFirst;
    private int mStart;
    private int mEnd;

    public RangeAxis(XmlNodeReadOnlyTrx rtx, Axis mFrom, Axis mTo) {
        super(rtx);
        this.mFrom = mFrom;
        this.mTo = mTo;
        this.mFirst = true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean hasNext() {
        block5: {
            this.resetToLastKey();
            if (this.mFirst) {
                this.mFirst = false;
                if (this.mFrom.hasNext() && Type.getType(this.mFrom.asXmlNodeReadTrx().getTypeKey()).derivesFrom(Type.INTEGER)) {
                    this.mStart = Integer.parseInt(this.mFrom.asXmlNodeReadTrx().getValue());
                    if (this.mTo.hasNext() && Type.getType(this.mTo.asXmlNodeReadTrx().getTypeKey()).derivesFrom(Type.INTEGER)) {
                        this.mEnd = Integer.parseInt(this.mTo.asXmlNodeReadTrx().getValue());
                        break block5;
                    } else {
                        this.resetToStartKey();
                        return false;
                    }
                }
                this.resetToStartKey();
                return false;
            }
        }
        if (this.mStart <= this.mEnd) {
            int itemKey = this.asXmlNodeReadTrx().getItemList().addItem(new AtomicValue(TypedValue.getBytes(Integer.toString(this.mStart)), this.asXmlNodeReadTrx().keyForName("xs:integer")));
            this.key = itemKey;
            ++this.mStart;
            return true;
        }
        this.resetToStartKey();
        return false;
    }
}

