/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.service.xml.xpath.expr;

import io.sirix.api.Axis;
import io.sirix.api.xml.XmlNodeReadOnlyTrx;
import io.sirix.service.xml.xpath.AbstractAxis;
import java.util.Arrays;
import java.util.List;

public class SequenceAxis
extends AbstractAxis {
    private final List<Axis> mSeq;
    private Axis mCurrent;
    private int mNum;

    public SequenceAxis(XmlNodeReadOnlyTrx rtx, Axis ... axis) {
        super(rtx);
        this.mSeq = Arrays.asList(axis);
        this.mNum = 0;
    }

    @Override
    public void reset(long mNodeKey) {
        super.reset(mNodeKey);
        if (this.mSeq != null) {
            for (Axis ax : this.mSeq) {
                ax.reset(mNodeKey);
            }
        }
        this.mCurrent = null;
        this.mNum = 0;
    }

    @Override
    public boolean hasNext() {
        this.resetToLastKey();
        if (this.mCurrent != null && this.mCurrent.hasNext()) {
            this.key = this.mCurrent.next();
            return true;
        }
        while (this.mNum < this.mSeq.size()) {
            this.mCurrent = this.mSeq.get(this.mNum++);
            this.mCurrent.reset(this.asXmlNodeReadTrx().getNodeKey());
            if (!this.mCurrent.hasNext()) continue;
            this.key = this.mCurrent.next();
            return true;
        }
        this.resetToStartKey();
        return false;
    }
}

