/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.service.xml.xpath.expr;

import io.sirix.api.Axis;
import io.sirix.api.xml.XmlNodeReadOnlyTrx;
import io.sirix.service.xml.xpath.AbstractAxis;
import io.sirix.service.xml.xpath.expr.VarRefExpr;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;

public class VariableAxis
extends AbstractAxis {
    private final Axis mBindingSeq;
    private final List<VarRefExpr> mVarRefs;

    public VariableAxis(XmlNodeReadOnlyTrx pRtx, @NonNull Axis pInSeq) {
        super(pRtx);
        this.mBindingSeq = Objects.requireNonNull(pInSeq);
        this.mVarRefs = new ArrayList<VarRefExpr>();
    }

    @Override
    public void reset(long pNodeKey) {
        super.reset(pNodeKey);
        if (this.mBindingSeq != null) {
            this.mBindingSeq.reset(pNodeKey);
        }
    }

    @Override
    public boolean hasNext() {
        if (this.isNext()) {
            return true;
        }
        this.resetToLastKey();
        if (this.mBindingSeq.hasNext()) {
            this.key = this.mBindingSeq.next();
            this.notifyObs();
            return true;
        }
        this.resetToStartKey();
        return false;
    }

    private void notifyObs() {
        for (VarRefExpr varRef : this.mVarRefs) {
            varRef.update(this.asXmlNodeReadTrx().getNodeKey());
        }
    }

    public void addObserver(VarRefExpr pObserver) {
        this.mVarRefs.add(Objects.requireNonNull(pObserver));
    }
}

