/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.service.xml.xpath.functions.sequences;

import io.sirix.api.Axis;
import io.sirix.api.xml.XmlNodeReadOnlyTrx;
import io.sirix.exception.SirixXPathException;
import io.sirix.service.xml.xpath.EXPathError;
import io.sirix.service.xml.xpath.functions.AbstractFunction;
import io.sirix.service.xml.xpath.types.Type;
import io.sirix.utils.TypedValue;
import java.util.List;

public class FNBoolean
extends AbstractFunction {
    public FNBoolean(XmlNodeReadOnlyTrx rtx, List<Axis> args, int min, int max, int returnType) throws SirixXPathException {
        super(rtx, args, min, max, returnType);
    }

    @Override
    protected byte[] computeResult() throws SirixXPathException {
        Axis axis = this.getArgs().get(0);
        boolean value = false;
        if (axis.hasNext()) {
            this.key = axis.next();
            XmlNodeReadOnlyTrx rtx = axis.asXmlNodeReadTrx();
            if (rtx.getNodeKey() >= 0L) {
                value = true;
            } else {
                Type type = Type.getType(rtx.getTypeKey());
                if (type.derivesFrom(Type.BOOLEAN)) {
                    value = Boolean.parseBoolean(rtx.getValue());
                } else if (type.derivesFrom(Type.STRING) || type.derivesFrom(Type.ANY_URI) || type.derivesFrom(Type.UNTYPED_ATOMIC)) {
                    value = rtx.getValue().length() > 0;
                } else if (type.isNumericType()) {
                    double dValue = Double.parseDouble(rtx.getValue());
                    value = !Double.isNaN(dValue) && dValue != 0.0;
                } else {
                    throw EXPathError.FORG0006.getEncapsulatedException();
                }
                if (axis.hasNext()) {
                    throw EXPathError.FORG0006.getEncapsulatedException();
                }
            }
        } else {
            value = false;
        }
        return TypedValue.getBytes(Boolean.toString(value));
    }
}

