/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.service.xml.xpath.operators;

import io.sirix.api.Axis;
import io.sirix.api.xml.XmlNodeReadOnlyTrx;
import io.sirix.exception.SirixXPathException;
import io.sirix.node.interfaces.Node;
import io.sirix.service.xml.xpath.AbstractAxis;
import io.sirix.service.xml.xpath.AtomicValue;
import io.sirix.service.xml.xpath.functions.Function;
import io.sirix.service.xml.xpath.types.Type;

public abstract class AbstractObAxis
extends AbstractAxis {
    private final Axis mOperand1;
    private final Axis mOperand2;
    private boolean mIsFirst;

    public AbstractObAxis(XmlNodeReadOnlyTrx rtx, Axis mOp1, Axis mOp2) {
        super(rtx);
        this.mOperand1 = mOp1;
        this.mOperand2 = mOp2;
        this.mIsFirst = true;
    }

    @Override
    public final void reset(long mNodeKey) {
        super.reset(mNodeKey);
        this.mIsFirst = true;
        if (this.mOperand1 != null) {
            this.mOperand1.reset(mNodeKey);
        }
        if (this.mOperand2 != null) {
            this.mOperand2.reset(mNodeKey);
        }
    }

    @Override
    public boolean hasNext() {
        this.resetToLastKey();
        if (this.mIsFirst) {
            this.mIsFirst = false;
            if (this.mOperand1.hasNext()) {
                this.key = this.mOperand1.next();
                AtomicValue mItem1 = this.atomize(this.mOperand1);
                if (this.mOperand2.hasNext()) {
                    this.key = this.mOperand2.next();
                    AtomicValue mItem2 = this.atomize(this.mOperand2);
                    try {
                        AtomicValue result = (AtomicValue)this.operate(mItem1, mItem2);
                        int itemKey = this.asXmlNodeReadTrx().getItemList().addItem(result);
                        this.key = itemKey;
                        return true;
                    }
                    catch (SirixXPathException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            AtomicValue result = new AtomicValue(Double.NaN, Type.DOUBLE);
            int itemKey = this.asXmlNodeReadTrx().getItemList().addItem(result);
            this.key = itemKey;
            return true;
        }
        this.resetToStartKey();
        return false;
    }

    private AtomicValue atomize(Axis mOperand) {
        XmlNodeReadOnlyTrx rtx = this.asXmlNodeReadTrx();
        int type = rtx.getTypeKey();
        if (type == rtx.keyForName("xs:double") || type == rtx.keyForName("xs:untypedAtomic") || type == rtx.keyForName("xs:boolean") || type == rtx.keyForName("xs:string") || type == rtx.keyForName("xs:integer") || type == rtx.keyForName("xs:float") || type == rtx.keyForName("xs:decimal")) {
            Function.fnnumber(mOperand.asXmlNodeReadTrx());
        }
        AtomicValue atom = new AtomicValue(rtx.getValue().getBytes(), rtx.getTypeKey());
        return atom;
    }

    protected abstract Node operate(AtomicValue var1, AtomicValue var2) throws SirixXPathException;

    protected abstract Type getReturnType(int var1, int var2) throws SirixXPathException;
}

