/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.utils;

import java.util.Arrays;
import java.util.Objects;

public final class Array {
    public static final int MAX_SIZE = 0x7FFFFFF7;
    public static final int INITIAL_CAPACITY = 8;
    public static final int MAX_CAPACITY = 0x100000;
    public static final double RESIZE_CAPACITY = 1.5;

    private Array() {
    }

    public static byte[][] copyOf(byte[][] array, int size) {
        byte[][] tmp = new byte[size][];
        Array.copy(array, Math.min(size, array.length), tmp);
        return tmp;
    }

    public static int[][] copyOf(int[][] array, int size) {
        int[][] tmp = new int[size][];
        Array.copy(array, Math.min(size, array.length), tmp);
        return tmp;
    }

    public static String[] copyOf(String[] array, int size) {
        String[] tmp = new String[size];
        Array.copy(array, Math.min(size, array.length), tmp);
        return tmp;
    }

    public static <T> T[] add(T[] array, T entry) {
        int s = array.length;
        T[] t = Arrays.copyOf(array, s + 1);
        t[s] = entry;
        return t;
    }

    public static int[] add(int[] array, int entry) {
        int s = array.length;
        int[] t = Arrays.copyOf(array, s + 1);
        t[s] = entry;
        return t;
    }

    public static void insert(Object array, int index, int add, int length, Object entries) {
        System.arraycopy(array, index, array, index + add, length - index);
        if (entries != null) {
            Array.copyFromStart(entries, add, array, index);
        }
    }

    public static void remove(Object array, int index, int del, int length) {
        System.arraycopy(array, index + del, array, index, length - index - del);
    }

    public static void copy(Object array, int index, int length, Object target, int trgIndex) {
        System.arraycopy(array, index, target, trgIndex, length);
    }

    public static void copy(Object source, int length, Object target) {
        Array.copyFromStart(source, length, target, 0);
    }

    public static void copyFromStart(Object source, int length, Object target, int index) {
        System.arraycopy(source, 0, target, index, length);
    }

    public static void copyToStart(Object source, int index, int length, Object target) {
        System.arraycopy(source, index, target, 0, length);
    }

    public static <T> T[] copy(T[] source, T[] target) {
        Array.copy(source, Math.min(source.length, target.length), target);
        return target;
    }

    public static <T> T[] remove(T[] array, int index) {
        int s = array.length - 1;
        T[] tmp = Arrays.copyOf(array, s);
        System.arraycopy(array, index + 1, tmp, index, s - index);
        return tmp;
    }

    public static int initialCapacity(long size) {
        return size < 0L ? 8 : (int)Math.min(0x100000L, size);
    }

    public static int newCapacity(int size) {
        return Array.newCapacity(size, 1.5);
    }

    public static int newCapacity(int size, double factor) {
        return (int)Math.min(2.147483639E9, factor * (double)Array.checkCapacity(size + 1));
    }

    public static int checkCapacity(long size) {
        if (size > 0x7FFFFFF7L) {
            throw new ArrayIndexOutOfBoundsException("Maximum array size reached.");
        }
        return Math.max(0, (int)size);
    }

    public static boolean equals(Object[] arr1, Object[] arr2) {
        if (arr1 == arr2) {
            return true;
        }
        if (arr1 == null || arr2 == null) {
            return false;
        }
        int al = arr1.length;
        if (al != arr2.length) {
            return false;
        }
        for (int a = 0; a < al; ++a) {
            if (Objects.equals(arr1[a], arr2[a])) continue;
            return false;
        }
        return true;
    }
}

