/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.utils;

import com.google.common.base.Preconditions;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Objects;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;

public final class Compression {
    public static final int BUFFER_SIZE = 1024;
    private static final Deflater mCompressor = new Deflater();
    private static final Inflater mDecompressor = new Inflater();

    private Compression() {
        throw new AssertionError();
    }

    public static byte[] compress(byte[] toCompress, int level) {
        byte[] compressed;
        Objects.requireNonNull(toCompress);
        Preconditions.checkArgument((level >= -1 && level <= 9 ? 1 : 0) != 0, (Object)"level must be between 0 and 9!");
        mCompressor.setLevel(level);
        mCompressor.reset();
        mCompressor.setInput(toCompress);
        mCompressor.finish();
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream(toCompress.length);){
            byte[] buf = new byte[1024];
            while (!mCompressor.finished()) {
                int count = mCompressor.deflate(buf);
                bos.write(buf, 0, count);
            }
            compressed = bos.toByteArray();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return compressed;
    }

    public static byte[] decompress(byte[] compressed) {
        byte[] byArray;
        Objects.requireNonNull(compressed);
        mDecompressor.reset();
        mDecompressor.setInput(compressed);
        ByteArrayOutputStream bos = new ByteArrayOutputStream(compressed.length);
        try {
            byte[] buf = new byte[1024];
            while (!mDecompressor.finished()) {
                try {
                    int count = mDecompressor.inflate(buf);
                    bos.write(buf, 0, count);
                }
                catch (DataFormatException e) {
                    throw new IllegalStateException(e);
                }
            }
            byArray = bos.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    bos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        bos.close();
        return byArray;
    }
}

