/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.utils;

import io.sirix.utils.Array;
import io.sirix.utils.ArrayIterator;
import io.sirix.utils.IntSet;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public final class IntObjMap<E>
extends IntSet {
    private Object[] values = new Object[this.capacity()];

    public IntObjMap() {
    }

    public IntObjMap(int capacity) {
        super(capacity);
    }

    public E put(int key, E value) {
        int i = this.put(key);
        Object v = this.values[i];
        this.values[i] = value;
        return (E)v;
    }

    public E computeIfAbsent(int key, Supplier<? extends E> func) {
        E value = this.get(key);
        if (value == null) {
            value = func.get();
            this.put(key, value);
        }
        return value;
    }

    public E get(int key) {
        return (E)this.values[this.id(key)];
    }

    public Iterable<E> values() {
        return new ArrayIterator(this.values, 1, this.size);
    }

    public Collection<Integer> keys() {
        return Arrays.stream(this.keys).boxed().collect(Collectors.toList());
    }

    public int[] keyArray() {
        return this.keys;
    }

    @Override
    protected void rehash(int newSize) {
        super.rehash(newSize);
        this.values = Array.copy(this.values, new Object[newSize]);
    }

    @Override
    public void clear() {
        super.clear();
        Arrays.fill(this.values, null);
    }

    @Override
    public String toString() {
        ArrayList<Integer> k = new ArrayList<Integer>(this.keys.length);
        for (int key : this.keys) {
            k.add(key);
        }
        return this.toString(k.toArray(), this.values);
    }

    public Set<Map.Entry<Integer, E>> entrySet() {
        HashSet<Map.Entry<Integer, AbstractMap.SimpleEntry<Integer, Object>>> set = new HashSet<Map.Entry<Integer, AbstractMap.SimpleEntry<Integer, Object>>>();
        for (int i = 1; i < this.size; ++i) {
            set.add(new AbstractMap.SimpleEntry<Integer, Object>(this.keys[i], this.values[i]));
        }
        return set;
    }
}

