/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.utils;

import java.util.Objects;
import org.slf4j.Logger;

public final class LogWrapper {
    private final Logger logger;

    public LogWrapper(Logger logger) {
        this.logger = Objects.requireNonNull(logger);
    }

    public void error(String message, Object ... objects) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error(message, objects);
        }
    }

    public void error(Exception exception) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error(exception.getMessage(), (Throwable)exception);
        }
    }

    public void debug(String message, Object ... objects) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(message, objects);
        }
    }

    public void info(String message, Object ... objects) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info(message, objects);
        }
    }

    public void warn(String message, Object ... objects) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn(message, objects);
        }
    }
}

