/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.utils;

import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;

public class Pair<U, V> {
    private final U first;
    private final V second;

    public Pair(@Nullable U first, @Nullable V second) {
        this.first = first;
        this.second = second;
    }

    public U getFirst() {
        return this.first;
    }

    public V getSecond() {
        return this.second;
    }

    public int hashCode() {
        return Objects.hash(this.first, this.second);
    }

    public boolean equals(Object other) {
        if (!(other instanceof Pair)) {
            return false;
        }
        Pair otherPair = (Pair)other;
        return Objects.equals(this.first, otherPair.first) && Objects.equals(this.second, otherPair.second);
    }

    public String toString() {
        return "first: " + this.first.toString() + " second: " + this.second.toString();
    }
}

