/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.utils;

import io.sirix.exception.SirixRuntimeException;
import io.sirix.settings.Constants;

public final class TypedValue {
    public static final byte[] EMPTY = new byte[0];

    private TypedValue() {
    }

    public static int parseInt(byte[] mBytes) {
        try {
            int value = (mBytes[0] & 0xFF) << 24 | (mBytes[1] & 0xFF) << 16 | (mBytes[2] & 0xFF) << 8 | mBytes[3] & 0xFF;
            return value;
        }
        catch (Exception e) {
            throw new SirixRuntimeException(e.getLocalizedMessage());
        }
    }

    public static long parseLong(byte[] mBytes) {
        try {
            long value = ((long)mBytes[0] & 0xFFL) << 56 | ((long)mBytes[1] & 0xFFL) << 48 | ((long)mBytes[2] & 0xFFL) << 40 | ((long)mBytes[3] & 0xFFL) << 32 | ((long)mBytes[4] & 0xFFL) << 24 | ((long)mBytes[5] & 0xFFL) << 16 | ((long)mBytes[6] & 0xFFL) << 8 | (long)mBytes[7] & 0xFFL;
            return value;
        }
        catch (Exception e) {
            throw new SirixRuntimeException(e.getLocalizedMessage());
        }
    }

    public static byte[] getBytes(boolean mValue) {
        byte[] bytes = new byte[]{mValue ? (byte)1 : 0};
        return bytes;
    }

    public static byte[] getBytes(int mValue) {
        byte[] bytes = new byte[4];
        try {
            bytes[0] = (byte)(mValue >> 24);
            bytes[1] = (byte)(mValue >> 16);
            bytes[2] = (byte)(mValue >> 8);
            bytes[3] = (byte)mValue;
        }
        catch (Exception e) {
            throw new SirixRuntimeException(e.getLocalizedMessage());
        }
        return bytes;
    }

    public static byte[] getBytes(long value) {
        byte[] bytes = new byte[8];
        try {
            bytes[0] = (byte)(value >> 56);
            bytes[1] = (byte)(value >> 48);
            bytes[2] = (byte)(value >> 40);
            bytes[3] = (byte)(value >> 32);
            bytes[4] = (byte)(value >> 24);
            bytes[5] = (byte)(value >> 16);
            bytes[6] = (byte)(value >> 8);
            bytes[7] = (byte)value;
        }
        catch (Exception e) {
            throw new SirixRuntimeException(e.getLocalizedMessage());
        }
        return bytes;
    }

    public static byte[] getBytes(String mValue) {
        byte[] bytes = null;
        try {
            if (mValue == null || mValue.length() == 0) {
                bytes = EMPTY;
            } else {
                StringBuilder builder = new StringBuilder();
                block6: for (int i = 0; i < mValue.length(); ++i) {
                    switch (mValue.charAt(i)) {
                        case '&': {
                            builder.append("&amp;");
                            continue block6;
                        }
                        case '<': {
                            builder.append("&lt;");
                            continue block6;
                        }
                        default: {
                            builder.append(mValue.charAt(i));
                        }
                    }
                }
                bytes = builder.toString().getBytes(Constants.DEFAULT_ENCODING);
            }
            return bytes;
        }
        catch (Exception e) {
            throw new SirixRuntimeException("Could not convert String to byte[]: " + e.getLocalizedMessage());
        }
    }

    public static boolean equals(byte[] mValue1, byte[] mValue2) {
        if (mValue1 == null || mValue2 == null) {
            return false;
        }
        if (mValue1.length != mValue2.length) {
            return false;
        }
        int l = mValue1.length;
        for (int i = 0; i < l; ++i) {
            if (mValue1[i] == mValue2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(byte[] mValue1, String mValue2) {
        return TypedValue.equals(mValue1, TypedValue.getBytes(mValue2));
    }

    public static boolean equals(String mValue1, byte[] mValue2) {
        return TypedValue.equals(TypedValue.getBytes(mValue1), mValue2);
    }

    public static boolean equals(String mValue1, String mValue2) {
        return TypedValue.equals(TypedValue.getBytes(mValue1), TypedValue.getBytes(mValue2));
    }

    public static byte[] getBytes(Double mValue) {
        return mValue.toString().getBytes();
    }

    public static byte[] getBytes(Float mValue) {
        return mValue.toString().getBytes();
    }
}

