/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.access;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.annotation.Nullable;
import org.sirix.access.DatabaseType;
import org.sirix.exception.SirixIOException;

public final class DatabaseConfiguration {
    public static final String BINARY = "0.1.0";
    public static final int MAX_RESOURCE_WTX = 1;
    private final String mBinaryVersion;
    private final Path mFile;
    private long mMaxResourceID;
    private int mMaxResourceReadTrx;
    private DatabaseType mDatabaseType;

    public DatabaseConfiguration(Path file) {
        this.mBinaryVersion = BINARY;
        this.mFile = file;
        this.mMaxResourceReadTrx = 2048;
    }

    public DatabaseConfiguration setMaxResourceReadTrx(int max) {
        Preconditions.checkArgument((max > 0 ? 1 : 0) != 0);
        this.mMaxResourceReadTrx = max;
        return this;
    }

    public DatabaseConfiguration setDatabaseType(DatabaseType type) {
        this.mDatabaseType = (DatabaseType)((Object)Preconditions.checkNotNull((Object)((Object)type)));
        return this;
    }

    public DatabaseType getDatabaseType() {
        return this.mDatabaseType;
    }

    public int getMaxResourceReadTrx() {
        return this.mMaxResourceReadTrx;
    }

    public DatabaseConfiguration setMaximumResourceID(long id) {
        Preconditions.checkArgument((id >= 0L ? 1 : 0) != 0, (Object)"ID must be >= 0!");
        this.mMaxResourceID = id;
        return this;
    }

    public long getMaxResourceID() {
        return this.mMaxResourceID;
    }

    public Path getFile() {
        return this.mFile;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("File", (Object)this.mFile).add("Binary Version", (Object)this.mBinaryVersion).toString();
    }

    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof DatabaseConfiguration)) {
            return false;
        }
        DatabaseConfiguration other = (DatabaseConfiguration)obj;
        return Objects.equal((Object)this.mFile, (Object)other.mFile) && Objects.equal((Object)this.mBinaryVersion, (Object)other.mBinaryVersion);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mFile, this.mBinaryVersion});
    }

    public Path getConfigFile() {
        return this.mFile.resolve(DatabasePaths.CONFIGBINARY.getFile());
    }

    public static void serialize(DatabaseConfiguration config) throws SirixIOException {
        try (FileWriter fileWriter = new FileWriter(config.getConfigFile().toFile());
             JsonWriter jsonWriter = new JsonWriter((Writer)fileWriter);){
            jsonWriter.beginObject();
            String filePath = config.mFile.toAbsolutePath().toString();
            jsonWriter.name("file").value(filePath);
            jsonWriter.name("ID").value(config.mMaxResourceID);
            jsonWriter.name("max-resource-read-trx").value((long)config.mMaxResourceReadTrx);
            jsonWriter.name("databaseType").value(config.mDatabaseType.toString());
            jsonWriter.endObject();
        }
        catch (IOException e) {
            throw new SirixIOException(e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static DatabaseConfiguration deserialize(Path file) throws SirixIOException {
        try (FileReader fileReader = new FileReader(file.resolve(DatabasePaths.CONFIGBINARY.getFile()).toFile());){
            DatabaseConfiguration databaseConfiguration;
            try (JsonReader jsonReader = new JsonReader((Reader)fileReader);){
                jsonReader.beginObject();
                String fileName = jsonReader.nextName();
                assert (fileName.equals("file"));
                Path dbFile = Paths.get(jsonReader.nextString(), new String[0]);
                String IDName = jsonReader.nextName();
                assert (IDName.equals("ID"));
                int ID = jsonReader.nextInt();
                String maxResourceRtxName = jsonReader.nextName();
                assert (maxResourceRtxName.equals("max-resource-read-trx"));
                int maxResourceRtx = jsonReader.nextInt();
                String databaseType = jsonReader.nextName();
                assert (databaseType.equals("databaseType"));
                String type = jsonReader.nextString();
                jsonReader.endObject();
                DatabaseType dbType = DatabaseType.fromString(type).orElseThrow(() -> new IllegalStateException("Type can not be unknown."));
                databaseConfiguration = new DatabaseConfiguration(dbFile).setMaximumResourceID(ID).setMaxResourceReadTrx(maxResourceRtx).setDatabaseType(dbType);
            }
            return databaseConfiguration;
        }
        catch (IOException e) {
            throw new SirixIOException(e);
        }
    }

    public static enum DatabasePaths {
        CONFIGBINARY(Paths.get("dbsetting.obj", new String[0]), false),
        KEYSELECTOR(Paths.get("keyselector", new String[0]), true),
        DATA(Paths.get("resources", new String[0]), true),
        LOCK(Paths.get(".lock", new String[0]), false);

        private final Path mFile;
        private final boolean mIsFolder;

        private DatabasePaths(Path file, boolean isFolder) {
            this.mFile = (Path)Preconditions.checkNotNull((Object)file);
            this.mIsFolder = isFolder;
        }

        public Path getFile() {
            return this.mFile;
        }

        public boolean isFolder() {
            return this.mIsFolder;
        }

        public static int compareStructure(Path file) {
            Preconditions.checkNotNull((Object)file);
            int existing = 0;
            for (DatabasePaths paths : DatabasePaths.values()) {
                Path currentFile = file.resolve(paths.getFile());
                if (!Files.exists(currentFile, new LinkOption[0]) || LOCK.getFile().equals(currentFile)) continue;
                ++existing;
            }
            return existing - DatabasePaths.values().length + 1;
        }
    }
}

