/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.access.trx.node;

import com.google.common.base.Preconditions;
import java.nio.file.Path;
import java.time.Instant;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import org.sirix.access.ResourceConfiguration;
import org.sirix.access.ResourceStore;
import org.sirix.access.trx.node.InternalResourceManager;
import org.sirix.access.trx.page.PageReadTrxImpl;
import org.sirix.access.trx.page.PageWriteTrxFactory;
import org.sirix.api.Database;
import org.sirix.api.NodeCursor;
import org.sirix.api.NodeReadOnlyTrx;
import org.sirix.api.NodeTrx;
import org.sirix.api.PageReadOnlyTrx;
import org.sirix.api.PageTrx;
import org.sirix.api.ResourceManager;
import org.sirix.api.xml.XmlNodeTrx;
import org.sirix.cache.BufferManager;
import org.sirix.exception.SirixException;
import org.sirix.exception.SirixIOException;
import org.sirix.exception.SirixThreadedException;
import org.sirix.exception.SirixUsageException;
import org.sirix.index.path.summary.PathSummaryReader;
import org.sirix.io.Storage;
import org.sirix.io.Writer;
import org.sirix.node.interfaces.Node;
import org.sirix.node.interfaces.Record;
import org.sirix.page.PageKind;
import org.sirix.page.UberPage;
import org.sirix.page.UnorderedKeyValuePage;
import org.sirix.settings.Fixed;

public abstract class AbstractResourceManager<R extends NodeReadOnlyTrx & NodeCursor, W extends NodeTrx & NodeCursor>
implements ResourceManager<R, W>,
InternalResourceManager<R, W> {
    final Database<? extends ResourceManager<R, W>> mDatabase;
    final Lock mWriteLock;
    final Semaphore mReadSemaphore;
    final AtomicReference<UberPage> mLastCommittedUberPage;
    final ConcurrentMap<Long, R> mNodeReaderMap;
    final ConcurrentMap<Long, PageReadOnlyTrx> mPageTrxMap;
    final ConcurrentMap<Long, PageTrx<Long, Record, UnorderedKeyValuePage>> mNodePageTrxMap;
    private final Lock mCommitLock;
    final ResourceConfiguration mResourceConfig;
    final Storage mFac;
    private final AtomicLong mNodeTrxIDCounter;
    final AtomicLong mPageTrxIDCounter;
    volatile boolean mClosed;
    final BufferManager mBufferManager;
    final ResourceStore<? extends ResourceManager<? extends NodeReadOnlyTrx, ? extends NodeTrx>> mResourceStore;

    public AbstractResourceManager(Database<? extends ResourceManager<R, W>> database, @Nonnull ResourceStore<? extends ResourceManager<R, W>> resourceStore, @Nonnull ResourceConfiguration resourceConf, @Nonnull BufferManager bufferManager, @Nonnull Storage storage, @Nonnull UberPage uberPage, @Nonnull Semaphore readSemaphore, @Nonnull Lock writeLock) {
        this.mDatabase = (Database)Preconditions.checkNotNull(database);
        this.mResourceStore = (ResourceStore)Preconditions.checkNotNull(resourceStore);
        this.mResourceConfig = (ResourceConfiguration)Preconditions.checkNotNull((Object)resourceConf);
        this.mBufferManager = (BufferManager)Preconditions.checkNotNull((Object)bufferManager);
        this.mFac = (Storage)Preconditions.checkNotNull((Object)storage);
        this.mNodeReaderMap = new ConcurrentHashMap<Long, R>();
        this.mPageTrxMap = new ConcurrentHashMap<Long, PageReadOnlyTrx>();
        this.mNodePageTrxMap = new ConcurrentHashMap<Long, PageTrx<Long, Record, UnorderedKeyValuePage>>();
        this.mNodeTrxIDCounter = new AtomicLong();
        this.mPageTrxIDCounter = new AtomicLong();
        this.mCommitLock = new ReentrantLock(false);
        this.mReadSemaphore = (Semaphore)Preconditions.checkNotNull((Object)readSemaphore);
        this.mWriteLock = (Lock)Preconditions.checkNotNull((Object)writeLock);
        this.mLastCommittedUberPage = new AtomicReference<UberPage>(uberPage);
        this.mClosed = false;
    }

    private static long timeDiff(long lhs, long rhs) {
        return Math.abs(lhs - rhs);
    }

    @Override
    public PageTrx<Long, Record, UnorderedKeyValuePage> createPageWriteTransaction(@Nonnegative long id, @Nonnegative int representRevision, @Nonnegative int storeRevision, InternalResourceManager.Abort abort, boolean isBoundToNodeTrx) {
        Preconditions.checkArgument((id >= 0L ? 1 : 0) != 0, (Object)"id must be >= 0!");
        Preconditions.checkArgument((representRevision >= 0 ? 1 : 0) != 0, (Object)"representRevision must be >= 0!");
        Preconditions.checkArgument((storeRevision >= 0 ? 1 : 0) != 0, (Object)"storeRevision must be >= 0!");
        Writer writer = this.mFac.createWriter();
        int lastCommitedRev = this.mLastCommittedUberPage.get().getRevisionNumber();
        UberPage lastCommitedUberPage = this.mLastCommittedUberPage.get();
        return new PageWriteTrxFactory().createPageWriteTrx(this, abort == InternalResourceManager.Abort.YES && lastCommitedUberPage.isBootstrap() ? new UberPage() : new UberPage(lastCommitedUberPage, representRevision > 0 ? writer.readUberPageReference().getKey() : -1L), writer, id, representRevision, storeRevision, lastCommitedRev, this.mBufferManager, isBoundToNodeTrx);
    }

    @Override
    public Path getResourcePath() {
        return this.mResourceConfig.resourcePath;
    }

    @Override
    public Lock getCommitLock() {
        return this.mCommitLock;
    }

    @Override
    public R beginNodeReadOnlyTrx() {
        return this.beginNodeReadOnlyTrx(this.mLastCommittedUberPage.get().getRevisionNumber());
    }

    @Override
    public synchronized R beginNodeReadOnlyTrx(@Nonnegative int revisionKey) {
        this.assertAccess(revisionKey);
        try {
            if (!this.mReadSemaphore.tryAcquire(20L, TimeUnit.SECONDS)) {
                throw new SirixUsageException(new String[]{"No read transactions available, please close at least one read transaction at first!"});
            }
        }
        catch (InterruptedException e) {
            throw new SirixThreadedException(e);
        }
        PageReadOnlyTrx pageReadTrx = this.beginPageReadOnlyTrx(revisionKey);
        Node documentNode = AbstractResourceManager.getDocumentNode(pageReadTrx);
        R reader = this.createNodeReadOnlyTrx(this.mNodeTrxIDCounter.incrementAndGet(), pageReadTrx, documentNode);
        if (this.mNodeReaderMap.put(reader.getId(), reader) != null) {
            throw new SirixUsageException(new String[]{"ID generation is bogus because of duplicate ID."});
        }
        return reader;
    }

    public abstract R createNodeReadOnlyTrx(long var1, PageReadOnlyTrx var3, Node var4);

    public abstract W createNodeReadWriteTrx(long var1, PageTrx<Long, Record, UnorderedKeyValuePage> var3, int var4, TimeUnit var5, int var6, Node var7);

    static Node getDocumentNode(PageReadOnlyTrx pageReadTrx) {
        Optional<? extends Record> node = pageReadTrx.getRecord(Fixed.DOCUMENT_NODE_KEY.getStandardProperty(), PageKind.RECORDPAGE, -1);
        if (!node.isPresent()) {
            pageReadTrx.close();
            throw new IllegalStateException("Node couldn't be fetched from persistent storage!");
        }
        Node documentNode = (Node)node.get();
        return documentNode;
    }

    @Override
    public Path getCommitFile() {
        return this.mResourceConfig.resourcePath.resolve(ResourceConfiguration.ResourcePaths.TRANSACTION_INTENT_LOG.getPath()).resolve(".commit");
    }

    @Override
    public W beginNodeTrx() {
        return this.beginNodeTrx(0, TimeUnit.MINUTES, 0);
    }

    @Override
    public W beginNodeTrx(@Nonnegative int maxNodeCount) {
        return this.beginNodeTrx(maxNodeCount, TimeUnit.MINUTES, 0);
    }

    @Override
    public W beginNodeTrx(@Nonnull TimeUnit timeUnit, @Nonnegative int maxTime) {
        return this.beginNodeTrx(0, timeUnit, maxTime);
    }

    @Override
    public synchronized W beginNodeTrx(@Nonnegative int maxNodeCount, @Nonnull TimeUnit timeUnit, @Nonnegative int maxTime) {
        this.assertAccess(this.mLastCommittedUberPage.get().getRevision());
        if (maxNodeCount < 0 || maxTime < 0) {
            throw new SirixUsageException(new String[]{"maxNodeCount may not be < 0!"});
        }
        Preconditions.checkNotNull((Object)((Object)timeUnit));
        try {
            if (!this.mWriteLock.tryLock(20L, TimeUnit.SECONDS)) {
                throw new SirixUsageException(new String[]{"No write transaction available, please close the write transaction first."});
            }
        }
        catch (InterruptedException e) {
            throw new SirixThreadedException(e);
        }
        try {
            if (!this.mReadSemaphore.tryAcquire(20L, TimeUnit.SECONDS)) {
                throw new SirixUsageException(new String[]{"No read transactions available, please close at least one read transaction at first!"});
            }
        }
        catch (InterruptedException e) {
            throw new SirixThreadedException(e);
        }
        long nodeTrxId = this.mNodeTrxIDCounter.incrementAndGet();
        int lastRev = this.mLastCommittedUberPage.get().getRevisionNumber();
        PageTrx<Long, Record, UnorderedKeyValuePage> pageWtx = this.createPageWriteTransaction(nodeTrxId, lastRev, lastRev, InternalResourceManager.Abort.NO, true);
        Node documentNode = AbstractResourceManager.getDocumentNode(pageWtx);
        W wtx = this.createNodeReadWriteTrx(nodeTrxId, pageWtx, maxNodeCount, timeUnit, maxTime, documentNode);
        if (this.mNodeReaderMap.put(nodeTrxId, wtx) != null || this.mNodePageTrxMap.put(nodeTrxId, pageWtx) != null) {
            throw new SirixThreadedException("ID generation is bogus because of duplicate ID.");
        }
        return wtx;
    }

    @Override
    public synchronized void close() {
        if (!this.mClosed) {
            for (AutoCloseable rtx : this.mNodeReaderMap.values()) {
                if (rtx instanceof XmlNodeTrx) {
                    ((XmlNodeTrx)rtx).rollback();
                }
                rtx.close();
                rtx = null;
            }
            for (AutoCloseable rtx : this.mNodePageTrxMap.values()) {
                rtx.close();
                rtx = null;
            }
            for (AutoCloseable rtx : this.mPageTrxMap.values()) {
                rtx.close();
                Object var2_2 = null;
            }
            this.mNodeReaderMap.clear();
            this.mPageTrxMap.clear();
            this.mNodePageTrxMap.clear();
            this.mResourceStore.closeResource(this.mResourceConfig.getResource());
            this.mFac.close();
            this.mClosed = true;
        }
    }

    @Override
    public void assertAccess(@Nonnegative int revision) {
        if (this.mClosed) {
            throw new IllegalStateException("Resource manager is already closed!");
        }
        if (revision < 0) {
            throw new IllegalArgumentException("Revision must be at least 0!");
        }
        if (revision > this.mLastCommittedUberPage.get().getRevision()) {
            throw new IllegalArgumentException("Revision must not be bigger than " + Long.toString(this.mLastCommittedUberPage.get().getRevision()) + "!");
        }
    }

    @Override
    public int getAvailableNodeReadTrx() {
        return this.mReadSemaphore.availablePermits();
    }

    @Override
    public boolean hasRunningNodeWriteTrx() {
        if (this.mWriteLock.tryLock()) {
            this.mWriteLock.unlock();
            return true;
        }
        return false;
    }

    @Override
    public void setNodePageWriteTransaction(@Nonnegative long transactionID, @Nonnull PageTrx<Long, Record, UnorderedKeyValuePage> pageWriteTrx) {
        this.mNodePageTrxMap.put(transactionID, pageWriteTrx);
    }

    @Override
    public void closeNodePageWriteTransaction(@Nonnegative long transactionID) throws SirixIOException {
        PageReadOnlyTrx pageRtx = (PageReadOnlyTrx)this.mNodePageTrxMap.remove(transactionID);
        if (pageRtx != null) {
            pageRtx.close();
        }
    }

    @Override
    public void closeWriteTransaction(@Nonnegative long transactionID) {
        this.removeFromPageMapping(transactionID);
        this.mWriteLock.unlock();
    }

    @Override
    public void closeReadTransaction(@Nonnegative long transactionID) {
        this.removeFromPageMapping(transactionID);
        this.mReadSemaphore.release();
    }

    @Override
    public void closePageWriteTransaction(@Nonnegative long transactionID) {
        this.mPageTrxMap.remove(transactionID);
        this.mWriteLock.unlock();
    }

    @Override
    public void closePageReadTransaction(@Nonnegative long transactionID) {
        this.mPageTrxMap.remove(transactionID);
        this.mReadSemaphore.release();
    }

    private void removeFromPageMapping(@Nonnegative long transactionID) {
        this.mNodeReaderMap.remove(transactionID);
        this.mNodePageTrxMap.remove(transactionID);
    }

    @Override
    public synchronized boolean isClosed() {
        return this.mClosed;
    }

    @Override
    public void setLastCommittedUberPage(UberPage page) {
        this.mLastCommittedUberPage.set((UberPage)Preconditions.checkNotNull((Object)page));
    }

    @Override
    public ResourceConfiguration getResourceConfig() {
        return this.mResourceConfig;
    }

    @Override
    public int getMostRecentRevisionNumber() {
        return this.mLastCommittedUberPage.get().getRevisionNumber();
    }

    @Override
    public synchronized PathSummaryReader openPathSummary(@Nonnegative int revision) {
        this.assertAccess(revision);
        PageReadOnlyTrx pageReadTrx = this.beginPageReadOnlyTrx(revision);
        return PathSummaryReader.getInstance(pageReadTrx, this);
    }

    @Override
    public PathSummaryReader openPathSummary() {
        return this.openPathSummary(this.mLastCommittedUberPage.get().getRevisionNumber());
    }

    @Override
    public PageReadOnlyTrx beginPageReadTrx() {
        return this.beginPageReadOnlyTrx(this.mLastCommittedUberPage.get().getRevisionNumber());
    }

    @Override
    public synchronized PageReadOnlyTrx beginPageReadOnlyTrx(@Nonnegative int revision) {
        this.assertAccess(revision);
        try {
            if (!this.mReadSemaphore.tryAcquire(20L, TimeUnit.SECONDS)) {
                throw new SirixUsageException(new String[]{"No read transactions available, please close at least one read transaction at first!"});
            }
        }
        catch (InterruptedException e) {
            throw new SirixThreadedException(e);
        }
        long currentPageTrxID = this.mPageTrxIDCounter.incrementAndGet();
        PageReadTrxImpl pageReadTrx = new PageReadTrxImpl(currentPageTrxID, this, this.mLastCommittedUberPage.get(), revision, this.mFac.createReader(), null, null, this.mBufferManager);
        if (this.mPageTrxMap.put(currentPageTrxID, pageReadTrx) != null) {
            throw new SirixThreadedException("ID generation is bogus because of duplicate ID.");
        }
        return pageReadTrx;
    }

    @Override
    public PageTrx<Long, Record, UnorderedKeyValuePage> beginPageTrx() throws SirixException {
        return this.beginPageTrx(this.mLastCommittedUberPage.get().getRevisionNumber());
    }

    @Override
    public synchronized PageTrx<Long, Record, UnorderedKeyValuePage> beginPageTrx(@Nonnegative int revision) throws SirixException {
        this.assertAccess(revision);
        try {
            if (!this.mWriteLock.tryLock(20L, TimeUnit.SECONDS)) {
                throw new SirixUsageException(new String[]{"No write transaction available, please close the write transaction first."});
            }
        }
        catch (InterruptedException e) {
            throw new SirixThreadedException(e);
        }
        try {
            if (!this.mReadSemaphore.tryAcquire(20L, TimeUnit.SECONDS)) {
                throw new SirixUsageException(new String[]{"No read transactions available, please close at least one read transaction at first!"});
            }
        }
        catch (InterruptedException e) {
            throw new SirixThreadedException(e);
        }
        long currentPageTrxID = this.mPageTrxIDCounter.incrementAndGet();
        int lastRev = this.mLastCommittedUberPage.get().getRevisionNumber();
        PageTrx<Long, Record, UnorderedKeyValuePage> pageWtx = this.createPageWriteTransaction(currentPageTrxID, lastRev, lastRev, InternalResourceManager.Abort.NO, false);
        if (this.mPageTrxMap.put(currentPageTrxID, pageWtx) != null) {
            throw new SirixThreadedException("ID generation is bogus because of duplicate ID.");
        }
        return pageWtx;
    }

    @Override
    public synchronized Database<?> getDatabase() {
        return this.mDatabase;
    }

    @Override
    public Optional<R> getNodeReadTrxByTrxId(long ID) {
        return Optional.ofNullable((NodeReadOnlyTrx)this.mNodeReaderMap.get(ID));
    }

    @Override
    public Optional<R> getNodeReadTrxByRevisionNumber(int revision) {
        return this.mNodeReaderMap.values().stream().filter(rtx -> rtx.getRevisionNumber() == revision).findFirst();
    }

    @Override
    public synchronized Optional<W> getNodeWriteTrx() {
        return this.mNodeReaderMap.values().stream().filter(rtx -> rtx instanceof NodeTrx).map(rtx -> (NodeTrx)rtx).findAny();
    }

    @Override
    public R beginNodeReadOnlyTrx(Instant pointInTime) {
        Preconditions.checkNotNull((Object)pointInTime);
        long timestamp = pointInTime.toEpochMilli();
        int revision = this.binarySearch(timestamp);
        if (revision < 0) {
            revision = -revision - 1;
        }
        if (revision == 0) {
            return this.beginNodeReadOnlyTrx(0);
        }
        if (revision == this.getMostRecentRevisionNumber() + 1) {
            return this.beginNodeReadOnlyTrx();
        }
        R rtxRevisionMinus1 = this.beginNodeReadOnlyTrx(revision - 1);
        R rtxRevision = this.beginNodeReadOnlyTrx(revision);
        if (AbstractResourceManager.timeDiff(timestamp, rtxRevisionMinus1.getRevisionTimestamp().toEpochMilli()) < AbstractResourceManager.timeDiff(timestamp, rtxRevision.getRevisionTimestamp().toEpochMilli())) {
            rtxRevision.close();
            return rtxRevisionMinus1;
        }
        rtxRevisionMinus1.close();
        return rtxRevision;
    }

    private int binarySearch(long timestamp) {
        int low = 0;
        int high = this.getMostRecentRevisionNumber();
        while (low <= high) {
            int mid = low + high >>> 1;
            PageReadOnlyTrx trx = this.beginPageReadOnlyTrx(mid);
            try {
                long midVal = trx.getActualRevisionRootPage().getRevisionTimestamp();
                int cmp = Instant.ofEpochMilli(midVal).compareTo(Instant.ofEpochMilli(timestamp));
                if (cmp < 0) {
                    low = mid + 1;
                    continue;
                }
                if (cmp > 0) {
                    high = mid - 1;
                    continue;
                }
                int n = mid;
                return n;
            }
            finally {
                if (trx == null) continue;
                trx.close();
            }
        }
        return -(low + 1);
    }

    @Override
    public int getRevisionNumber(Instant pointInTime) {
        Preconditions.checkNotNull((Object)pointInTime);
        long timestamp = pointInTime.toEpochMilli();
        int revision = this.binarySearch(timestamp);
        if (revision < 0) {
            revision = -revision - 1;
        }
        if (revision == 0) {
            return 0;
        }
        if (revision == this.getMostRecentRevisionNumber() + 1) {
            return this.getMostRecentRevisionNumber();
        }
        try (R rtxRevisionMinus1 = this.beginNodeReadOnlyTrx(revision - 1);){
            R rtxRevision = this.beginNodeReadOnlyTrx(revision);
            try {
                int revisionNumber = AbstractResourceManager.timeDiff(timestamp, rtxRevisionMinus1.getRevisionTimestamp().toEpochMilli()) < AbstractResourceManager.timeDiff(timestamp, rtxRevision.getRevisionTimestamp().toEpochMilli()) ? rtxRevisionMinus1.getRevisionNumber() : rtxRevision.getRevisionNumber();
                int n = revisionNumber;
                if (rtxRevision != null) {
                    rtxRevision.close();
                }
                return n;
            }
            catch (Throwable throwable) {
                if (rtxRevision != null) {
                    try {
                        rtxRevision.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
    }
}

