/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.access.trx.node;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.Set;
import org.brackit.xquery.atomic.Atomic;
import org.brackit.xquery.node.d2linked.D2NodeBuilder;
import org.brackit.xquery.node.parser.DocumentParser;
import org.brackit.xquery.node.parser.SubtreeHandler;
import org.brackit.xquery.util.path.PathException;
import org.brackit.xquery.xdm.DocumentException;
import org.brackit.xquery.xdm.node.Node;
import org.sirix.access.ResourceConfiguration;
import org.sirix.access.trx.node.xml.XmlIndexController;
import org.sirix.api.NodeCursor;
import org.sirix.api.NodeReadOnlyTrx;
import org.sirix.api.NodeTrx;
import org.sirix.api.PageReadOnlyTrx;
import org.sirix.api.ResourceManager;
import org.sirix.exception.SirixException;
import org.sirix.exception.SirixIOException;
import org.sirix.index.IndexDef;
import org.sirix.index.IndexType;
import org.sirix.index.Indexes;
import org.sirix.index.SearchMode;
import org.sirix.index.avltree.keyvalue.NodeReferences;
import org.sirix.index.cas.CASFilter;
import org.sirix.index.cas.CASFilterRange;
import org.sirix.index.name.NameFilter;
import org.sirix.index.path.PCRCollector;
import org.sirix.index.path.PathFilter;
import org.sirix.node.interfaces.immutable.ImmutableNode;

public interface IndexController<R extends NodeReadOnlyTrx & NodeCursor, W extends NodeTrx & NodeCursor> {
    public boolean containsIndex(IndexType var1);

    public static boolean containsIndex(IndexType type, ResourceManager<?, ?> resourceManager, int revision) {
        Indexes indexes;
        block8: {
            indexes = new Indexes();
            Path indexesFile = resourceManager.getResourcePath().resolve(ResourceConfiguration.ResourcePaths.INDEXES.getPath()).resolve(String.valueOf(revision) + ".xml");
            try {
                if (!Files.exists(indexesFile, new LinkOption[0]) || Files.size(indexesFile) <= 0L) break block8;
                try (FileInputStream in = new FileInputStream(indexesFile.toFile());){
                    indexes.init(IndexController.deserialize(in).getFirstChild());
                }
            }
            catch (IOException | DocumentException | SirixException e) {
                throw new SirixIOException("Index definitions couldn't be deserialized!", e);
            }
        }
        for (IndexDef indexDef : indexes.getIndexDefs()) {
            if (indexDef.getType() != type) continue;
            return true;
        }
        return false;
    }

    public Indexes getIndexes();

    public void serialize(OutputStream var1);

    public void notifyChange(XmlIndexController.ChangeType var1, ImmutableNode var2, long var3);

    public IndexController<R, W> createIndexes(Set<IndexDef> var1, W var2);

    public IndexController<R, W> createIndexListeners(Set<IndexDef> var1, W var2);

    public NameFilter createNameFilter(String[] var1);

    public PathFilter createPathFilter(String[] var1, R var2) throws PathException;

    public CASFilter createCASFilter(String[] var1, Atomic var2, SearchMode var3, PCRCollector var4) throws PathException;

    public CASFilterRange createCASFilterRange(String[] var1, Atomic var2, Atomic var3, boolean var4, boolean var5, PCRCollector var6) throws PathException;

    public Iterator<NodeReferences> openPathIndex(PageReadOnlyTrx var1, IndexDef var2, PathFilter var3);

    public Iterator<NodeReferences> openNameIndex(PageReadOnlyTrx var1, IndexDef var2, NameFilter var3);

    public Iterator<NodeReferences> openCASIndex(PageReadOnlyTrx var1, IndexDef var2, CASFilter var3);

    public Iterator<NodeReferences> openCASIndex(PageReadOnlyTrx var1, IndexDef var2, CASFilterRange var3);

    public static Node<?> deserialize(InputStream in) throws SirixException {
        try {
            DocumentParser parser = new DocumentParser(in);
            D2NodeBuilder builder = new D2NodeBuilder();
            parser.parse((SubtreeHandler)builder);
            return builder.root();
        }
        catch (DocumentException e) {
            throw new SirixException(e);
        }
    }
}

