/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.access.trx.node.json;

import java.util.HashSet;
import java.util.Set;
import org.brackit.xquery.atomic.QNm;
import org.brackit.xquery.util.path.Path;
import org.brackit.xquery.util.path.PathException;
import org.sirix.access.trx.node.AbstractIndexController;
import org.sirix.api.PageTrx;
import org.sirix.api.json.JsonNodeReadOnlyTrx;
import org.sirix.api.json.JsonNodeTrx;
import org.sirix.api.visitor.JsonNodeVisitor;
import org.sirix.index.ChangeListener;
import org.sirix.index.IndexBuilder;
import org.sirix.index.IndexDef;
import org.sirix.index.Indexes;
import org.sirix.index.cas.json.JsonCASIndexImpl;
import org.sirix.index.name.json.JsonNameIndexImpl;
import org.sirix.index.path.PathFilter;
import org.sirix.index.path.json.JsonPCRCollector;
import org.sirix.index.path.json.JsonPathIndexImpl;
import org.sirix.index.path.summary.PathSummaryReader;
import org.sirix.node.interfaces.Record;
import org.sirix.page.UnorderedKeyValuePage;

public final class JsonIndexController
extends AbstractIndexController<JsonNodeReadOnlyTrx, JsonNodeTrx> {
    public JsonIndexController() {
        super(new Indexes(), new HashSet<ChangeListener>(), new JsonPathIndexImpl(), new JsonCASIndexImpl(), new JsonNameIndexImpl());
    }

    public JsonIndexController createIndexes(Set<IndexDef> indexDefs, JsonNodeTrx nodeWriteTrx) {
        IndexBuilder.build(nodeWriteTrx, this.createIndexBuilders(indexDefs, nodeWriteTrx));
        this.createIndexListeners(indexDefs, nodeWriteTrx);
        return this;
    }

    Set<JsonNodeVisitor> createIndexBuilders(Set<IndexDef> indexDefs, JsonNodeTrx nodeWriteTrx) {
        HashSet<JsonNodeVisitor> indexBuilders = new HashSet<JsonNodeVisitor>(indexDefs.size());
        for (IndexDef indexDef : indexDefs) {
            switch (indexDef.getType()) {
                case PATH: {
                    indexBuilders.add(this.createPathIndexBuilder(nodeWriteTrx.getPageWtx(), nodeWriteTrx.getPathSummary(), indexDef));
                    break;
                }
                case CAS: {
                    indexBuilders.add(this.createCASIndexBuilder(nodeWriteTrx, nodeWriteTrx.getPageWtx(), nodeWriteTrx.getPathSummary(), indexDef));
                    break;
                }
                case NAME: {
                    indexBuilders.add(this.createNameIndexBuilder(nodeWriteTrx.getPageWtx(), indexDef));
                    break;
                }
            }
        }
        return indexBuilders;
    }

    @Override
    public PathFilter createPathFilter(String[] queryString, JsonNodeReadOnlyTrx rtx) throws PathException {
        HashSet<Path<QNm>> paths = new HashSet<Path<QNm>>(queryString.length);
        for (String path : queryString) {
            paths.add(Path.parse((String)path));
        }
        return new PathFilter(paths, new JsonPCRCollector(rtx));
    }

    private JsonNodeVisitor createPathIndexBuilder(PageTrx<Long, Record, UnorderedKeyValuePage> pageWriteTrx, PathSummaryReader pathSummaryReader, IndexDef indexDef) {
        return (JsonNodeVisitor)this.mPathIndex.createBuilder(pageWriteTrx, pathSummaryReader, indexDef);
    }

    private JsonNodeVisitor createCASIndexBuilder(JsonNodeReadOnlyTrx nodeReadTrx, PageTrx<Long, Record, UnorderedKeyValuePage> pageWriteTrx, PathSummaryReader pathSummaryReader, IndexDef indexDef) {
        return (JsonNodeVisitor)this.mCASIndex.createBuilder(nodeReadTrx, pageWriteTrx, pathSummaryReader, indexDef);
    }

    private JsonNodeVisitor createNameIndexBuilder(PageTrx<Long, Record, UnorderedKeyValuePage> pageWriteTrx, IndexDef indexDef) {
        return (JsonNodeVisitor)this.mNameIndex.createBuilder(pageWriteTrx, indexDef);
    }

    public static enum ChangeType {
        INSERT,
        DELETE;

    }
}

