/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.access.trx.node.json;

import com.google.common.base.Preconditions;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import org.brackit.xquery.atomic.QNm;
import org.sirix.access.trx.node.json.JsonNodeFactory;
import org.sirix.api.PageTrx;
import org.sirix.index.path.summary.PathNode;
import org.sirix.node.Kind;
import org.sirix.node.delegates.NameNodeDelegate;
import org.sirix.node.delegates.NodeDelegate;
import org.sirix.node.delegates.StructNodeDelegate;
import org.sirix.node.delegates.ValNodeDelegate;
import org.sirix.node.interfaces.Record;
import org.sirix.node.json.ArrayNode;
import org.sirix.node.json.BooleanNode;
import org.sirix.node.json.NullNode;
import org.sirix.node.json.NumberNode;
import org.sirix.node.json.ObjectNode;
import org.sirix.node.json.ObjectRecordNode;
import org.sirix.node.json.StringNode;
import org.sirix.page.PageKind;
import org.sirix.page.PathSummaryPage;
import org.sirix.page.UnorderedKeyValuePage;
import org.sirix.settings.Fixed;
import org.sirix.utils.Compression;
import org.sirix.utils.NamePageHash;

final class JsonNodeFactoryImpl
implements JsonNodeFactory {
    private final PageTrx<Long, Record, UnorderedKeyValuePage> mPageWriteTrx;

    JsonNodeFactoryImpl(PageTrx<Long, Record, UnorderedKeyValuePage> pageWriteTrx) {
        this.mPageWriteTrx = (PageTrx)Preconditions.checkNotNull(pageWriteTrx);
        pageWriteTrx.createNameKey("array", Kind.ARRAY);
    }

    @Override
    public PathNode createPathNode(@Nonnegative long parentKey, long leftSibKey, long rightSibKey, @Nonnull QNm name, @Nonnull Kind kind, @Nonnegative int level) {
        int uriKey = NamePageHash.generateHashForString(name.getNamespaceURI());
        int prefixKey = name.getPrefix() != null && !name.getPrefix().isEmpty() ? NamePageHash.generateHashForString(name.getPrefix()) : -1;
        int localName = name.getLocalName() != null && !name.getLocalName().isEmpty() ? NamePageHash.generateHashForString(name.getLocalName()) : -1;
        long revision = this.mPageWriteTrx.getRevisionNumber();
        NodeDelegate nodeDel = new NodeDelegate(((PathSummaryPage)this.mPageWriteTrx.getActualRevisionRootPage().getPathSummaryPageReference().getPage()).getMaxNodeKey(0) + 1L, parentKey, 0L, revision, null);
        StructNodeDelegate structDel = new StructNodeDelegate(nodeDel, Fixed.NULL_NODE_KEY.getStandardProperty(), rightSibKey, leftSibKey, 0L, 0L);
        NameNodeDelegate nameDel = new NameNodeDelegate(nodeDel, uriKey, prefixKey, localName, 0L);
        return (PathNode)this.mPageWriteTrx.createEntry(nodeDel.getNodeKey(), new PathNode(nodeDel, structDel, nameDel, kind, 1, level), PageKind.PATHSUMMARYPAGE, 0);
    }

    @Override
    public ArrayNode createJsonArrayNode(long parentKey, long leftSibKey, long rightSibKey, long pathNodeKey) {
        long revision = this.mPageWriteTrx.getRevisionNumber();
        NodeDelegate nodeDel = new NodeDelegate(this.mPageWriteTrx.getActualRevisionRootPage().getMaxNodeKey() + 1L, parentKey, 0L, revision, null);
        StructNodeDelegate structDel = new StructNodeDelegate(nodeDel, Fixed.NULL_NODE_KEY.getStandardProperty(), rightSibKey, leftSibKey, 0L, 0L);
        return (ArrayNode)this.mPageWriteTrx.createEntry(nodeDel.getNodeKey(), new ArrayNode(structDel, pathNodeKey), PageKind.RECORDPAGE, -1);
    }

    @Override
    public ObjectNode createJsonObjectNode(long parentKey, long leftSibKey, long rightSibKey) {
        long revision = this.mPageWriteTrx.getRevisionNumber();
        NodeDelegate nodeDel = new NodeDelegate(this.mPageWriteTrx.getActualRevisionRootPage().getMaxNodeKey() + 1L, parentKey, 0L, revision, null);
        StructNodeDelegate structDel = new StructNodeDelegate(nodeDel, Fixed.NULL_NODE_KEY.getStandardProperty(), rightSibKey, leftSibKey, 0L, 0L);
        return (ObjectNode)this.mPageWriteTrx.createEntry(nodeDel.getNodeKey(), new ObjectNode(structDel), PageKind.RECORDPAGE, -1);
    }

    @Override
    public NullNode createJsonNullNode(long parentKey, long leftSibKey, long rightSibKey) {
        long revision = this.mPageWriteTrx.getRevisionNumber();
        NodeDelegate nodeDel = new NodeDelegate(this.mPageWriteTrx.getActualRevisionRootPage().getMaxNodeKey() + 1L, parentKey, 0L, revision, null);
        StructNodeDelegate structDel = new StructNodeDelegate(nodeDel, Fixed.NULL_NODE_KEY.getStandardProperty(), rightSibKey, leftSibKey, 0L, 0L);
        return (NullNode)this.mPageWriteTrx.createEntry(nodeDel.getNodeKey(), new NullNode(structDel), PageKind.RECORDPAGE, -1);
    }

    @Override
    public ObjectRecordNode createJsonObjectKeyNode(long parentKey, long leftSibKey, long rightSibKey, long pathNodeKey, String name, long objectValueKey) {
        int localNameKey = this.mPageWriteTrx.createNameKey(name, Kind.OBJECT_RECORD);
        long revision = this.mPageWriteTrx.getRevisionNumber();
        NodeDelegate nodeDel = new NodeDelegate(this.mPageWriteTrx.getActualRevisionRootPage().getMaxNodeKey() + 1L, parentKey, 0L, revision, null);
        StructNodeDelegate structDel = new StructNodeDelegate(nodeDel, objectValueKey, rightSibKey, leftSibKey, 0L, 0L);
        return (ObjectRecordNode)this.mPageWriteTrx.createEntry(nodeDel.getNodeKey(), new ObjectRecordNode(structDel, localNameKey, name, pathNodeKey), PageKind.RECORDPAGE, -1);
    }

    @Override
    public StringNode createJsonStringNode(long parentKey, long leftSibKey, long rightSibKey, byte[] value, boolean doCompress) {
        long revision = this.mPageWriteTrx.getRevisionNumber();
        NodeDelegate nodeDel = new NodeDelegate(this.mPageWriteTrx.getActualRevisionRootPage().getMaxNodeKey() + 1L, parentKey, 0L, revision, null);
        boolean compression = doCompress && value.length > 10;
        byte[] compressedValue = compression ? Compression.compress(value, 2) : value;
        ValNodeDelegate valDel = new ValNodeDelegate(nodeDel, compressedValue, compression);
        StructNodeDelegate structDel = new StructNodeDelegate(nodeDel, Fixed.NULL_NODE_KEY.getStandardProperty(), rightSibKey, leftSibKey, 0L, 0L);
        return (StringNode)this.mPageWriteTrx.createEntry(nodeDel.getNodeKey(), new StringNode(valDel, structDel), PageKind.RECORDPAGE, -1);
    }

    @Override
    public BooleanNode createJsonBooleanNode(long parentKey, long leftSibKey, long rightSibKey, boolean boolValue) {
        long revision = this.mPageWriteTrx.getRevisionNumber();
        NodeDelegate nodeDel = new NodeDelegate(this.mPageWriteTrx.getActualRevisionRootPage().getMaxNodeKey() + 1L, parentKey, 0L, revision, null);
        StructNodeDelegate structDel = new StructNodeDelegate(nodeDel, Fixed.NULL_NODE_KEY.getStandardProperty(), rightSibKey, leftSibKey, 0L, 0L);
        return (BooleanNode)this.mPageWriteTrx.createEntry(nodeDel.getNodeKey(), new BooleanNode(boolValue, structDel), PageKind.RECORDPAGE, -1);
    }

    @Override
    public NumberNode createJsonNumberNode(long parentKey, long leftSibKey, long rightSibKey, Number value) {
        long revision = this.mPageWriteTrx.getRevisionNumber();
        NodeDelegate nodeDel = new NodeDelegate(this.mPageWriteTrx.getActualRevisionRootPage().getMaxNodeKey() + 1L, parentKey, 0L, revision, null);
        StructNodeDelegate structDel = new StructNodeDelegate(nodeDel, Fixed.NULL_NODE_KEY.getStandardProperty(), rightSibKey, leftSibKey, 0L, 0L);
        return (NumberNode)this.mPageWriteTrx.createEntry(nodeDel.getNodeKey(), new NumberNode(value, structDel), PageKind.RECORDPAGE, -1);
    }
}

