/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.access.trx.node.json;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Optional;
import javax.annotation.Nonnegative;
import org.brackit.xquery.atomic.QNm;
import org.sirix.access.trx.node.AbstractNodeReadTrx;
import org.sirix.access.trx.node.InternalResourceManager;
import org.sirix.access.trx.node.Move;
import org.sirix.access.trx.node.json.InternalJsonNodeReadOnlyTrx;
import org.sirix.api.PageReadOnlyTrx;
import org.sirix.api.json.JsonNodeReadOnlyTrx;
import org.sirix.api.json.JsonNodeTrx;
import org.sirix.api.json.JsonResourceManager;
import org.sirix.api.visitor.JsonNodeVisitor;
import org.sirix.api.visitor.VisitResult;
import org.sirix.exception.SirixIOException;
import org.sirix.node.Kind;
import org.sirix.node.interfaces.Node;
import org.sirix.node.interfaces.Record;
import org.sirix.node.interfaces.ValueNode;
import org.sirix.node.interfaces.immutable.ImmutableJsonNode;
import org.sirix.node.interfaces.immutable.ImmutableNode;
import org.sirix.node.json.ArrayNode;
import org.sirix.node.json.BooleanNode;
import org.sirix.node.json.NullNode;
import org.sirix.node.json.NumberNode;
import org.sirix.node.json.ObjectNode;
import org.sirix.node.json.ObjectRecordNode;
import org.sirix.node.json.StringNode;
import org.sirix.page.PageKind;
import org.sirix.settings.Constants;

public final class JsonNodeReadOnlyTrxImpl
extends AbstractNodeReadTrx<JsonNodeReadOnlyTrx>
implements InternalJsonNodeReadOnlyTrx {
    private final long mTrxId;
    protected final InternalResourceManager<JsonNodeReadOnlyTrx, JsonNodeTrx> mResourceManager;
    private boolean mIsClosed;

    JsonNodeReadOnlyTrxImpl(InternalResourceManager<JsonNodeReadOnlyTrx, JsonNodeTrx> resourceManager, @Nonnegative long trxId, PageReadOnlyTrx pageReadTransaction, ImmutableJsonNode documentNode) {
        super(trxId, pageReadTransaction, documentNode);
        this.mResourceManager = (InternalResourceManager)Preconditions.checkNotNull(resourceManager);
        Preconditions.checkArgument((trxId >= 0L ? 1 : 0) != 0);
        this.mTrxId = trxId;
        this.mIsClosed = false;
    }

    @Override
    public Move<JsonNodeReadOnlyTrx> moveTo(long nodeKey) {
        Optional<Object> newNode;
        this.assertNotClosed();
        ImmutableNode oldNode = this.mCurrentNode;
        try {
            if (nodeKey < 0L) {
                newNode = Optional.empty();
            } else {
                Optional<? extends Record> node = this.mPageReadTrx.getRecord(nodeKey, PageKind.RECORDPAGE, -1);
                newNode = node;
            }
        }
        catch (SirixIOException e) {
            newNode = Optional.empty();
        }
        if (newNode.isPresent()) {
            this.mCurrentNode = (Node)newNode.get();
            return Move.moved(this);
        }
        this.mCurrentNode = oldNode;
        return Move.notMoved();
    }

    @Override
    public String getValue() {
        String returnVal;
        this.assertNotClosed();
        switch (this.mCurrentNode.getKind()) {
            case STRING_VALUE: {
                returnVal = new String(((ValueNode)this.mCurrentNode).getRawValue(), Constants.DEFAULT_ENCODING);
                break;
            }
            case BOOLEAN_VALUE: {
                returnVal = String.valueOf(((BooleanNode)this.mCurrentNode).getValue());
                break;
            }
            case NULL_VALUE: {
                returnVal = "null";
                break;
            }
            case NUMBER_VALUE: {
                returnVal = String.valueOf(((NumberNode)this.mCurrentNode).getValue());
                break;
            }
            default: {
                returnVal = "";
            }
        }
        return returnVal;
    }

    @Override
    public boolean getBooleanValue() {
        this.assertNotClosed();
        if (this.mCurrentNode.getKind() == Kind.BOOLEAN_VALUE) {
            return ((BooleanNode)this.mCurrentNode).getValue();
        }
        throw new IllegalStateException("Current node is no boolean node.");
    }

    @Override
    public Number getNumberValue() {
        this.assertNotClosed();
        if (this.mCurrentNode.getKind() == Kind.NUMBER_VALUE) {
            return ((NumberNode)this.mCurrentNode).getValue();
        }
        throw new IllegalStateException("Current node is no number node.");
    }

    @Override
    public void assertNotClosed() {
        if (this.mIsClosed) {
            throw new IllegalStateException("Transaction is already closed.");
        }
    }

    @Override
    public JsonResourceManager getResourceManager() {
        this.assertNotClosed();
        return (JsonResourceManager)((Object)this.mResourceManager);
    }

    @Override
    public ImmutableNode getNode() {
        this.assertNotClosed();
        return this.mCurrentNode;
    }

    @Override
    public boolean isArray() {
        this.assertNotClosed();
        return this.mCurrentNode instanceof ArrayNode;
    }

    @Override
    public boolean isObject() {
        this.assertNotClosed();
        return this.mCurrentNode instanceof ObjectNode;
    }

    @Override
    public boolean isObjectKey() {
        this.assertNotClosed();
        return this.mCurrentNode instanceof ObjectRecordNode;
    }

    @Override
    public boolean isNumberValue() {
        this.assertNotClosed();
        return this.mCurrentNode instanceof NumberNode;
    }

    @Override
    public boolean isNullValue() {
        this.assertNotClosed();
        return this.mCurrentNode instanceof NullNode;
    }

    @Override
    public boolean isStringValue() {
        this.assertNotClosed();
        return this.mCurrentNode instanceof StringNode;
    }

    @Override
    public boolean isBooleanValue() {
        this.assertNotClosed();
        return this.mCurrentNode instanceof BooleanNode;
    }

    @Override
    public void close() {
        if (!this.mIsClosed) {
            this.mPageReadTrx.close();
            this.mResourceManager.closeReadTransaction(this.mTrxId);
            this.setPageReadTransaction(null);
            this.mPageReadTrx = null;
            this.mCurrentNode = null;
            this.mIsClosed = true;
        }
    }

    @Override
    protected JsonNodeReadOnlyTrx thisInstance() {
        return this;
    }

    public void setCurrentNode(ImmutableNode node) {
        this.assertNotClosed();
        assert (node != null) : "Node must be given.";
        this.mCurrentNode = node;
    }

    @Override
    public boolean isDocumentRoot() {
        this.assertNotClosed();
        return this.mCurrentNode.getKind() == Kind.JSON_DOCUMENT;
    }

    @Override
    public boolean isClosed() {
        return this.mIsClosed;
    }

    @Override
    public QNm getName() {
        this.assertNotClosed();
        if (this.mCurrentNode.getKind() == Kind.OBJECT_RECORD) {
            int nameKey = ((ObjectRecordNode)this.mCurrentNode).getNameKey();
            String localName = nameKey == -1 ? "" : this.mPageReadTrx.getName(nameKey, this.mCurrentNode.getKind());
            return new QNm(localName);
        }
        return null;
    }

    @Override
    public VisitResult acceptVisitor(JsonNodeVisitor visitor) {
        this.assertNotClosed();
        return ((ImmutableJsonNode)this.mCurrentNode).acceptVisitor(visitor);
    }

    @Override
    public ImmutableJsonNode getCurrentNode() {
        return (ImmutableJsonNode)this.mCurrentNode;
    }

    @Override
    public void setCurrentNode(ImmutableJsonNode node) {
        this.mCurrentNode = node;
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((Object)this);
        helper.add("Revision number", this.getRevisionNumber());
        if (this.mCurrentNode.getKind() == Kind.OBJECT_RECORD) {
            helper.add("Name of Node", (Object)this.getName().toString());
        }
        if (this.mCurrentNode.getKind() == Kind.BOOLEAN_VALUE || this.mCurrentNode.getKind() == Kind.STRING_VALUE || this.mCurrentNode.getKind() == Kind.NUMBER_VALUE) {
            helper.add("Value of Node", (Object)this.getValue());
        }
        if (this.mCurrentNode.getKind() == Kind.JSON_DOCUMENT) {
            helper.addValue((Object)"Node is DocumentRoot");
        }
        helper.add("node", (Object)this.mCurrentNode.toString());
        return helper.toString();
    }
}

