/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.access.trx.node.xml;

import java.util.HashSet;
import java.util.Set;
import org.brackit.xquery.atomic.QNm;
import org.brackit.xquery.util.path.Path;
import org.brackit.xquery.util.path.PathException;
import org.sirix.access.trx.node.AbstractIndexController;
import org.sirix.api.PageTrx;
import org.sirix.api.visitor.XmlNodeVisitor;
import org.sirix.api.xml.XmlNodeReadOnlyTrx;
import org.sirix.api.xml.XmlNodeTrx;
import org.sirix.index.ChangeListener;
import org.sirix.index.IndexBuilder;
import org.sirix.index.IndexDef;
import org.sirix.index.Indexes;
import org.sirix.index.cas.xdm.XdmCASIndexImpl;
import org.sirix.index.name.xdm.XdmNameIndexImpl;
import org.sirix.index.path.PathFilter;
import org.sirix.index.path.summary.PathSummaryReader;
import org.sirix.index.path.xml.XmlPCRCollector;
import org.sirix.index.path.xml.XmlPathIndexImpl;
import org.sirix.node.interfaces.Record;
import org.sirix.page.UnorderedKeyValuePage;

public final class XmlIndexController
extends AbstractIndexController<XmlNodeReadOnlyTrx, XmlNodeTrx> {
    public XmlIndexController() {
        super(new Indexes(), new HashSet<ChangeListener>(), new XmlPathIndexImpl(), new XdmCASIndexImpl(), new XdmNameIndexImpl());
    }

    public XmlIndexController createIndexes(Set<IndexDef> indexDefs, XmlNodeTrx nodeWriteTrx) {
        IndexBuilder.build(nodeWriteTrx, this.createIndexBuilders(indexDefs, nodeWriteTrx));
        this.createIndexListeners(indexDefs, nodeWriteTrx);
        return this;
    }

    Set<XmlNodeVisitor> createIndexBuilders(Set<IndexDef> indexDefs, XmlNodeTrx nodeWriteTrx) {
        HashSet<XmlNodeVisitor> indexBuilders = new HashSet<XmlNodeVisitor>(indexDefs.size());
        for (IndexDef indexDef : indexDefs) {
            this.mIndexes.add(indexDef);
            switch (indexDef.getType()) {
                case PATH: {
                    indexBuilders.add(this.createPathIndexBuilder(nodeWriteTrx.getPageWtx(), nodeWriteTrx.getPathSummary(), indexDef));
                    break;
                }
                case CAS: {
                    indexBuilders.add(this.createCASIndexBuilder(nodeWriteTrx, nodeWriteTrx.getPageWtx(), nodeWriteTrx.getPathSummary(), indexDef));
                    break;
                }
                case NAME: {
                    indexBuilders.add(this.createNameIndexBuilder(nodeWriteTrx.getPageWtx(), indexDef));
                    break;
                }
            }
        }
        return indexBuilders;
    }

    @Override
    public PathFilter createPathFilter(String[] queryString, XmlNodeReadOnlyTrx rtx) throws PathException {
        HashSet<Path<QNm>> paths = new HashSet<Path<QNm>>(queryString.length);
        for (String path : queryString) {
            paths.add(Path.parse((String)path));
        }
        return new PathFilter(paths, new XmlPCRCollector(rtx));
    }

    private XmlNodeVisitor createPathIndexBuilder(PageTrx<Long, Record, UnorderedKeyValuePage> pageWriteTrx, PathSummaryReader pathSummaryReader, IndexDef indexDef) {
        return (XmlNodeVisitor)this.mPathIndex.createBuilder(pageWriteTrx, pathSummaryReader, indexDef);
    }

    private XmlNodeVisitor createCASIndexBuilder(XmlNodeReadOnlyTrx nodeReadTrx, PageTrx<Long, Record, UnorderedKeyValuePage> pageWriteTrx, PathSummaryReader pathSummaryReader, IndexDef indexDef) {
        return (XmlNodeVisitor)this.mCASIndex.createBuilder(nodeReadTrx, pageWriteTrx, pathSummaryReader, indexDef);
    }

    private XmlNodeVisitor createNameIndexBuilder(PageTrx<Long, Record, UnorderedKeyValuePage> pageWriteTrx, IndexDef indexDef) {
        return (XmlNodeVisitor)this.mNameIndex.createBuilder(pageWriteTrx, indexDef);
    }

    public static enum ChangeType {
        INSERT,
        DELETE;

    }
}

