/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.access.trx.node.xml;

import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.ArrayList;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import org.brackit.xquery.atomic.QNm;
import org.sirix.access.trx.node.xml.XmlNodeFactory;
import org.sirix.api.PageTrx;
import org.sirix.index.path.summary.PathNode;
import org.sirix.node.Kind;
import org.sirix.node.SirixDeweyID;
import org.sirix.node.delegates.NameNodeDelegate;
import org.sirix.node.delegates.NodeDelegate;
import org.sirix.node.delegates.StructNodeDelegate;
import org.sirix.node.delegates.ValNodeDelegate;
import org.sirix.node.interfaces.Record;
import org.sirix.node.xdm.AttributeNode;
import org.sirix.node.xdm.CommentNode;
import org.sirix.node.xdm.ElementNode;
import org.sirix.node.xdm.NamespaceNode;
import org.sirix.node.xdm.PINode;
import org.sirix.node.xdm.TextNode;
import org.sirix.page.PageKind;
import org.sirix.page.PathSummaryPage;
import org.sirix.page.UnorderedKeyValuePage;
import org.sirix.settings.Fixed;
import org.sirix.utils.Compression;
import org.sirix.utils.NamePageHash;

final class XmlNodeFactoryImpl
implements XmlNodeFactory {
    private final PageTrx<Long, Record, UnorderedKeyValuePage> mPageWriteTrx;

    XmlNodeFactoryImpl(PageTrx<Long, Record, UnorderedKeyValuePage> pageWriteTrx) {
        this.mPageWriteTrx = (PageTrx)Preconditions.checkNotNull(pageWriteTrx);
        this.mPageWriteTrx.createNameKey("xs:untyped", Kind.ATTRIBUTE);
        this.mPageWriteTrx.createNameKey("xs:untyped", Kind.NAMESPACE);
        this.mPageWriteTrx.createNameKey("xs:untyped", Kind.ELEMENT);
        this.mPageWriteTrx.createNameKey("xs:untyped", Kind.PROCESSING_INSTRUCTION);
    }

    @Override
    public PathNode createPathNode(@Nonnegative long parentKey, @Nonnegative long leftSibKey, long rightSibKey, @Nonnull QNm name, @Nonnull Kind kind, @Nonnegative int level) {
        int uriKey = NamePageHash.generateHashForString(name.getNamespaceURI());
        int prefixKey = name.getPrefix() != null && !name.getPrefix().isEmpty() ? NamePageHash.generateHashForString(name.getPrefix()) : -1;
        int localName = name.getLocalName() != null && !name.getLocalName().isEmpty() ? NamePageHash.generateHashForString(name.getLocalName()) : -1;
        long revision = this.mPageWriteTrx.getRevisionNumber();
        NodeDelegate nodeDel = new NodeDelegate(((PathSummaryPage)this.mPageWriteTrx.getActualRevisionRootPage().getPathSummaryPageReference().getPage()).getMaxNodeKey(0) + 1L, parentKey, 0L, revision, null);
        StructNodeDelegate structDel = new StructNodeDelegate(nodeDel, Fixed.NULL_NODE_KEY.getStandardProperty(), rightSibKey, leftSibKey, 0L, 0L);
        NameNodeDelegate nameDel = new NameNodeDelegate(nodeDel, uriKey, prefixKey, localName, 0L);
        return (PathNode)this.mPageWriteTrx.createEntry(nodeDel.getNodeKey(), new PathNode(nodeDel, structDel, nameDel, kind, 1, level), PageKind.PATHSUMMARYPAGE, 0);
    }

    @Override
    public ElementNode createElementNode(@Nonnegative long parentKey, @Nonnegative long leftSibKey, @Nonnegative long rightSibKey, @Nonnull QNm name, @Nonnegative long pathNodeKey, SirixDeweyID id) {
        int uriKey = name.getNamespaceURI() != null && !name.getNamespaceURI().isEmpty() ? this.mPageWriteTrx.createNameKey(name.getNamespaceURI(), Kind.NAMESPACE) : -1;
        int prefixKey = name.getPrefix() != null && !name.getPrefix().isEmpty() ? this.mPageWriteTrx.createNameKey(name.getPrefix(), Kind.ELEMENT) : -1;
        int localNameKey = this.mPageWriteTrx.createNameKey(name.getLocalName(), Kind.ELEMENT);
        long revision = this.mPageWriteTrx.getRevisionNumber();
        NodeDelegate nodeDel = new NodeDelegate(this.mPageWriteTrx.getActualRevisionRootPage().getMaxNodeKey() + 1L, parentKey, 0L, revision, id);
        StructNodeDelegate structDel = new StructNodeDelegate(nodeDel, Fixed.NULL_NODE_KEY.getStandardProperty(), rightSibKey, leftSibKey, 0L, 0L);
        NameNodeDelegate nameDel = new NameNodeDelegate(nodeDel, uriKey, prefixKey, localNameKey, pathNodeKey);
        return (ElementNode)this.mPageWriteTrx.createEntry(nodeDel.getNodeKey(), new ElementNode(structDel, nameDel, new ArrayList<Long>(), (BiMap<Long, Long>)HashBiMap.create(), new ArrayList<Long>(), name), PageKind.RECORDPAGE, -1);
    }

    @Override
    public TextNode createTextNode(@Nonnegative long parentKey, @Nonnegative long leftSibKey, @Nonnegative long rightSibKey, @Nonnull byte[] value, boolean isCompressed, SirixDeweyID id) {
        long revision = this.mPageWriteTrx.getRevisionNumber();
        NodeDelegate nodeDel = new NodeDelegate(this.mPageWriteTrx.getActualRevisionRootPage().getMaxNodeKey() + 1L, parentKey, 0L, revision, id);
        boolean compression = isCompressed && value.length > 10;
        byte[] compressedValue = compression ? Compression.compress(value, 2) : value;
        ValNodeDelegate valDel = new ValNodeDelegate(nodeDel, compressedValue, compression);
        StructNodeDelegate structDel = new StructNodeDelegate(nodeDel, Fixed.NULL_NODE_KEY.getStandardProperty(), rightSibKey, leftSibKey, 0L, 0L);
        return (TextNode)this.mPageWriteTrx.createEntry(nodeDel.getNodeKey(), new TextNode(valDel, structDel), PageKind.RECORDPAGE, -1);
    }

    @Override
    public AttributeNode createAttributeNode(@Nonnegative long parentKey, @Nonnull QNm name, @Nonnull byte[] value, @Nonnegative long pathNodeKey, SirixDeweyID id) {
        long revision = this.mPageWriteTrx.getRevisionNumber();
        int uriKey = this.mPageWriteTrx.createNameKey(name.getNamespaceURI(), Kind.NAMESPACE);
        int prefixKey = name.getPrefix() != null && !name.getPrefix().isEmpty() ? this.mPageWriteTrx.createNameKey(name.getPrefix(), Kind.ATTRIBUTE) : -1;
        int localNameKey = this.mPageWriteTrx.createNameKey(name.getLocalName(), Kind.ATTRIBUTE);
        NodeDelegate nodeDel = new NodeDelegate(this.mPageWriteTrx.getActualRevisionRootPage().getMaxNodeKey() + 1L, parentKey, 0L, revision, id);
        NameNodeDelegate nameDel = new NameNodeDelegate(nodeDel, uriKey, prefixKey, localNameKey, pathNodeKey);
        ValNodeDelegate valDel = new ValNodeDelegate(nodeDel, value, false);
        return (AttributeNode)this.mPageWriteTrx.createEntry(nodeDel.getNodeKey(), new AttributeNode(nodeDel, nameDel, valDel, name), PageKind.RECORDPAGE, -1);
    }

    @Override
    public NamespaceNode createNamespaceNode(@Nonnegative long parentKey, QNm name, @Nonnegative long pathNodeKey, SirixDeweyID id) {
        long revision = this.mPageWriteTrx.getRevisionNumber();
        NodeDelegate nodeDel = new NodeDelegate(this.mPageWriteTrx.getActualRevisionRootPage().getMaxNodeKey() + 1L, parentKey, 0L, revision, id);
        int uriKey = this.mPageWriteTrx.createNameKey(name.getNamespaceURI(), Kind.NAMESPACE);
        int prefixKey = name.getPrefix() != null && !name.getPrefix().isEmpty() ? this.mPageWriteTrx.createNameKey(name.getPrefix(), Kind.NAMESPACE) : -1;
        NameNodeDelegate nameDel = new NameNodeDelegate(nodeDel, uriKey, prefixKey, -1, pathNodeKey);
        return (NamespaceNode)this.mPageWriteTrx.createEntry(nodeDel.getNodeKey(), new NamespaceNode(nodeDel, nameDel, name), PageKind.RECORDPAGE, -1);
    }

    @Override
    public PINode createPINode(@Nonnegative long parentKey, @Nonnegative long leftSibKey, @Nonnegative long rightSibKey, QNm target, byte[] content, boolean isCompressed, @Nonnegative long pathNodeKey, SirixDeweyID id) {
        long revision = this.mPageWriteTrx.getRevisionNumber();
        int prefixKey = target.getPrefix() != null && !target.getPrefix().isEmpty() ? this.mPageWriteTrx.createNameKey(target.getPrefix(), Kind.PROCESSING_INSTRUCTION) : -1;
        int localNameKey = this.mPageWriteTrx.createNameKey(target.getLocalName(), Kind.PROCESSING_INSTRUCTION);
        int uriKey = this.mPageWriteTrx.createNameKey(target.getNamespaceURI(), Kind.NAMESPACE);
        NodeDelegate nodeDel = new NodeDelegate(this.mPageWriteTrx.getActualRevisionRootPage().getMaxNodeKey() + 1L, parentKey, 0L, revision, id);
        StructNodeDelegate structDel = new StructNodeDelegate(nodeDel, Fixed.NULL_NODE_KEY.getStandardProperty(), rightSibKey, leftSibKey, 0L, 0L);
        NameNodeDelegate nameDel = new NameNodeDelegate(nodeDel, uriKey, prefixKey, localNameKey, pathNodeKey);
        ValNodeDelegate valDel = new ValNodeDelegate(nodeDel, content, false);
        return (PINode)this.mPageWriteTrx.createEntry(nodeDel.getNodeKey(), new PINode(structDel, nameDel, valDel, this.mPageWriteTrx), PageKind.RECORDPAGE, -1);
    }

    @Override
    public CommentNode createCommentNode(@Nonnegative long parentKey, @Nonnegative long leftSibKey, @Nonnegative long rightSibKey, byte[] value, boolean isCompressed, SirixDeweyID id) {
        long revision = this.mPageWriteTrx.getRevisionNumber();
        NodeDelegate nodeDel = new NodeDelegate(this.mPageWriteTrx.getActualRevisionRootPage().getMaxNodeKey() + 1L, parentKey, 0L, revision, id);
        boolean compression = isCompressed && value.length > 10;
        byte[] compressedValue = compression ? Compression.compress(value, 2) : value;
        ValNodeDelegate valDel = new ValNodeDelegate(nodeDel, compressedValue, compression);
        StructNodeDelegate structDel = new StructNodeDelegate(nodeDel, Fixed.NULL_NODE_KEY.getStandardProperty(), rightSibKey, leftSibKey, 0L, 0L);
        return (CommentNode)this.mPageWriteTrx.createEntry(nodeDel.getNodeKey(), new CommentNode(valDel, structDel), PageKind.RECORDPAGE, -1);
    }
}

