/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.access.trx.node.xml;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.stream.XMLEventReader;
import org.brackit.xquery.atomic.QNm;
import org.sirix.access.trx.node.CommitCredentials;
import org.sirix.access.trx.node.HashType;
import org.sirix.access.trx.node.InternalResourceManager;
import org.sirix.access.trx.node.Movement;
import org.sirix.access.trx.node.xml.AbstractForwardingXmlNodeReadOnlyTrx;
import org.sirix.access.trx.node.xml.InsertPos;
import org.sirix.access.trx.node.xml.InternalXmlNodeReadTrx;
import org.sirix.access.trx.node.xml.XmlIndexController;
import org.sirix.access.trx.node.xml.XmlNodeFactory;
import org.sirix.access.trx.node.xml.XmlNodeFactoryImpl;
import org.sirix.api.PageTrx;
import org.sirix.api.PostCommitHook;
import org.sirix.api.PreCommitHook;
import org.sirix.api.xml.XmlNodeReadOnlyTrx;
import org.sirix.api.xml.XmlNodeTrx;
import org.sirix.axis.DescendantAxis;
import org.sirix.axis.IncludeSelf;
import org.sirix.axis.LevelOrderAxis;
import org.sirix.axis.PostOrderAxis;
import org.sirix.exception.SirixIOException;
import org.sirix.exception.SirixThreadedException;
import org.sirix.exception.SirixUsageException;
import org.sirix.index.path.summary.PathSummaryReader;
import org.sirix.index.path.summary.PathSummaryWriter;
import org.sirix.node.Kind;
import org.sirix.node.SirixDeweyID;
import org.sirix.node.immutable.xdm.ImmutableAttributeNode;
import org.sirix.node.immutable.xdm.ImmutableNamespace;
import org.sirix.node.interfaces.NameNode;
import org.sirix.node.interfaces.Node;
import org.sirix.node.interfaces.Record;
import org.sirix.node.interfaces.StructNode;
import org.sirix.node.interfaces.ValueNode;
import org.sirix.node.interfaces.immutable.ImmutableNode;
import org.sirix.node.interfaces.immutable.ImmutableStructNode;
import org.sirix.node.interfaces.immutable.ImmutableXmlNode;
import org.sirix.node.xdm.AttributeNode;
import org.sirix.node.xdm.CommentNode;
import org.sirix.node.xdm.ElementNode;
import org.sirix.node.xdm.NamespaceNode;
import org.sirix.node.xdm.PINode;
import org.sirix.node.xdm.TextNode;
import org.sirix.page.NamePage;
import org.sirix.page.PageKind;
import org.sirix.page.UberPage;
import org.sirix.page.UnorderedKeyValuePage;
import org.sirix.service.xml.serialize.StAXSerializer;
import org.sirix.service.xml.shredder.InsertPosition;
import org.sirix.service.xml.shredder.XmlShredder;
import org.sirix.settings.Constants;
import org.sirix.settings.Fixed;
import org.sirix.utils.XMLToken;

final class XmlNodeTrxImpl
extends AbstractForwardingXmlNodeReadOnlyTrx
implements XmlNodeTrx {
    private final HashFunction mHash = Hashing.sha256();
    private static final int PRIME = 77081;
    private final int mMaxNodeCount;
    long mModificationCount;
    private final HashType mHashKind;
    private final ScheduledExecutorService mPool = Executors.newScheduledThreadPool(Runtime.getRuntime().availableProcessors());
    final InternalXmlNodeReadTrx mNodeReadOnlyTrx;
    private boolean mBulkInsert;
    private PathSummaryWriter<XmlNodeReadOnlyTrx> mPathSummaryWriter;
    private final boolean mBuildPathSummary;
    private XmlNodeFactory mNodeFactory;
    private final Lock mLock;
    private final boolean mDeweyIDsStored;
    private final boolean mCompression;
    private final XmlIndexController mIndexController;
    private final InternalResourceManager<XmlNodeReadOnlyTrx, XmlNodeTrx> mResourceManager;
    private PageTrx<Long, Record, UnorderedKeyValuePage> mPageWriteTrx;
    private final List<PreCommitHook> mPreCommitHooks = new ArrayList<PreCommitHook>();
    private final List<PostCommitHook> mPostCommitHooks = new ArrayList<PostCommitHook>();

    XmlNodeTrxImpl(@Nonnegative long transactionID, InternalResourceManager<XmlNodeReadOnlyTrx, XmlNodeTrx> resourceManager, InternalXmlNodeReadTrx nodeReadTrx, PathSummaryWriter<XmlNodeReadOnlyTrx> pathSummaryWriter, @Nonnegative int maxNodeCount, TimeUnit timeUnit, @Nonnegative int maxTime, @Nonnull Node documentNode, XmlNodeFactory nodeFactory) {
        Preconditions.checkArgument((maxNodeCount >= 0 && maxTime >= 0 ? 1 : 0) != 0, (Object)"Negative arguments for maxNodeCount and maxTime are not accepted.");
        this.mResourceManager = (InternalResourceManager)Preconditions.checkNotNull(resourceManager);
        this.mNodeReadOnlyTrx = (InternalXmlNodeReadTrx)Preconditions.checkNotNull((Object)nodeReadTrx);
        this.mBuildPathSummary = resourceManager.getResourceConfig().withPathSummary;
        this.mPathSummaryWriter = (PathSummaryWriter)Preconditions.checkNotNull(pathSummaryWriter);
        this.mIndexController = (XmlIndexController)resourceManager.getWtxIndexController(this.mNodeReadOnlyTrx.getPageTrx().getRevisionNumber());
        this.mPageWriteTrx = (PageTrx)this.mNodeReadOnlyTrx.getPageTrx();
        this.mNodeFactory = (XmlNodeFactory)Preconditions.checkNotNull((Object)nodeFactory);
        this.mMaxNodeCount = maxNodeCount;
        this.mModificationCount = 0L;
        if (maxTime > 0) {
            this.mPool.scheduleAtFixedRate(() -> this.commit(), maxTime, maxTime, timeUnit);
        }
        this.mLock = maxTime > 0 ? new ReentrantLock() : null;
        this.mHashKind = resourceManager.getResourceConfig().hashType;
        this.mDeweyIDsStored = resourceManager.getResourceConfig().areDeweyIDsStored;
        this.mCompression = resourceManager.getResourceConfig().useTextCompression;
    }

    @Override
    public XmlNodeTrx moveSubtreeToFirstChild(@Nonnegative long fromKey) {
        this.acquireLock();
        try {
            Preconditions.checkArgument((fromKey >= 0L && fromKey <= this.getMaxNodeKey() ? 1 : 0) != 0, (Object)"Argument must be a valid node key!");
            Preconditions.checkArgument((fromKey != this.getCurrentNode().getNodeKey() ? 1 : 0) != 0, (Object)"Can't move itself to right sibling of itself!");
            Optional<? extends Record> node = this.mPageWriteTrx.getRecord(fromKey, PageKind.RECORDPAGE, -1);
            if (!node.isPresent()) {
                throw new IllegalStateException("Node to move must exist!");
            }
            Node nodeToMove = (Node)node.get();
            if (nodeToMove instanceof StructNode && this.getCurrentNode().getKind() == Kind.ELEMENT) {
                this.checkAncestors(nodeToMove);
                this.checkAccessAndCommit();
                ElementNode nodeAnchor = (ElementNode)this.getCurrentNode();
                if (nodeAnchor.getFirstChildKey() != nodeToMove.getNodeKey()) {
                    StructNode toMove = (StructNode)nodeToMove;
                    this.adaptSubtreeForMove(toMove, XmlIndexController.ChangeType.DELETE);
                    this.adaptHashesForMove(toMove);
                    this.adaptForMove(toMove, nodeAnchor, InsertPos.ASFIRSTCHILD);
                    this.mNodeReadOnlyTrx.moveTo(toMove.getNodeKey());
                    this.adaptHashesWithAdd();
                    if (this.mBuildPathSummary && toMove instanceof NameNode) {
                        NameNode moved = (NameNode)((Object)toMove);
                        this.mPathSummaryWriter.adaptPathForChangedNode(moved, this.getName(), moved.getURIKey(), moved.getPrefixKey(), moved.getLocalNameKey(), PathSummaryWriter.OPType.MOVED);
                    }
                    this.adaptSubtreeForMove(toMove, XmlIndexController.ChangeType.INSERT);
                    if (this.mDeweyIDsStored) {
                        this.computeNewDeweyIDs();
                    }
                }
                XmlNodeTrxImpl xmlNodeTrxImpl = this;
                return xmlNodeTrxImpl;
            }
            throw new SirixUsageException(new String[]{"Move is not allowed if moved node is not an ElementNode and the node isn't inserted at an element node!"});
        }
        finally {
            this.unLock();
        }
    }

    private ImmutableXmlNode getCurrentNode() {
        return this.mNodeReadOnlyTrx.getCurrentNode();
    }

    private void adaptSubtreeForMove(Node node, XmlIndexController.ChangeType type) throws SirixIOException {
        assert (type != null);
        long beforeNodeKey = this.getNode().getNodeKey();
        this.moveTo(node.getNodeKey());
        DescendantAxis axis = new DescendantAxis(this, IncludeSelf.YES);
        while (axis.hasNext()) {
            int i;
            axis.next();
            int attCount = this.getAttributeCount();
            for (i = 0; i < attCount; ++i) {
                this.moveToAttribute(i);
                ImmutableAttributeNode att = (ImmutableAttributeNode)this.getNode();
                this.mIndexController.notifyChange(type, att, att.getPathNodeKey());
                this.moveToParent();
            }
            int nspCount = this.getNamespaceCount();
            for (i = 0; i < nspCount; ++i) {
                this.moveToAttribute(i);
                ImmutableNamespace nsp = (ImmutableNamespace)this.getNode();
                this.mIndexController.notifyChange(type, nsp, nsp.getPathNodeKey());
                this.moveToParent();
            }
            long pathNodeKey = -1L;
            if (this.getNode() instanceof ValueNode && this.getNode().getParentKey() != Fixed.DOCUMENT_NODE_KEY.getStandardProperty()) {
                long nodeKey = this.getNode().getNodeKey();
                pathNodeKey = this.moveToParent().trx().getNameNode().getPathNodeKey();
                this.moveTo(nodeKey);
            } else if (this.getNode() instanceof NameNode) {
                pathNodeKey = this.getNameNode().getPathNodeKey();
            }
            this.mIndexController.notifyChange(type, this.getNode(), pathNodeKey);
        }
        this.moveTo(beforeNodeKey);
    }

    private void computeNewDeweyIDs() {
        SirixDeweyID id = null;
        id = this.hasLeftSibling() && this.hasRightSibling() ? SirixDeweyID.newBetween(this.getLeftSiblingDeweyID().get(), this.getRightSiblingDeweyID().get()) : (this.hasLeftSibling() ? SirixDeweyID.newBetween(this.getLeftSiblingDeweyID().get(), null) : (this.hasRightSibling() ? SirixDeweyID.newBetween(null, this.getRightSiblingDeweyID().get()) : this.mNodeReadOnlyTrx.getParentDeweyID().get().getNewChildID()));
        assert (id != null);
        long nodeKey = this.mNodeReadOnlyTrx.getCurrentNode().getNodeKey();
        StructNode root = (StructNode)this.mPageWriteTrx.prepareEntryForModification(nodeKey, PageKind.RECORDPAGE, -1);
        root.setDeweyID(id);
        if (root.hasFirstChild()) {
            Node firstChild = (Node)this.mPageWriteTrx.prepareEntryForModification(root.getFirstChildKey(), PageKind.RECORDPAGE, -1);
            firstChild.setDeweyID(id.getNewChildID());
            int previousLevel = this.getDeweyID().get().getLevel();
            this.mNodeReadOnlyTrx.moveTo(firstChild.getNodeKey());
            int attributeNr = 0;
            int nspNr = 0;
            for (long key : LevelOrderAxis.newBuilder(this).includeNonStructuralNodes().build()) {
                SirixDeweyID deweyID = null;
                if (this.isAttribute()) {
                    long attNodeKey = this.mNodeReadOnlyTrx.getNodeKey();
                    if (attributeNr == 0) {
                        deweyID = this.mNodeReadOnlyTrx.getParentDeweyID().get().getNewAttributeID();
                    } else {
                        this.mNodeReadOnlyTrx.moveTo(attributeNr - 1);
                        deweyID = SirixDeweyID.newBetween(this.mNodeReadOnlyTrx.getNode().getDeweyID().get(), null);
                    }
                    this.mNodeReadOnlyTrx.moveTo(attNodeKey);
                    ++attributeNr;
                } else if (this.isNamespace()) {
                    long nspNodeKey = this.mNodeReadOnlyTrx.getNodeKey();
                    if (nspNr == 0) {
                        deweyID = this.mNodeReadOnlyTrx.getParentDeweyID().get().getNewNamespaceID();
                    } else {
                        this.mNodeReadOnlyTrx.moveTo(nspNr - 1);
                        deweyID = SirixDeweyID.newBetween(this.mNodeReadOnlyTrx.getNode().getDeweyID().get(), null);
                    }
                    this.mNodeReadOnlyTrx.moveTo(nspNodeKey);
                    ++nspNr;
                } else {
                    attributeNr = 0;
                    nspNr = 0;
                    if (previousLevel + 1 == this.getDeweyID().get().getLevel()) {
                        deweyID = this.mNodeReadOnlyTrx.hasLeftSibling() ? SirixDeweyID.newBetween(this.getLeftSiblingDeweyID().get(), null) : this.getParentDeweyID().get().getNewChildID();
                    } else {
                        ++previousLevel;
                        deweyID = this.getParentDeweyID().get().getNewChildID();
                    }
                }
                Node node = (Node)this.mPageWriteTrx.prepareEntryForModification(this.mNodeReadOnlyTrx.getCurrentNode().getNodeKey(), PageKind.RECORDPAGE, -1);
                node.setDeweyID(deweyID);
            }
            this.mNodeReadOnlyTrx.moveTo(nodeKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public XmlNodeTrx moveSubtreeToLeftSibling(@Nonnegative long fromKey) {
        this.acquireLock();
        try {
            if (this.mNodeReadOnlyTrx.getStructuralNode().hasLeftSibling()) {
                this.moveToLeftSibling();
                XmlNodeTrx xmlNodeTrx = this.moveSubtreeToRightSibling(fromKey);
                return xmlNodeTrx;
            }
            this.moveToParent();
            XmlNodeTrx xmlNodeTrx = this.moveSubtreeToFirstChild(fromKey);
            return xmlNodeTrx;
        }
        finally {
            this.unLock();
        }
    }

    @Override
    public XmlNodeTrx moveSubtreeToRightSibling(@Nonnegative long fromKey) {
        this.acquireLock();
        try {
            if (fromKey < 0L || fromKey > this.getMaxNodeKey()) {
                throw new IllegalArgumentException("Argument must be a valid node key!");
            }
            if (fromKey == this.getCurrentNode().getNodeKey()) {
                throw new IllegalArgumentException("Can't move itself to first child of itself!");
            }
            Optional<? extends Record> node = this.mPageWriteTrx.getRecord(fromKey, PageKind.RECORDPAGE, -1);
            if (!node.isPresent()) {
                throw new IllegalStateException("Node to move must exist!");
            }
            Node nodeToMove = (Node)node.get();
            if (nodeToMove instanceof StructNode && this.getCurrentNode() instanceof StructNode) {
                StructNode toMove = (StructNode)nodeToMove;
                this.checkAncestors(toMove);
                this.checkAccessAndCommit();
                StructNode nodeAnchor = (StructNode)((Object)this.getCurrentNode());
                if (nodeAnchor.getRightSiblingKey() != nodeToMove.getNodeKey()) {
                    long parentKey = toMove.getParentKey();
                    this.adaptHashesForMove(toMove);
                    this.adaptForMove(toMove, nodeAnchor, InsertPos.ASRIGHTSIBLING);
                    this.mNodeReadOnlyTrx.moveTo(toMove.getNodeKey());
                    this.adaptHashesWithAdd();
                    if (this.mBuildPathSummary && toMove instanceof NameNode) {
                        PathSummaryWriter.OPType type;
                        NameNode moved = (NameNode)((Object)toMove);
                        PathSummaryWriter.OPType oPType = type = moved.getParentKey() == parentKey ? PathSummaryWriter.OPType.MOVED_ON_SAME_LEVEL : PathSummaryWriter.OPType.MOVED;
                        if (type != PathSummaryWriter.OPType.MOVED_ON_SAME_LEVEL) {
                            this.mPathSummaryWriter.adaptPathForChangedNode(moved, this.getName(), moved.getURIKey(), moved.getPrefixKey(), moved.getLocalNameKey(), type);
                        }
                    }
                    if (this.mDeweyIDsStored) {
                        this.computeNewDeweyIDs();
                    }
                }
                XmlNodeTrxImpl xmlNodeTrxImpl = this;
                return xmlNodeTrxImpl;
            }
            throw new SirixUsageException(new String[]{"Move is not allowed if moved node is not an ElementNode or TextNode and the node isn't inserted at an ElementNode or TextNode!"});
        }
        finally {
            this.unLock();
        }
    }

    private void adaptHashesForMove(StructNode nodeToMove) throws SirixIOException {
        assert (nodeToMove != null);
        this.mNodeReadOnlyTrx.setCurrentNode((ImmutableXmlNode)((Object)nodeToMove));
        this.adaptHashesWithRemove();
    }

    private void adaptForMove(StructNode fromNode, StructNode toNode, InsertPos insertPos) {
        assert (fromNode != null);
        assert (toNode != null);
        assert (insertPos != null);
        StructNode parent = (StructNode)this.mPageWriteTrx.prepareEntryForModification(fromNode.getParentKey(), PageKind.RECORDPAGE, -1);
        switch (insertPos) {
            case ASRIGHTSIBLING: {
                if (fromNode.getParentKey() == toNode.getParentKey()) break;
                parent.decrementChildCount();
                break;
            }
            case ASFIRSTCHILD: {
                if (fromNode.getParentKey() == toNode.getNodeKey()) break;
                parent.decrementChildCount();
                break;
            }
            case ASNONSTRUCTURAL: {
                break;
            }
        }
        if (parent.getFirstChildKey() == fromNode.getNodeKey()) {
            parent.setFirstChildKey(fromNode.getRightSiblingKey());
        }
        if (fromNode.hasRightSibling()) {
            StructNode rightSibling = (StructNode)this.mPageWriteTrx.prepareEntryForModification(fromNode.getRightSiblingKey(), PageKind.RECORDPAGE, -1);
            rightSibling.setLeftSiblingKey(fromNode.getLeftSiblingKey());
        }
        if (fromNode.hasLeftSibling()) {
            StructNode leftSibling = (StructNode)this.mPageWriteTrx.prepareEntryForModification(fromNode.getLeftSiblingKey(), PageKind.RECORDPAGE, -1);
            leftSibling.setRightSiblingKey(fromNode.getRightSiblingKey());
        }
        if (fromNode.hasLeftSibling() && fromNode.hasRightSibling()) {
            this.moveTo(fromNode.getLeftSiblingKey());
            if (this.getCurrentNode() != null && this.getCurrentNode().getKind() == Kind.TEXT) {
                StringBuilder builder = new StringBuilder(this.getValue());
                this.moveTo(fromNode.getRightSiblingKey());
                if (this.getCurrentNode() != null && this.getCurrentNode().getKind() == Kind.TEXT) {
                    builder.append(this.getValue());
                    if (fromNode.getRightSiblingKey() == toNode.getNodeKey()) {
                        this.moveTo(fromNode.getLeftSiblingKey());
                        if (this.mNodeReadOnlyTrx.getStructuralNode().hasLeftSibling()) {
                            StructNode leftSibling = (StructNode)this.mPageWriteTrx.prepareEntryForModification(this.mNodeReadOnlyTrx.getStructuralNode().getLeftSiblingKey(), PageKind.RECORDPAGE, -1);
                            leftSibling.setRightSiblingKey(fromNode.getRightSiblingKey());
                        }
                        long leftSiblingKey = this.mNodeReadOnlyTrx.getStructuralNode().hasLeftSibling() ? this.mNodeReadOnlyTrx.getStructuralNode().getLeftSiblingKey() : this.getCurrentNode().getNodeKey();
                        this.moveTo(fromNode.getRightSiblingKey());
                        StructNode rightSibling = (StructNode)this.mPageWriteTrx.prepareEntryForModification(this.getCurrentNode().getNodeKey(), PageKind.RECORDPAGE, -1);
                        rightSibling.setLeftSiblingKey(leftSiblingKey);
                        this.moveTo(fromNode.getLeftSiblingKey());
                        this.remove();
                        this.moveTo(fromNode.getRightSiblingKey());
                    } else {
                        if (this.mNodeReadOnlyTrx.getStructuralNode().hasRightSibling()) {
                            StructNode rightSibling = (StructNode)this.mPageWriteTrx.prepareEntryForModification(this.mNodeReadOnlyTrx.getStructuralNode().getRightSiblingKey(), PageKind.RECORDPAGE, -1);
                            rightSibling.setLeftSiblingKey(fromNode.getLeftSiblingKey());
                        }
                        long rightSiblingKey = this.mNodeReadOnlyTrx.getStructuralNode().hasRightSibling() ? this.mNodeReadOnlyTrx.getStructuralNode().getRightSiblingKey() : this.getCurrentNode().getNodeKey();
                        this.moveTo(fromNode.getLeftSiblingKey());
                        StructNode leftSibling = (StructNode)this.mPageWriteTrx.prepareEntryForModification(this.getCurrentNode().getNodeKey(), PageKind.RECORDPAGE, -1);
                        leftSibling.setRightSiblingKey(rightSiblingKey);
                        this.moveTo(fromNode.getRightSiblingKey());
                        this.remove();
                        this.moveTo(fromNode.getLeftSiblingKey());
                    }
                    this.setValue(builder.toString());
                }
            }
        }
        insertPos.processMove(fromNode, toNode, this);
    }

    @Override
    public XmlNodeTrx insertElementAsFirstChild(QNm name) {
        if (!XMLToken.isValidQName((QNm)Preconditions.checkNotNull((Object)name))) {
            throw new IllegalArgumentException("The QName is not valid!");
        }
        this.acquireLock();
        try {
            Kind kind = this.mNodeReadOnlyTrx.getCurrentNode().getKind();
            if (kind == Kind.ELEMENT || kind == Kind.XDM_DOCUMENT) {
                this.checkAccessAndCommit();
                long parentKey = this.mNodeReadOnlyTrx.getCurrentNode().getNodeKey();
                long leftSibKey = Fixed.NULL_NODE_KEY.getStandardProperty();
                long rightSibKey = ((StructNode)((Object)this.mNodeReadOnlyTrx.getCurrentNode())).getFirstChildKey();
                long pathNodeKey = this.mBuildPathSummary ? this.mPathSummaryWriter.getPathNodeKey(name, Kind.ELEMENT) : 0L;
                SirixDeweyID id = this.newFirstChildID();
                ElementNode node = this.mNodeFactory.createElementNode(parentKey, leftSibKey, rightSibKey, name, pathNodeKey, id);
                this.mNodeReadOnlyTrx.setCurrentNode(node);
                this.adaptForInsert(node, InsertPos.ASFIRSTCHILD, PageKind.RECORDPAGE);
                this.mNodeReadOnlyTrx.setCurrentNode(node);
                this.adaptHashesWithAdd();
                XmlNodeTrxImpl xmlNodeTrxImpl = this;
                return xmlNodeTrxImpl;
            }
            throw new SirixUsageException(new String[]{"Insert is not allowed if current node is not an ElementNode!"});
        }
        finally {
            this.unLock();
        }
    }

    @Override
    public XmlNodeTrx insertElementAsLeftSibling(QNm name) {
        if (!XMLToken.isValidQName((QNm)Preconditions.checkNotNull((Object)name))) {
            throw new IllegalArgumentException("The QName is not valid!");
        }
        this.acquireLock();
        try {
            if (this.getCurrentNode() instanceof StructNode && this.getCurrentNode().getKind() != Kind.XDM_DOCUMENT) {
                this.checkAccessAndCommit();
                long key = this.getCurrentNode().getNodeKey();
                this.moveToParent();
                long pathNodeKey = this.mBuildPathSummary ? this.mPathSummaryWriter.getPathNodeKey(name, Kind.ELEMENT) : 0L;
                this.moveTo(key);
                long parentKey = this.getCurrentNode().getParentKey();
                long leftSibKey = ((StructNode)((Object)this.getCurrentNode())).getLeftSiblingKey();
                long rightSibKey = this.getCurrentNode().getNodeKey();
                SirixDeweyID id = this.newLeftSiblingID();
                ElementNode node = this.mNodeFactory.createElementNode(parentKey, leftSibKey, rightSibKey, name, pathNodeKey, id);
                this.mNodeReadOnlyTrx.setCurrentNode(node);
                this.adaptForInsert(node, InsertPos.ASLEFTSIBLING, PageKind.RECORDPAGE);
                this.mNodeReadOnlyTrx.setCurrentNode(node);
                this.adaptHashesWithAdd();
                XmlNodeTrxImpl xmlNodeTrxImpl = this;
                return xmlNodeTrxImpl;
            }
            throw new SirixUsageException(new String[]{"Insert is not allowed if current node is not an StructuralNode (either Text or Element)!"});
        }
        finally {
            this.unLock();
        }
    }

    @Override
    public XmlNodeTrx insertElementAsRightSibling(QNm name) {
        if (!XMLToken.isValidQName((QNm)Preconditions.checkNotNull((Object)name))) {
            throw new IllegalArgumentException("The QName is not valid!");
        }
        this.acquireLock();
        try {
            if (this.getCurrentNode() instanceof StructNode && !this.isDocumentRoot()) {
                this.checkAccessAndCommit();
                long key = this.getCurrentNode().getNodeKey();
                this.moveToParent();
                long pathNodeKey = this.mBuildPathSummary ? this.mPathSummaryWriter.getPathNodeKey(name, Kind.ELEMENT) : 0L;
                this.moveTo(key);
                long parentKey = this.getCurrentNode().getParentKey();
                long leftSibKey = this.getCurrentNode().getNodeKey();
                long rightSibKey = ((StructNode)((Object)this.getCurrentNode())).getRightSiblingKey();
                SirixDeweyID id = this.newRightSiblingID();
                ElementNode node = this.mNodeFactory.createElementNode(parentKey, leftSibKey, rightSibKey, name, pathNodeKey, id);
                this.mNodeReadOnlyTrx.setCurrentNode(node);
                this.adaptForInsert(node, InsertPos.ASRIGHTSIBLING, PageKind.RECORDPAGE);
                this.mNodeReadOnlyTrx.setCurrentNode(node);
                this.adaptHashesWithAdd();
                XmlNodeTrxImpl xmlNodeTrxImpl = this;
                return xmlNodeTrxImpl;
            }
            throw new SirixUsageException(new String[]{"Insert is not allowed if current node is not an StructuralNode (either Text or Element)!"});
        }
        finally {
            this.unLock();
        }
    }

    @Override
    public XmlNodeTrx insertSubtreeAsFirstChild(XMLEventReader reader) {
        return this.insertSubtree(reader, InsertPosition.AS_FIRST_CHILD);
    }

    @Override
    public XmlNodeTrx insertSubtreeAsRightSibling(XMLEventReader reader) {
        return this.insertSubtree(reader, InsertPosition.AS_RIGHT_SIBLING);
    }

    @Override
    public XmlNodeTrx insertSubtreeAsLeftSibling(XMLEventReader reader) {
        return this.insertSubtree(reader, InsertPosition.AS_LEFT_SIBLING);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XmlNodeTrx insertSubtree(XMLEventReader reader, InsertPosition insertionPosition) {
        Preconditions.checkNotNull((Object)reader);
        assert (insertionPosition != null);
        this.acquireLock();
        try {
            if (this.getCurrentNode() instanceof StructNode) {
                this.checkAccessAndCommit();
                this.mBulkInsert = true;
                long nodeKey = this.getCurrentNode().getNodeKey();
                XmlShredder shredder = new XmlShredder.Builder(this, reader, insertionPosition).build();
                shredder.call();
                this.moveTo(nodeKey);
                switch (insertionPosition) {
                    case AS_FIRST_CHILD: {
                        this.moveToFirstChild();
                        break;
                    }
                    case AS_RIGHT_SIBLING: {
                        this.moveToRightSibling();
                        break;
                    }
                    case AS_LEFT_SIBLING: {
                        this.moveToLeftSibling();
                        break;
                    }
                }
                if (this.mHashKind != HashType.NONE) {
                    nodeKey = this.getCurrentNode().getNodeKey();
                    this.postOrderTraversalHashes();
                    ImmutableXmlNode startNode = this.getCurrentNode();
                    this.moveToParent();
                    while (this.getCurrentNode().hasParent()) {
                        this.moveToParent();
                        this.addParentHash(startNode);
                    }
                    this.moveTo(nodeKey);
                }
                this.commit();
                this.mBulkInsert = false;
            }
        }
        finally {
            this.unLock();
        }
        return this;
    }

    @Override
    public XmlNodeTrx insertPIAsLeftSibling(String target, String content) {
        return this.pi(target, content, InsertPosition.AS_LEFT_SIBLING);
    }

    @Override
    public XmlNodeTrx insertPIAsRightSibling(String target, String content) {
        return this.pi(target, content, InsertPosition.AS_RIGHT_SIBLING);
    }

    @Override
    public XmlNodeTrx insertPIAsFirstChild(String target, String content) {
        return this.pi(target, content, InsertPosition.AS_FIRST_CHILD);
    }

    private XmlNodeTrx pi(String target, String content, InsertPosition insert) {
        byte[] targetBytes = XmlNodeTrxImpl.getBytes(target);
        if (!XMLToken.isNCName((byte[])Preconditions.checkNotNull((Object)targetBytes))) {
            throw new IllegalArgumentException("The target is not valid!");
        }
        if (content.contains("?>-")) {
            throw new SirixUsageException(new String[]{"The content must not contain '?>-'"});
        }
        this.acquireLock();
        try {
            if (this.getCurrentNode() instanceof StructNode) {
                this.checkAccessAndCommit();
                byte[] processingContent = XmlNodeTrxImpl.getBytes(content);
                long parentKey = 0L;
                long leftSibKey = 0L;
                long rightSibKey = 0L;
                InsertPos pos = InsertPos.ASFIRSTCHILD;
                SirixDeweyID id = null;
                switch (insert) {
                    case AS_FIRST_CHILD: {
                        parentKey = this.getCurrentNode().getNodeKey();
                        leftSibKey = Fixed.NULL_NODE_KEY.getStandardProperty();
                        rightSibKey = ((StructNode)((Object)this.getCurrentNode())).getFirstChildKey();
                        id = this.newFirstChildID();
                        break;
                    }
                    case AS_RIGHT_SIBLING: {
                        parentKey = this.getCurrentNode().getParentKey();
                        leftSibKey = this.getCurrentNode().getNodeKey();
                        rightSibKey = ((StructNode)((Object)this.getCurrentNode())).getRightSiblingKey();
                        pos = InsertPos.ASRIGHTSIBLING;
                        id = this.newRightSiblingID();
                        break;
                    }
                    case AS_LEFT_SIBLING: {
                        parentKey = this.getCurrentNode().getParentKey();
                        leftSibKey = ((StructNode)((Object)this.getCurrentNode())).getLeftSiblingKey();
                        rightSibKey = this.getCurrentNode().getNodeKey();
                        pos = InsertPos.ASLEFTSIBLING;
                        id = this.newLeftSiblingID();
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Insert location not known!");
                    }
                }
                QNm targetName = new QNm(target);
                long pathNodeKey = this.mBuildPathSummary ? this.mPathSummaryWriter.getPathNodeKey(targetName, Kind.PROCESSING_INSTRUCTION) : 0L;
                PINode node = this.mNodeFactory.createPINode(parentKey, leftSibKey, rightSibKey, targetName, processingContent, this.mCompression, pathNodeKey, id);
                this.mNodeReadOnlyTrx.setCurrentNode(node);
                this.adaptForInsert(node, pos, PageKind.RECORDPAGE);
                this.mNodeReadOnlyTrx.setCurrentNode(node);
                this.adaptHashesWithAdd();
                XmlNodeTrxImpl xmlNodeTrxImpl = this;
                return xmlNodeTrxImpl;
            }
            throw new SirixUsageException(new String[]{"Current node must be a structural node!"});
        }
        finally {
            this.unLock();
        }
    }

    @Override
    public XmlNodeTrx insertCommentAsLeftSibling(String value) {
        return this.comment(value, InsertPosition.AS_LEFT_SIBLING);
    }

    @Override
    public XmlNodeTrx insertCommentAsRightSibling(String value) {
        return this.comment(value, InsertPosition.AS_RIGHT_SIBLING);
    }

    @Override
    public XmlNodeTrx insertCommentAsFirstChild(String value) {
        return this.comment(value, InsertPosition.AS_FIRST_CHILD);
    }

    private XmlNodeTrx comment(String value, InsertPosition insert) {
        if (value.contains("--")) {
            throw new SirixUsageException(new String[]{"Character sequence \"--\" is not allowed in comment content!"});
        }
        if (value.endsWith("-")) {
            throw new SirixUsageException(new String[]{"Comment content must not end with \"-\"!"});
        }
        this.acquireLock();
        try {
            if (this.getCurrentNode() instanceof StructNode && (this.getCurrentNode().getKind() != Kind.XDM_DOCUMENT || this.getCurrentNode().getKind() == Kind.XDM_DOCUMENT && insert == InsertPosition.AS_FIRST_CHILD)) {
                SirixDeweyID id;
                InsertPos pos;
                this.checkAccessAndCommit();
                byte[] commentValue = XmlNodeTrxImpl.getBytes(value);
                long parentKey = 0L;
                long leftSibKey = 0L;
                long rightSibKey = 0L;
                switch (insert) {
                    case AS_FIRST_CHILD: {
                        parentKey = this.getCurrentNode().getNodeKey();
                        leftSibKey = Fixed.NULL_NODE_KEY.getStandardProperty();
                        rightSibKey = ((StructNode)((Object)this.getCurrentNode())).getFirstChildKey();
                        pos = InsertPos.ASFIRSTCHILD;
                        id = this.newFirstChildID();
                        break;
                    }
                    case AS_RIGHT_SIBLING: {
                        parentKey = this.getCurrentNode().getParentKey();
                        leftSibKey = this.getCurrentNode().getNodeKey();
                        rightSibKey = ((StructNode)((Object)this.getCurrentNode())).getRightSiblingKey();
                        pos = InsertPos.ASRIGHTSIBLING;
                        id = this.newRightSiblingID();
                        break;
                    }
                    case AS_LEFT_SIBLING: {
                        parentKey = this.getCurrentNode().getParentKey();
                        leftSibKey = ((StructNode)((Object)this.getCurrentNode())).getLeftSiblingKey();
                        rightSibKey = this.getCurrentNode().getNodeKey();
                        pos = InsertPos.ASLEFTSIBLING;
                        id = this.newLeftSiblingID();
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Insert location not known!");
                    }
                }
                CommentNode node = this.mNodeFactory.createCommentNode(parentKey, leftSibKey, rightSibKey, commentValue, this.mCompression, id);
                this.mNodeReadOnlyTrx.setCurrentNode(node);
                this.adaptForInsert(node, pos, PageKind.RECORDPAGE);
                this.mNodeReadOnlyTrx.setCurrentNode(node);
                this.adaptHashesWithAdd();
                XmlNodeTrxImpl xmlNodeTrxImpl = this;
                return xmlNodeTrxImpl;
            }
            throw new SirixUsageException(new String[]{"Current node must be a structural node!"});
        }
        finally {
            this.unLock();
        }
    }

    @Override
    public XmlNodeTrx insertTextAsFirstChild(String value) {
        Preconditions.checkNotNull((Object)value);
        this.acquireLock();
        try {
            if (this.getCurrentNode() instanceof StructNode && !value.isEmpty()) {
                this.checkAccessAndCommit();
                long pathNodeKey = this.getCurrentNode().getNodeKey();
                long parentKey = this.getCurrentNode().getNodeKey();
                long leftSibKey = Fixed.NULL_NODE_KEY.getStandardProperty();
                long rightSibKey = ((StructNode)((Object)this.getCurrentNode())).getFirstChildKey();
                if (this.hasNode(rightSibKey)) {
                    this.moveTo(rightSibKey);
                    if (this.getCurrentNode().getKind() == Kind.TEXT) {
                        this.setValue(value + this.getValue());
                        this.adaptHashedWithUpdate(this.getCurrentNode().getHash());
                        XmlNodeTrxImpl xmlNodeTrxImpl = this;
                        return xmlNodeTrxImpl;
                    }
                    this.moveTo(parentKey);
                }
                byte[] textValue = XmlNodeTrxImpl.getBytes(value);
                SirixDeweyID id = this.newFirstChildID();
                TextNode node = this.mNodeFactory.createTextNode(parentKey, leftSibKey, rightSibKey, textValue, this.mCompression, id);
                this.mNodeReadOnlyTrx.setCurrentNode(node);
                this.adaptForInsert(node, InsertPos.ASFIRSTCHILD, PageKind.RECORDPAGE);
                this.mNodeReadOnlyTrx.setCurrentNode(node);
                this.adaptHashesWithAdd();
                this.mIndexController.notifyChange(XmlIndexController.ChangeType.INSERT, node, pathNodeKey);
                XmlNodeTrxImpl xmlNodeTrxImpl = this;
                return xmlNodeTrxImpl;
            }
            throw new SirixUsageException(new String[]{"Insert is not allowed if current node is not an ElementNode or TextNode!"});
        }
        finally {
            this.unLock();
        }
    }

    @Override
    public XmlNodeTrx insertTextAsLeftSibling(String value) {
        Preconditions.checkNotNull((Object)value);
        this.acquireLock();
        try {
            if (this.getCurrentNode() instanceof StructNode && this.getCurrentNode().getKind() != Kind.XDM_DOCUMENT && !value.isEmpty()) {
                this.checkAccessAndCommit();
                long parentKey = this.getCurrentNode().getParentKey();
                long leftSibKey = ((StructNode)((Object)this.getCurrentNode())).getLeftSiblingKey();
                long rightSibKey = this.getCurrentNode().getNodeKey();
                StringBuilder builder = new StringBuilder();
                if (this.getCurrentNode().getKind() == Kind.TEXT) {
                    builder.append(value);
                }
                builder.append(this.getValue());
                if (!value.equals(builder.toString())) {
                    this.setValue(builder.toString());
                    XmlNodeTrxImpl xmlNodeTrxImpl = this;
                    return xmlNodeTrxImpl;
                }
                if (this.hasNode(leftSibKey)) {
                    this.moveTo(leftSibKey);
                    StringBuilder valueBuilder = new StringBuilder();
                    if (this.getCurrentNode().getKind() == Kind.TEXT) {
                        valueBuilder.append(this.getValue()).append((CharSequence)builder);
                    }
                    if (!value.equals(valueBuilder.toString())) {
                        this.setValue(valueBuilder.toString());
                        XmlNodeTrxImpl xmlNodeTrxImpl = this;
                        return xmlNodeTrxImpl;
                    }
                }
                this.moveTo(rightSibKey);
                byte[] textValue = XmlNodeTrxImpl.getBytes(builder.toString());
                SirixDeweyID id = this.newLeftSiblingID();
                TextNode node = this.mNodeFactory.createTextNode(parentKey, leftSibKey, rightSibKey, textValue, this.mCompression, id);
                this.mNodeReadOnlyTrx.setCurrentNode(node);
                this.adaptForInsert(node, InsertPos.ASLEFTSIBLING, PageKind.RECORDPAGE);
                this.mNodeReadOnlyTrx.setCurrentNode(node);
                this.adaptHashesWithAdd();
                long pathNodeKey = this.moveToParent().trx().isElement() ? this.getNameNode().getPathNodeKey() : -1L;
                this.mNodeReadOnlyTrx.setCurrentNode(node);
                this.mIndexController.notifyChange(XmlIndexController.ChangeType.INSERT, node, pathNodeKey);
                XmlNodeTrxImpl xmlNodeTrxImpl = this;
                return xmlNodeTrxImpl;
            }
            throw new SirixUsageException(new String[]{"Insert is not allowed if current node is not an Element- or Text-node!"});
        }
        finally {
            this.unLock();
        }
    }

    @Override
    public XmlNodeTrx insertTextAsRightSibling(String value) {
        Preconditions.checkNotNull((Object)value);
        this.acquireLock();
        try {
            if (this.getCurrentNode() instanceof StructNode && this.getCurrentNode().getKind() != Kind.XDM_DOCUMENT && !value.isEmpty()) {
                this.checkAccessAndCommit();
                long parentKey = this.getCurrentNode().getParentKey();
                long leftSibKey = this.getCurrentNode().getNodeKey();
                long rightSibKey = ((StructNode)((Object)this.getCurrentNode())).getRightSiblingKey();
                StringBuilder builder = new StringBuilder();
                if (this.getCurrentNode().getKind() == Kind.TEXT) {
                    builder.append(this.getValue());
                }
                builder.append(value);
                if (!value.equals(builder.toString())) {
                    this.setValue(builder.toString());
                    XmlNodeTrxImpl xmlNodeTrxImpl = this;
                    return xmlNodeTrxImpl;
                }
                if (this.hasNode(rightSibKey)) {
                    this.moveTo(rightSibKey);
                    if (this.getCurrentNode().getKind() == Kind.TEXT) {
                        builder.append(this.getValue());
                    }
                    if (!value.equals(builder.toString())) {
                        this.setValue(builder.toString());
                        XmlNodeTrxImpl xmlNodeTrxImpl = this;
                        return xmlNodeTrxImpl;
                    }
                }
                this.moveTo(leftSibKey);
                byte[] textValue = XmlNodeTrxImpl.getBytes(builder.toString());
                SirixDeweyID id = this.newRightSiblingID();
                TextNode node = this.mNodeFactory.createTextNode(parentKey, leftSibKey, rightSibKey, textValue, this.mCompression, id);
                this.mNodeReadOnlyTrx.setCurrentNode(node);
                this.adaptForInsert(node, InsertPos.ASRIGHTSIBLING, PageKind.RECORDPAGE);
                this.mNodeReadOnlyTrx.setCurrentNode(node);
                this.adaptHashesWithAdd();
                long pathNodeKey = this.moveToParent().trx().isElement() ? this.getNameNode().getPathNodeKey() : -1L;
                this.mNodeReadOnlyTrx.setCurrentNode(node);
                this.mIndexController.notifyChange(XmlIndexController.ChangeType.INSERT, node, pathNodeKey);
                XmlNodeTrxImpl xmlNodeTrxImpl = this;
                return xmlNodeTrxImpl;
            }
            throw new SirixUsageException(new String[]{"Insert is not allowed if current node is not an Element- or Text-node or value is empty!"});
        }
        finally {
            this.unLock();
        }
    }

    private SirixDeweyID newNamespaceID() {
        SirixDeweyID id = null;
        if (this.mDeweyIDsStored) {
            if (this.mNodeReadOnlyTrx.hasNamespaces()) {
                this.mNodeReadOnlyTrx.moveToNamespace(this.mNodeReadOnlyTrx.getNamespaceCount() - 1);
                id = SirixDeweyID.newBetween(this.mNodeReadOnlyTrx.getNode().getDeweyID().get(), null);
                this.mNodeReadOnlyTrx.moveToParent();
            } else {
                id = this.mNodeReadOnlyTrx.getCurrentNode().getDeweyID().get().getNewNamespaceID();
            }
        }
        return id;
    }

    private SirixDeweyID newAttributeID() {
        SirixDeweyID id = null;
        if (this.mDeweyIDsStored) {
            if (this.mNodeReadOnlyTrx.hasAttributes()) {
                this.mNodeReadOnlyTrx.moveToAttribute(this.mNodeReadOnlyTrx.getAttributeCount() - 1);
                id = SirixDeweyID.newBetween(this.mNodeReadOnlyTrx.getNode().getDeweyID().get(), null);
                this.mNodeReadOnlyTrx.moveToParent();
            } else {
                id = this.mNodeReadOnlyTrx.getCurrentNode().getDeweyID().get().getNewAttributeID();
            }
        }
        return id;
    }

    private SirixDeweyID newFirstChildID() {
        SirixDeweyID id = null;
        if (this.mDeweyIDsStored) {
            if (this.mNodeReadOnlyTrx.getStructuralNode().hasFirstChild()) {
                this.mNodeReadOnlyTrx.moveToFirstChild();
                id = SirixDeweyID.newBetween(null, this.mNodeReadOnlyTrx.getNode().getDeweyID().get());
            } else {
                id = this.mNodeReadOnlyTrx.getCurrentNode().getDeweyID().get().getNewChildID();
            }
        }
        return id;
    }

    private SirixDeweyID newLeftSiblingID() {
        SirixDeweyID id = null;
        if (this.mDeweyIDsStored) {
            SirixDeweyID currID = this.mNodeReadOnlyTrx.getCurrentNode().getDeweyID().get();
            if (this.mNodeReadOnlyTrx.hasLeftSibling()) {
                this.mNodeReadOnlyTrx.moveToLeftSibling();
                id = SirixDeweyID.newBetween(this.mNodeReadOnlyTrx.getCurrentNode().getDeweyID().get(), currID);
                this.mNodeReadOnlyTrx.moveToRightSibling();
            } else {
                id = SirixDeweyID.newBetween(null, currID);
            }
        }
        return id;
    }

    private SirixDeweyID newRightSiblingID() {
        SirixDeweyID id = null;
        if (this.mDeweyIDsStored) {
            SirixDeweyID currID = this.mNodeReadOnlyTrx.getCurrentNode().getDeweyID().get();
            if (this.mNodeReadOnlyTrx.hasRightSibling()) {
                this.mNodeReadOnlyTrx.moveToRightSibling();
                id = SirixDeweyID.newBetween(currID, this.mNodeReadOnlyTrx.getCurrentNode().getDeweyID().get());
                this.mNodeReadOnlyTrx.moveToLeftSibling();
            } else {
                id = SirixDeweyID.newBetween(currID, null);
            }
        }
        return id;
    }

    private static byte[] getBytes(String value) {
        return value.getBytes(Constants.DEFAULT_ENCODING);
    }

    @Override
    public XmlNodeTrx insertAttribute(QNm name, String value) {
        return this.insertAttribute(name, value, Movement.NONE);
    }

    @Override
    public XmlNodeTrx insertAttribute(QNm name, String value, Movement move) {
        Preconditions.checkNotNull((Object)value);
        if (!XMLToken.isValidQName((QNm)Preconditions.checkNotNull((Object)name))) {
            throw new IllegalArgumentException("The QName is not valid!");
        }
        this.acquireLock();
        try {
            if (this.getCurrentNode().getKind() == Kind.ELEMENT) {
                this.checkAccessAndCommit();
                ElementNode element = (ElementNode)this.getCurrentNode();
                Optional<Long> attKey = element.getAttributeKeyByName(name);
                if (attKey.isPresent()) {
                    this.moveTo(attKey.get());
                    QNm qName = this.getName();
                    if (name.equals((Object)qName)) {
                        if (this.getValue().equals(value)) {
                            XmlNodeTrxImpl xmlNodeTrxImpl = this;
                            return xmlNodeTrxImpl;
                        }
                        this.setValue(value);
                    }
                    this.moveToParent();
                }
                long pathNodeKey = this.mResourceManager.getResourceConfig().withPathSummary ? this.mPathSummaryWriter.getPathNodeKey(name, Kind.ATTRIBUTE) : 0L;
                byte[] attValue = XmlNodeTrxImpl.getBytes(value);
                SirixDeweyID id = this.newAttributeID();
                long elementKey = this.getCurrentNode().getNodeKey();
                AttributeNode node = this.mNodeFactory.createAttributeNode(elementKey, name, attValue, pathNodeKey, id);
                Node parentNode = (Node)this.mPageWriteTrx.prepareEntryForModification(node.getParentKey(), PageKind.RECORDPAGE, -1);
                ((ElementNode)parentNode).insertAttribute(node.getNodeKey(), node.getPrefixKey() + node.getLocalNameKey());
                this.mNodeReadOnlyTrx.setCurrentNode(node);
                this.adaptHashesWithAdd();
                this.mIndexController.notifyChange(XmlIndexController.ChangeType.INSERT, node, pathNodeKey);
                if (move == Movement.TOPARENT) {
                    this.moveToParent();
                }
                XmlNodeTrxImpl xmlNodeTrxImpl = this;
                return xmlNodeTrxImpl;
            }
            throw new SirixUsageException(new String[]{"Insert is not allowed if current node is not an ElementNode!"});
        }
        finally {
            this.unLock();
        }
    }

    @Override
    public XmlNodeTrx insertNamespace(QNm name) {
        return this.insertNamespace(name, Movement.NONE);
    }

    @Override
    public XmlNodeTrx insertNamespace(QNm name, Movement move) {
        if (!XMLToken.isValidQName((QNm)Preconditions.checkNotNull((Object)name))) {
            throw new IllegalArgumentException("The QName is not valid!");
        }
        this.acquireLock();
        try {
            if (this.getCurrentNode().getKind() == Kind.ELEMENT) {
                this.checkAccessAndCommit();
                int namespCount = ((ElementNode)this.getCurrentNode()).getNamespaceCount();
                for (int i = 0; i < namespCount; ++i) {
                    this.moveToNamespace(i);
                    QNm qName = this.getName();
                    if (name.getPrefix().equals(qName.getPrefix())) {
                        throw new SirixUsageException(new String[]{"Duplicate namespace!"});
                    }
                    this.moveToParent();
                }
                long pathNodeKey = this.mBuildPathSummary ? this.mPathSummaryWriter.getPathNodeKey(name, Kind.NAMESPACE) : 0L;
                long elementKey = this.getCurrentNode().getNodeKey();
                SirixDeweyID id = this.newNamespaceID();
                NamespaceNode node = this.mNodeFactory.createNamespaceNode(elementKey, name, pathNodeKey, id);
                Node parentNode = (Node)this.mPageWriteTrx.prepareEntryForModification(node.getParentKey(), PageKind.RECORDPAGE, -1);
                ((ElementNode)parentNode).insertNamespace(node.getNodeKey());
                this.mNodeReadOnlyTrx.setCurrentNode(node);
                this.adaptHashesWithAdd();
                if (move == Movement.TOPARENT) {
                    this.moveToParent();
                }
                XmlNodeTrxImpl xmlNodeTrxImpl = this;
                return xmlNodeTrxImpl;
            }
            throw new SirixUsageException(new String[]{"Insert is not allowed if current node is not an ElementNode!"});
        }
        finally {
            this.unLock();
        }
    }

    private void checkAncestors(Node node) {
        assert (node != null);
        ImmutableXmlNode item = this.getCurrentNode();
        while (this.getCurrentNode().hasParent()) {
            this.moveToParent();
            if (this.getCurrentNode().getNodeKey() != node.getNodeKey()) continue;
            throw new IllegalStateException("Moving one of the ancestor nodes is not permitted!");
        }
        this.moveTo(item.getNodeKey());
    }

    @Override
    public XmlNodeTrx remove() {
        this.checkAccessAndCommit();
        this.acquireLock();
        try {
            ImmutableNode node;
            if (this.getCurrentNode().getKind() == Kind.XDM_DOCUMENT) {
                throw new SirixUsageException(new String[]{"Document root can not be removed."});
            }
            if (this.getCurrentNode() instanceof StructNode) {
                node = (StructNode)((Object)this.mNodeReadOnlyTrx.getCurrentNode());
                PostOrderAxis axis = new PostOrderAxis(this);
                while (axis.hasNext()) {
                    axis.next();
                    this.removeName();
                    this.removeNonStructural();
                    this.removeValue();
                    this.mPageWriteTrx.removeEntry(this.getCurrentNode().getNodeKey(), PageKind.RECORDPAGE, -1);
                }
                ImmutableXmlNode xdmNode = (ImmutableXmlNode)node;
                this.mNodeReadOnlyTrx.setCurrentNode(xdmNode);
                this.adaptHashesWithRemove();
                this.adaptForRemove((StructNode)node, PageKind.RECORDPAGE);
                this.mNodeReadOnlyTrx.setCurrentNode(xdmNode);
                if (node.getKind() == Kind.ELEMENT) {
                    this.removeName();
                }
                if (!this.mNodeReadOnlyTrx.hasRightSibling() || !this.moveTo(node.getRightSiblingKey()).hasMoved()) {
                    if (node.hasLeftSibling()) {
                        this.moveTo(node.getLeftSiblingKey());
                    } else {
                        this.moveTo(node.getParentKey());
                    }
                }
            } else if (this.getCurrentNode().getKind() == Kind.ATTRIBUTE) {
                node = this.mNodeReadOnlyTrx.getCurrentNode();
                ElementNode parent = (ElementNode)this.mPageWriteTrx.prepareEntryForModification(node.getParentKey(), PageKind.RECORDPAGE, -1);
                parent.removeAttribute(node.getNodeKey());
                this.adaptHashesWithRemove();
                this.mPageWriteTrx.removeEntry(node.getNodeKey(), PageKind.RECORDPAGE, -1);
                this.removeName();
                this.mIndexController.notifyChange(XmlIndexController.ChangeType.DELETE, this.getNode(), parent.getPathNodeKey());
                this.moveToParent();
            } else if (this.getCurrentNode().getKind() == Kind.NAMESPACE) {
                node = this.mNodeReadOnlyTrx.getCurrentNode();
                ElementNode parent = (ElementNode)this.mPageWriteTrx.prepareEntryForModification(node.getParentKey(), PageKind.RECORDPAGE, -1);
                parent.removeNamespace(node.getNodeKey());
                this.adaptHashesWithRemove();
                this.mPageWriteTrx.removeEntry(node.getNodeKey(), PageKind.RECORDPAGE, -1);
                this.removeName();
                this.moveToParent();
            }
            XmlNodeTrxImpl xmlNodeTrxImpl = this;
            return xmlNodeTrxImpl;
        }
        finally {
            this.unLock();
        }
    }

    private void removeValue() throws SirixIOException {
        if (this.getCurrentNode() instanceof ValueNode) {
            long nodeKey = this.getNodeKey();
            long pathNodeKey = this.moveToParent().hasMoved() ? this.getPathNodeKey() : -1L;
            this.moveTo(nodeKey);
            this.mIndexController.notifyChange(XmlIndexController.ChangeType.DELETE, this.getNode(), pathNodeKey);
        }
    }

    private void removeNonStructural() {
        if (this.mNodeReadOnlyTrx.getKind() == Kind.ELEMENT) {
            int attCount = this.mNodeReadOnlyTrx.getAttributeCount();
            for (int i = 0; i < attCount; ++i) {
                this.moveToAttribute(i);
                this.removeName();
                this.removeValue();
                this.mPageWriteTrx.removeEntry(this.getCurrentNode().getNodeKey(), PageKind.RECORDPAGE, -1);
                this.moveToParent();
            }
            int nspCount = this.mNodeReadOnlyTrx.getNamespaceCount();
            for (int i = 0; i < nspCount; ++i) {
                this.moveToNamespace(i);
                this.removeName();
                this.mPageWriteTrx.removeEntry(this.getCurrentNode().getNodeKey(), PageKind.RECORDPAGE, -1);
                this.moveToParent();
            }
        }
    }

    private void removeName() {
        if (this.getCurrentNode() instanceof NameNode) {
            NameNode node = (NameNode)((Object)this.getCurrentNode());
            Kind nodeKind = node.getKind();
            NamePage page = (NamePage)this.mPageWriteTrx.getActualRevisionRootPage().getNamePageReference().getPage();
            page.removeName(node.getPrefixKey(), nodeKind);
            page.removeName(node.getLocalNameKey(), nodeKind);
            page.removeName(node.getURIKey(), Kind.NAMESPACE);
            assert (nodeKind != Kind.XDM_DOCUMENT);
            if (this.mBuildPathSummary) {
                this.mPathSummaryWriter.remove(node, nodeKind, page);
            }
        }
    }

    @Override
    public XmlNodeTrx setName(QNm name) {
        Preconditions.checkNotNull((Object)name);
        this.acquireLock();
        try {
            if (this.getCurrentNode() instanceof NameNode) {
                if (!this.getName().equals((Object)name)) {
                    this.checkAccessAndCommit();
                    NameNode node = (NameNode)((Object)this.mNodeReadOnlyTrx.getCurrentNode());
                    long oldHash = node.hashCode();
                    Kind nodeKind = node.getKind();
                    int oldPrefixKey = node.getPrefixKey();
                    int oldLocalNameKey = node.getLocalNameKey();
                    int oldUriKey = node.getURIKey();
                    NamePage page = (NamePage)this.mPageWriteTrx.getActualRevisionRootPage().getNamePageReference().getPage();
                    page.removeName(oldPrefixKey, nodeKind);
                    page.removeName(oldLocalNameKey, nodeKind);
                    page.removeName(oldUriKey, Kind.NAMESPACE);
                    int prefixKey = name.getPrefix() != null && !name.getPrefix().isEmpty() ? this.mPageWriteTrx.createNameKey(name.getPrefix(), node.getKind()) : -1;
                    int localNameKey = name.getLocalName() != null && !name.getLocalName().isEmpty() ? this.mPageWriteTrx.createNameKey(name.getLocalName(), node.getKind()) : -1;
                    int uriKey = name.getNamespaceURI() != null && !name.getNamespaceURI().isEmpty() ? this.mPageWriteTrx.createNameKey(name.getNamespaceURI(), Kind.NAMESPACE) : -1;
                    node = (NameNode)this.mPageWriteTrx.prepareEntryForModification(node.getNodeKey(), PageKind.RECORDPAGE, -1);
                    node.setLocalNameKey(localNameKey);
                    node.setURIKey(uriKey);
                    node.setPrefixKey(prefixKey);
                    if (this.mBuildPathSummary) {
                        this.mPathSummaryWriter.adaptPathForChangedNode(node, name, uriKey, prefixKey, localNameKey, PathSummaryWriter.OPType.SETNAME);
                    }
                    node.setPathNodeKey(this.mBuildPathSummary ? this.mPathSummaryWriter.getNodeKey() : 0L);
                    this.mNodeReadOnlyTrx.setCurrentNode((ImmutableXmlNode)((Object)node));
                    this.adaptHashedWithUpdate(oldHash);
                }
                XmlNodeTrxImpl xmlNodeTrxImpl = this;
                return xmlNodeTrxImpl;
            }
            throw new SirixUsageException(new String[]{"setName is not allowed if current node is not an INameNode implementation!"});
        }
        finally {
            this.unLock();
        }
    }

    @Override
    public XmlNodeTrx setValue(String value) {
        Preconditions.checkNotNull((Object)value);
        this.acquireLock();
        try {
            if (this.getCurrentNode() instanceof ValueNode) {
                this.checkAccessAndCommit();
                if (value.isEmpty()) {
                    this.remove();
                    XmlNodeTrxImpl xmlNodeTrxImpl = this;
                    return xmlNodeTrxImpl;
                }
                long nodeKey = this.getNodeKey();
                long pathNodeKey = this.moveToParent().trx().getPathNodeKey();
                this.moveTo(nodeKey);
                this.mIndexController.notifyChange(XmlIndexController.ChangeType.DELETE, this.getNode(), pathNodeKey);
                long oldHash = this.mNodeReadOnlyTrx.getCurrentNode().hashCode();
                byte[] byteVal = XmlNodeTrxImpl.getBytes(value);
                ValueNode node = (ValueNode)this.mPageWriteTrx.prepareEntryForModification(this.mNodeReadOnlyTrx.getCurrentNode().getNodeKey(), PageKind.RECORDPAGE, -1);
                node.setValue(byteVal);
                this.mNodeReadOnlyTrx.setCurrentNode((ImmutableXmlNode)((Object)node));
                this.adaptHashedWithUpdate(oldHash);
                this.mIndexController.notifyChange(XmlIndexController.ChangeType.INSERT, this.getNode(), pathNodeKey);
                XmlNodeTrxImpl xmlNodeTrxImpl = this;
                return xmlNodeTrxImpl;
            }
            throw new SirixUsageException(new String[]{"setValue(String) is not allowed if current node is not an IValNode implementation!"});
        }
        finally {
            this.unLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public XmlNodeTrx revertTo(@Nonnegative int revision) {
        this.acquireLock();
        try {
            this.mNodeReadOnlyTrx.assertNotClosed();
            this.mResourceManager.assertAccess(revision);
            long trxID = this.getId();
            int revNumber = this.getRevisionNumber();
            this.mResourceManager.closeNodePageWriteTransaction(this.getId());
            this.mPageWriteTrx = this.mResourceManager.createPageWriteTransaction(trxID, revision, revNumber - 1, InternalResourceManager.Abort.NO, true);
            this.mNodeReadOnlyTrx.setPageReadTransaction(null);
            this.mNodeReadOnlyTrx.setPageReadTransaction(this.mPageWriteTrx);
            this.mResourceManager.setNodePageWriteTransaction(this.getId(), this.mPageWriteTrx);
            this.mNodeFactory = null;
            this.mNodeFactory = new XmlNodeFactoryImpl(this.mPageWriteTrx);
            this.reInstantiateIndexes();
            this.mModificationCount = 0L;
            this.moveToDocumentRoot();
            XmlNodeTrxImpl xmlNodeTrxImpl = this;
            return xmlNodeTrxImpl;
        }
        finally {
            this.unLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        block6: {
            this.acquireLock();
            try {
                if (this.isClosed()) break block6;
                if (this.mModificationCount > 0L) {
                    throw new SirixUsageException(new String[]{"Must commit/rollback transaction first!"});
                }
                long trxId = this.getId();
                this.mNodeReadOnlyTrx.close();
                this.mResourceManager.closeWriteTransaction(trxId);
                this.removeCommitFile();
                this.mPathSummaryWriter = null;
                this.mNodeFactory = null;
                this.mPool.shutdown();
                try {
                    this.mPool.awaitTermination(2L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    throw new SirixThreadedException(e);
                }
            }
            finally {
                this.unLock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public XmlNodeTrx rollback() {
        this.acquireLock();
        try {
            this.mNodeReadOnlyTrx.assertNotClosed();
            this.mModificationCount = 0L;
            long trxID = this.getId();
            int revision = this.getRevisionNumber();
            int revNumber = this.mPageWriteTrx.getUberPage().isBootstrap() ? 0 : revision - 1;
            UberPage uberPage = this.mPageWriteTrx.rollback();
            this.mResourceManager.setLastCommittedUberPage(uberPage);
            this.mNodeReadOnlyTrx.getPageTrx().clearCaches();
            this.mNodeReadOnlyTrx.getPageTrx().closeCaches();
            this.mResourceManager.closeNodePageWriteTransaction(this.getId());
            this.mNodeReadOnlyTrx.setPageReadTransaction(null);
            this.removeCommitFile();
            this.mPageWriteTrx = this.mResourceManager.createPageWriteTransaction(trxID, revNumber, revNumber, InternalResourceManager.Abort.YES, true);
            this.mNodeReadOnlyTrx.setPageReadTransaction(this.mPageWriteTrx);
            this.mResourceManager.setNodePageWriteTransaction(this.getId(), this.mPageWriteTrx);
            this.mNodeFactory = null;
            this.mNodeFactory = new XmlNodeFactoryImpl(this.mPageWriteTrx);
            this.reInstantiateIndexes();
            XmlNodeTrxImpl xmlNodeTrxImpl = this;
            return xmlNodeTrxImpl;
        }
        finally {
            this.unLock();
        }
    }

    private void removeCommitFile() {
        try {
            Path commitFile = this.mResourceManager.getCommitFile();
            if (Files.exists(commitFile, new LinkOption[0])) {
                Files.delete(this.mResourceManager.getCommitFile());
            }
        }
        catch (IOException e) {
            throw new SirixIOException(e);
        }
    }

    @Override
    public XmlNodeTrx commit() {
        return this.commit(null);
    }

    private void reInstantiateIndexes() {
        if (this.mBuildPathSummary) {
            this.mPathSummaryWriter = null;
            this.mPathSummaryWriter = new PathSummaryWriter<InternalXmlNodeReadTrx>(this.mPageWriteTrx, this.mNodeReadOnlyTrx.getResourceManager(), this.mNodeFactory, this.mNodeReadOnlyTrx);
        }
        this.mIndexController.createIndexListeners(this.mIndexController.getIndexes().getIndexDefs(), this);
    }

    private void postOrderTraversalHashes() throws SirixIOException {
        new PostOrderAxis(this, IncludeSelf.YES).forEach(unused -> {
            StructNode node = this.mNodeReadOnlyTrx.getStructuralNode();
            if (node.getKind() == Kind.ELEMENT) {
                int i;
                ElementNode element = (ElementNode)node;
                int nspCount = element.getNamespaceCount();
                for (i = 0; i < nspCount; ++i) {
                    this.moveToNamespace(i);
                    this.addHashAndDescendantCount();
                    this.moveToParent();
                }
                int attCount = element.getAttributeCount();
                for (i = 0; i < attCount; ++i) {
                    this.moveToAttribute(i);
                    this.addHashAndDescendantCount();
                    this.moveToParent();
                }
            }
            this.addHashAndDescendantCount();
        });
    }

    private void addParentHash(ImmutableNode startNode) throws SirixIOException {
        switch (this.mHashKind) {
            case ROLLING: {
                long hashToAdd = this.mHash.hashLong((long)startNode.hashCode()).asLong();
                Node node = (Node)this.mPageWriteTrx.prepareEntryForModification(this.mNodeReadOnlyTrx.getCurrentNode().getNodeKey(), PageKind.RECORDPAGE, -1);
                node.setHash(node.getHash() + hashToAdd * 77081L);
                if (!(startNode instanceof StructNode)) break;
                ((StructNode)node).setDescendantCount(((StructNode)node).getDescendantCount() + ((StructNode)startNode).getDescendantCount() + 1L);
                break;
            }
            case POSTORDER: {
                break;
            }
        }
    }

    private void addHashAndDescendantCount() throws SirixIOException {
        switch (this.mHashKind) {
            case ROLLING: {
                ImmutableXmlNode startNode = this.getCurrentNode();
                long oldDescendantCount = this.mNodeReadOnlyTrx.getStructuralNode().getDescendantCount();
                long descendantCount = oldDescendantCount == 0L ? 1L : oldDescendantCount + 1L;
                long hashToAdd = this.mHash.hashLong((long)startNode.hashCode()).asLong();
                Node node = (Node)this.mPageWriteTrx.prepareEntryForModification(this.mNodeReadOnlyTrx.getCurrentNode().getNodeKey(), PageKind.RECORDPAGE, -1);
                node.setHash(hashToAdd);
                if (startNode.hasParent()) {
                    this.moveToParent();
                    node = (Node)this.mPageWriteTrx.prepareEntryForModification(this.mNodeReadOnlyTrx.getCurrentNode().getNodeKey(), PageKind.RECORDPAGE, -1);
                    node.setHash(node.getHash() + hashToAdd * 77081L);
                    XmlNodeTrxImpl.setAddDescendants(startNode, node, descendantCount);
                }
                this.mNodeReadOnlyTrx.setCurrentNode(startNode);
                break;
            }
            case POSTORDER: {
                this.postorderAdd();
                break;
            }
        }
    }

    private void checkAccessAndCommit() {
        this.mNodeReadOnlyTrx.assertNotClosed();
        ++this.mModificationCount;
        this.intermediateCommitIfRequired();
    }

    private void adaptForInsert(Node newNode, InsertPos insertPos, PageKind pageKind) throws SirixIOException {
        assert (newNode != null);
        assert (insertPos != null);
        assert (pageKind != null);
        if (newNode instanceof StructNode) {
            StructNode strucNode = (StructNode)newNode;
            StructNode parent = (StructNode)this.mPageWriteTrx.prepareEntryForModification(newNode.getParentKey(), pageKind, -1);
            parent.incrementChildCount();
            if (!((StructNode)newNode).hasLeftSibling()) {
                parent.setFirstChildKey(newNode.getNodeKey());
            }
            if (strucNode.hasRightSibling()) {
                StructNode rightSiblingNode = (StructNode)this.mPageWriteTrx.prepareEntryForModification(strucNode.getRightSiblingKey(), pageKind, -1);
                rightSiblingNode.setLeftSiblingKey(newNode.getNodeKey());
            }
            if (strucNode.hasLeftSibling()) {
                StructNode leftSiblingNode = (StructNode)this.mPageWriteTrx.prepareEntryForModification(strucNode.getLeftSiblingKey(), pageKind, -1);
                leftSiblingNode.setRightSiblingKey(newNode.getNodeKey());
            }
        }
    }

    private void adaptForRemove(StructNode oldNode, PageKind page) {
        assert (oldNode != null);
        boolean concatenated = false;
        if (oldNode.hasLeftSibling() && oldNode.hasRightSibling() && this.moveTo(oldNode.getRightSiblingKey()).hasMoved() && this.getCurrentNode().getKind() == Kind.TEXT && this.moveTo(oldNode.getLeftSiblingKey()).hasMoved() && this.getCurrentNode().getKind() == Kind.TEXT) {
            StringBuilder builder = new StringBuilder(this.getValue());
            this.moveTo(oldNode.getRightSiblingKey());
            builder.append(this.getValue());
            this.moveTo(oldNode.getLeftSiblingKey());
            this.setValue(builder.toString());
            concatenated = true;
        }
        if (oldNode.hasLeftSibling()) {
            StructNode leftSibling = (StructNode)this.mPageWriteTrx.prepareEntryForModification(oldNode.getLeftSiblingKey(), page, -1);
            if (concatenated) {
                this.moveTo(oldNode.getRightSiblingKey());
                leftSibling.setRightSiblingKey(((StructNode)((Object)this.getCurrentNode())).getRightSiblingKey());
            } else {
                leftSibling.setRightSiblingKey(oldNode.getRightSiblingKey());
            }
        }
        if (oldNode.hasRightSibling()) {
            StructNode rightSibling;
            if (concatenated) {
                this.moveTo(oldNode.getRightSiblingKey());
                this.moveTo(this.mNodeReadOnlyTrx.getStructuralNode().getRightSiblingKey());
                rightSibling = (StructNode)this.mPageWriteTrx.prepareEntryForModification(this.mNodeReadOnlyTrx.getCurrentNode().getNodeKey(), page, -1);
                rightSibling.setLeftSiblingKey(oldNode.getLeftSiblingKey());
            } else {
                rightSibling = (StructNode)this.mPageWriteTrx.prepareEntryForModification(oldNode.getRightSiblingKey(), page, -1);
                rightSibling.setLeftSiblingKey(oldNode.getLeftSiblingKey());
            }
        }
        StructNode parent = (StructNode)this.mPageWriteTrx.prepareEntryForModification(oldNode.getParentKey(), page, -1);
        if (!oldNode.hasLeftSibling()) {
            parent.setFirstChildKey(oldNode.getRightSiblingKey());
        }
        parent.decrementChildCount();
        if (concatenated) {
            parent.decrementDescendantCount();
            parent.decrementChildCount();
        }
        if (concatenated) {
            this.moveTo(parent.getNodeKey());
            while (parent.hasParent()) {
                this.moveToParent();
                StructNode ancestor = (StructNode)this.mPageWriteTrx.prepareEntryForModification(this.mNodeReadOnlyTrx.getCurrentNode().getNodeKey(), page, -1);
                ancestor.decrementDescendantCount();
                parent = ancestor;
            }
        }
        if (concatenated) {
            this.moveTo(oldNode.getRightSiblingKey());
            this.mPageWriteTrx.removeEntry(this.mNodeReadOnlyTrx.getNodeKey(), page, -1);
        }
        if (oldNode.getKind() == Kind.ELEMENT) {
            this.moveTo(oldNode.getNodeKey());
            this.removeNonStructural();
        }
        this.moveTo(oldNode.getNodeKey());
        this.mPageWriteTrx.removeEntry(oldNode.getNodeKey(), page, -1);
    }

    private void intermediateCommitIfRequired() {
        this.mNodeReadOnlyTrx.assertNotClosed();
        if (this.mMaxNodeCount > 0 && this.mModificationCount > (long)this.mMaxNodeCount) {
            this.commit();
        }
    }

    private void adaptHashesWithAdd() throws SirixIOException {
        if (!this.mBulkInsert) {
            switch (this.mHashKind) {
                case ROLLING: {
                    this.rollingAdd();
                    break;
                }
                case POSTORDER: {
                    this.postorderAdd();
                    break;
                }
            }
        }
    }

    private void adaptHashesWithRemove() throws SirixIOException {
        if (!this.mBulkInsert) {
            switch (this.mHashKind) {
                case ROLLING: {
                    this.rollingRemove();
                    break;
                }
                case POSTORDER: {
                    this.postorderRemove();
                    break;
                }
            }
        }
    }

    private void adaptHashedWithUpdate(long pOldHash) throws SirixIOException {
        if (!this.mBulkInsert) {
            switch (this.mHashKind) {
                case ROLLING: {
                    this.rollingUpdate(pOldHash);
                    break;
                }
                case POSTORDER: {
                    this.postorderAdd();
                    break;
                }
            }
        }
    }

    private void postorderRemove() {
        this.moveTo(this.getCurrentNode().getParentKey());
        this.postorderAdd();
    }

    private void postorderAdd() {
        StructNode cursorToRoot;
        ImmutableXmlNode startNode = this.getCurrentNode();
        long hashCodeForParent = 0L;
        if (!(startNode instanceof ImmutableStructNode)) {
            Node node = (Node)this.mPageWriteTrx.prepareEntryForModification(this.mNodeReadOnlyTrx.getCurrentNode().getNodeKey(), PageKind.RECORDPAGE, -1);
            node.setHash(this.mHash.hashLong((long)this.mNodeReadOnlyTrx.getCurrentNode().hashCode()).asLong());
            this.moveTo(this.mNodeReadOnlyTrx.getCurrentNode().getParentKey());
        }
        do {
            cursorToRoot = (StructNode)this.mPageWriteTrx.prepareEntryForModification(this.mNodeReadOnlyTrx.getCurrentNode().getNodeKey(), PageKind.RECORDPAGE, -1);
            hashCodeForParent = (long)this.mNodeReadOnlyTrx.getCurrentNode().hashCode() + hashCodeForParent * 77081L;
            if (cursorToRoot.getKind() == Kind.ELEMENT) {
                ElementNode currentElement = (ElementNode)cursorToRoot;
                int attCount = ((ElementNode)cursorToRoot).getAttributeCount();
                for (int i = 0; i < attCount; ++i) {
                    this.moveTo(currentElement.getAttributeKey(i));
                    hashCodeForParent = (long)this.mNodeReadOnlyTrx.getCurrentNode().hashCode() + hashCodeForParent * 77081L;
                }
                int nspCount = ((ElementNode)cursorToRoot).getNamespaceCount();
                for (int i = 0; i < nspCount; ++i) {
                    this.moveTo(currentElement.getNamespaceKey(i));
                    hashCodeForParent = (long)this.mNodeReadOnlyTrx.getCurrentNode().hashCode() + hashCodeForParent * 77081L;
                }
                this.moveTo(cursorToRoot.getNodeKey());
            }
            if (this.moveTo(this.mNodeReadOnlyTrx.getStructuralNode().getFirstChildKey()).hasMoved()) {
                do {
                    hashCodeForParent = this.mNodeReadOnlyTrx.getCurrentNode().getHash() + hashCodeForParent * 77081L;
                } while (this.moveTo(this.mNodeReadOnlyTrx.getStructuralNode().getRightSiblingKey()).hasMoved());
                this.moveTo(this.mNodeReadOnlyTrx.getStructuralNode().getParentKey());
            }
            cursorToRoot.setHash(hashCodeForParent);
            hashCodeForParent = 0L;
        } while (this.moveTo(cursorToRoot.getParentKey()).hasMoved());
        this.mNodeReadOnlyTrx.setCurrentNode(startNode);
    }

    private void rollingUpdate(long oldHash) {
        long hash;
        ImmutableXmlNode newNode = this.getCurrentNode();
        long newNodeHash = hash = (long)newNode.hashCode();
        long resultNew = hash;
        do {
            Node node;
            if ((node = (Node)this.mPageWriteTrx.prepareEntryForModification(this.mNodeReadOnlyTrx.getCurrentNode().getNodeKey(), PageKind.RECORDPAGE, -1)).getNodeKey() == newNode.getNodeKey()) {
                resultNew = node.getHash() - oldHash;
                resultNew += newNodeHash;
            } else {
                resultNew = node.getHash() - oldHash * 77081L;
                resultNew += newNodeHash * 77081L;
            }
            node.setHash(resultNew);
        } while (this.moveTo(this.mNodeReadOnlyTrx.getCurrentNode().getParentKey()).hasMoved());
        this.mNodeReadOnlyTrx.setCurrentNode(newNode);
    }

    private void rollingRemove() {
        ImmutableXmlNode startNode = this.getCurrentNode();
        long hashToRemove = startNode.getHash();
        long hashToAdd = 0L;
        long newHash = 0L;
        do {
            Node node;
            if ((node = (Node)this.mPageWriteTrx.prepareEntryForModification(this.mNodeReadOnlyTrx.getCurrentNode().getNodeKey(), PageKind.RECORDPAGE, -1)).getNodeKey() == startNode.getNodeKey()) {
                newHash = 0L;
            } else if (node.getNodeKey() == startNode.getParentKey()) {
                newHash = node.getHash() - hashToRemove * 77081L;
                hashToRemove = node.getHash();
                this.setRemoveDescendants(startNode);
            } else {
                newHash = node.getHash() - hashToRemove * 77081L;
                newHash += hashToAdd * 77081L;
                hashToRemove = node.getHash();
                this.setRemoveDescendants(startNode);
            }
            node.setHash(newHash);
            hashToAdd = newHash;
        } while (this.moveTo(this.mNodeReadOnlyTrx.getCurrentNode().getParentKey()).hasMoved());
        this.mNodeReadOnlyTrx.setCurrentNode(startNode);
    }

    private void setRemoveDescendants(ImmutableNode startNode) {
        assert (startNode != null);
        if (startNode instanceof StructNode) {
            StructNode node = (StructNode)((Object)this.getCurrentNode());
            node.setDescendantCount(node.getDescendantCount() - ((StructNode)startNode).getDescendantCount() - 1L);
        }
    }

    private void rollingAdd() throws SirixIOException {
        ImmutableXmlNode startNode = this.mNodeReadOnlyTrx.getCurrentNode();
        long oldDescendantCount = this.mNodeReadOnlyTrx.getStructuralNode().getDescendantCount();
        long descendantCount = oldDescendantCount == 0L ? 1L : oldDescendantCount + 1L;
        long hashToAdd = startNode.getHash() == 0L ? this.mHash.hashLong((long)startNode.hashCode()).asLong() : startNode.getHash();
        long newHash = 0L;
        long possibleOldHash = 0L;
        do {
            Node node;
            if ((node = (Node)this.mPageWriteTrx.prepareEntryForModification(this.mNodeReadOnlyTrx.getCurrentNode().getNodeKey(), PageKind.RECORDPAGE, -1)).getNodeKey() == startNode.getNodeKey()) {
                newHash = hashToAdd;
            } else if (node.getNodeKey() == startNode.getParentKey()) {
                possibleOldHash = node.getHash();
                hashToAdd = newHash = possibleOldHash + hashToAdd * 77081L;
                XmlNodeTrxImpl.setAddDescendants(startNode, node, descendantCount);
            } else {
                newHash = node.getHash() - possibleOldHash * 77081L;
                hashToAdd = newHash += hashToAdd * 77081L;
                possibleOldHash = node.getHash();
                XmlNodeTrxImpl.setAddDescendants(startNode, node, descendantCount);
            }
            node.setHash(newHash);
        } while (this.moveTo(this.mNodeReadOnlyTrx.getCurrentNode().getParentKey()).hasMoved());
        this.mNodeReadOnlyTrx.setCurrentNode(startNode);
    }

    private static void setAddDescendants(ImmutableNode startNode, Node nodeToModifiy, @Nonnegative long descendantCount) {
        assert (startNode != null);
        assert (descendantCount >= 0L);
        assert (nodeToModifiy != null);
        if (startNode instanceof StructNode) {
            StructNode node = (StructNode)nodeToModifiy;
            long oldDescendantCount = node.getDescendantCount();
            node.setDescendantCount(oldDescendantCount + descendantCount);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public XmlNodeTrx copySubtreeAsFirstChild(XmlNodeReadOnlyTrx rtx) {
        Preconditions.checkNotNull((Object)rtx);
        this.acquireLock();
        try {
            this.checkAccessAndCommit();
            long nodeKey = this.getCurrentNode().getNodeKey();
            this.copy(rtx, InsertPosition.AS_FIRST_CHILD);
            this.moveTo(nodeKey);
            this.moveToFirstChild();
        }
        finally {
            this.unLock();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public XmlNodeTrx copySubtreeAsLeftSibling(XmlNodeReadOnlyTrx rtx) {
        Preconditions.checkNotNull((Object)rtx);
        this.acquireLock();
        try {
            this.checkAccessAndCommit();
            long nodeKey = this.getCurrentNode().getNodeKey();
            this.copy(rtx, InsertPosition.AS_LEFT_SIBLING);
            this.moveTo(nodeKey);
            this.moveToFirstChild();
        }
        finally {
            this.unLock();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public XmlNodeTrx copySubtreeAsRightSibling(XmlNodeReadOnlyTrx rtx) {
        Preconditions.checkNotNull((Object)rtx);
        this.acquireLock();
        try {
            this.checkAccessAndCommit();
            long nodeKey = this.getCurrentNode().getNodeKey();
            this.copy(rtx, InsertPosition.AS_RIGHT_SIBLING);
            this.moveTo(nodeKey);
            this.moveToRightSibling();
        }
        finally {
            this.unLock();
        }
        return this;
    }

    private void copy(XmlNodeReadOnlyTrx trx, InsertPosition insert) {
        assert (trx != null);
        assert (insert != null);
        XmlNodeReadOnlyTrx rtx = (XmlNodeReadOnlyTrx)trx.getResourceManager().beginNodeReadOnlyTrx(trx.getRevisionNumber());
        assert (rtx.getRevisionNumber() == trx.getRevisionNumber());
        rtx.moveTo(trx.getNodeKey());
        assert (rtx.getNodeKey() == trx.getNodeKey());
        if (rtx.getKind() == Kind.XDM_DOCUMENT) {
            rtx.moveToFirstChild();
        }
        if (!rtx.isStructuralNode()) {
            throw new IllegalStateException("Node to insert must be a structural node (Text, PI, Comment, Document root or Element)!");
        }
        Kind kind = rtx.getKind();
        block0 : switch (kind) {
            case TEXT: {
                String textValue = rtx.getValue();
                switch (insert) {
                    case AS_FIRST_CHILD: {
                        this.insertTextAsFirstChild(textValue);
                        break block0;
                    }
                    case AS_LEFT_SIBLING: {
                        this.insertTextAsLeftSibling(textValue);
                        break block0;
                    }
                    case AS_RIGHT_SIBLING: {
                        this.insertTextAsRightSibling(textValue);
                        break block0;
                    }
                }
                throw new IllegalStateException();
            }
            case PROCESSING_INSTRUCTION: {
                switch (insert) {
                    case AS_FIRST_CHILD: {
                        this.insertPIAsFirstChild(rtx.getName().getLocalName(), rtx.getValue());
                        break block0;
                    }
                    case AS_LEFT_SIBLING: {
                        this.insertPIAsLeftSibling(rtx.getName().getLocalName(), rtx.getValue());
                        break block0;
                    }
                    case AS_RIGHT_SIBLING: {
                        this.insertPIAsRightSibling(rtx.getName().getLocalName(), rtx.getValue());
                        break block0;
                    }
                }
                throw new IllegalStateException();
            }
            case COMMENT: {
                String commentValue = rtx.getValue();
                switch (insert) {
                    case AS_FIRST_CHILD: {
                        this.insertCommentAsFirstChild(commentValue);
                        break block0;
                    }
                    case AS_LEFT_SIBLING: {
                        this.insertCommentAsLeftSibling(commentValue);
                        break block0;
                    }
                    case AS_RIGHT_SIBLING: {
                        this.insertCommentAsRightSibling(commentValue);
                        break block0;
                    }
                }
                throw new IllegalStateException();
            }
            default: {
                new XmlShredder.Builder(this, new StAXSerializer(rtx), insert).build().call();
            }
        }
        rtx.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public XmlNodeTrx replaceNode(XMLEventReader reader) {
        block6: {
            Preconditions.checkNotNull((Object)reader);
            this.acquireLock();
            try {
                this.checkAccessAndCommit();
                if (this.getCurrentNode() instanceof StructNode) {
                    InsertPosition pos;
                    long anchorNodeKey;
                    StructNode currentNode = this.mNodeReadOnlyTrx.getStructuralNode();
                    if (currentNode.hasLeftSibling()) {
                        anchorNodeKey = this.getLeftSiblingKey();
                        pos = InsertPosition.AS_RIGHT_SIBLING;
                    } else {
                        anchorNodeKey = this.getParentKey();
                        pos = InsertPosition.AS_FIRST_CHILD;
                    }
                    this.insertAndThenRemove(reader, pos, anchorNodeKey);
                    break block6;
                }
                throw new IllegalArgumentException("Not supported for attributes / namespaces.");
            }
            finally {
                this.unLock();
            }
        }
        return this;
    }

    private void insertAndThenRemove(XMLEventReader reader, InsertPosition pos, long anchorNodeKey) {
        long formerNodeKey = this.getNodeKey();
        this.insert(reader, pos, anchorNodeKey);
        this.moveTo(formerNodeKey);
        this.remove();
    }

    private void insert(XMLEventReader reader, InsertPosition pos, long anchorNodeKey) {
        this.moveTo(anchorNodeKey);
        XmlShredder shredder = new XmlShredder.Builder(this, reader, pos).build();
        shredder.call();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public XmlNodeTrx replaceNode(XmlNodeReadOnlyTrx rtx) {
        Preconditions.checkNotNull((Object)rtx);
        this.acquireLock();
        try {
            switch (rtx.getKind()) {
                case TEXT: 
                case PROCESSING_INSTRUCTION: 
                case COMMENT: 
                case ELEMENT: {
                    this.checkCurrentNode();
                    if (this.isText()) {
                        this.removeAndThenInsert(rtx);
                        return this;
                    } else {
                        this.insertAndThenRemove(rtx);
                        return this;
                    }
                }
                case ATTRIBUTE: {
                    if (this.getCurrentNode().getKind() != Kind.ATTRIBUTE) {
                        throw new IllegalStateException("Current node must be an attribute node!");
                    }
                    this.remove();
                    this.insertAttribute(rtx.getName(), rtx.getValue());
                    return this;
                }
                case NAMESPACE: {
                    if (this.getCurrentNode().getKind() != Kind.NAMESPACE) {
                        throw new IllegalStateException("Current node must be a namespace node!");
                    }
                    this.remove();
                    this.insertNamespace(rtx.getName());
                    return this;
                }
                default: {
                    throw new UnsupportedOperationException("Node type not supported!");
                }
            }
        }
        finally {
            this.unLock();
        }
    }

    private void checkCurrentNode() {
        if (!(this.getCurrentNode() instanceof StructNode)) {
            throw new IllegalStateException("Current node must be a structural node!");
        }
    }

    private ImmutableNode removeAndThenInsert(XmlNodeReadOnlyTrx rtx) {
        assert (rtx != null);
        StructNode currentNode = this.mNodeReadOnlyTrx.getStructuralNode();
        long key = currentNode.getNodeKey();
        if (currentNode.hasLeftSibling()) {
            long nodeKey = currentNode.getLeftSiblingKey();
            this.remove();
            this.moveTo(nodeKey);
            key = this.copySubtreeAsRightSibling(rtx).getNodeKey();
        } else {
            long nodeKey = currentNode.getParentKey();
            this.remove();
            this.moveTo(nodeKey);
            key = this.copySubtreeAsFirstChild(rtx).getNodeKey();
            this.moveTo(key);
        }
        return this.mNodeReadOnlyTrx.getCurrentNode();
    }

    private ImmutableNode insertAndThenRemove(XmlNodeReadOnlyTrx rtx) {
        assert (rtx != null);
        StructNode currentNode = this.mNodeReadOnlyTrx.getStructuralNode();
        long key = currentNode.getNodeKey();
        if (currentNode.hasLeftSibling()) {
            this.moveToLeftSibling();
            key = this.copySubtreeAsRightSibling(rtx).getNodeKey();
        } else {
            this.moveToParent();
            key = this.copySubtreeAsFirstChild(rtx).getNodeKey();
            this.moveTo(key);
        }
        this.removeOldNode(currentNode, key);
        return this.mNodeReadOnlyTrx.getNode();
    }

    private void removeOldNode(StructNode node, @Nonnegative long key) {
        assert (node != null);
        assert (key >= 0L);
        this.moveTo(node.getNodeKey());
        this.remove();
        this.moveTo(key);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("readTrx", (Object)this.mNodeReadOnlyTrx.toString()).add("hashKind", (Object)this.mHashKind).toString();
    }

    @Override
    protected XmlNodeReadOnlyTrx delegate() {
        return this.mNodeReadOnlyTrx;
    }

    public boolean equals(@Nullable Object obj) {
        if (obj instanceof XmlNodeTrxImpl) {
            XmlNodeTrxImpl wtx = (XmlNodeTrxImpl)obj;
            return Objects.equal((Object)this.mNodeReadOnlyTrx, (Object)wtx.mNodeReadOnlyTrx);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mNodeReadOnlyTrx});
    }

    @Override
    public PathSummaryReader getPathSummary() {
        this.acquireLock();
        try {
            PathSummaryReader pathSummaryReader = this.mPathSummaryWriter.getPathSummary();
            return pathSummaryReader;
        }
        finally {
            this.unLock();
        }
    }

    void acquireLock() {
        if (this.mLock != null) {
            this.mLock.lock();
        }
    }

    void unLock() {
        if (this.mLock != null) {
            this.mLock.unlock();
        }
    }

    @Override
    public XmlNodeTrx addPreCommitHook(PreCommitHook hook) {
        this.acquireLock();
        try {
            this.mPreCommitHooks.add((PreCommitHook)Preconditions.checkNotNull((Object)hook));
            XmlNodeTrxImpl xmlNodeTrxImpl = this;
            return xmlNodeTrxImpl;
        }
        finally {
            this.unLock();
        }
    }

    @Override
    public XmlNodeTrx addPostCommitHook(PostCommitHook hook) {
        this.acquireLock();
        try {
            this.mPostCommitHooks.add((PostCommitHook)Preconditions.checkNotNull((Object)hook));
            XmlNodeTrxImpl xmlNodeTrxImpl = this;
            return xmlNodeTrxImpl;
        }
        finally {
            this.unLock();
        }
    }

    @Override
    public XmlNodeTrx truncateTo(int revision) {
        this.mNodeReadOnlyTrx.assertNotClosed();
        return this;
    }

    @Override
    public CommitCredentials getCommitCredentials() {
        this.mNodeReadOnlyTrx.assertNotClosed();
        return this.mNodeReadOnlyTrx.getCommitCredentials();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public XmlNodeTrx commit(String commitMessage) {
        this.mNodeReadOnlyTrx.assertNotClosed();
        this.acquireLock();
        try {
            for (PreCommitHook preCommitHook : this.mPreCommitHooks) {
                preCommitHook.preCommit(this);
            }
            this.mModificationCount = 0L;
            UberPage uberPage = commitMessage == null ? this.mPageWriteTrx.commit() : this.mPageWriteTrx.commit(commitMessage);
            this.mResourceManager.setLastCommittedUberPage(uberPage);
            this.reInstantiate(this.getId(), this.getRevisionNumber());
        }
        finally {
            this.unLock();
        }
        for (PostCommitHook postCommitHook : this.mPostCommitHooks) {
            postCommitHook.postCommit(this);
        }
        return this;
    }

    void reInstantiate(@Nonnegative long trxID, @Nonnegative int revNumber) {
        this.mResourceManager.closeNodePageWriteTransaction(this.getId());
        this.mPageWriteTrx = this.mResourceManager.createPageWriteTransaction(trxID, revNumber, revNumber, InternalResourceManager.Abort.NO, true);
        this.mNodeReadOnlyTrx.setPageReadTransaction(null);
        this.mNodeReadOnlyTrx.setPageReadTransaction(this.mPageWriteTrx);
        this.mResourceManager.setNodePageWriteTransaction(this.getId(), this.mPageWriteTrx);
        this.mNodeFactory = null;
        this.mNodeFactory = new XmlNodeFactoryImpl(this.mPageWriteTrx);
        this.reInstantiateIndexes();
    }

    @Override
    public PageTrx<Long, Record, UnorderedKeyValuePage> getPageWtx() {
        this.mNodeReadOnlyTrx.assertNotClosed();
        return this.mPageWriteTrx;
    }
}

