/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.access.xml;

import com.google.common.base.Preconditions;
import java.nio.file.Path;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.locks.Lock;
import javax.annotation.Nonnull;
import org.sirix.access.AbstractResourceStore;
import org.sirix.access.Databases;
import org.sirix.access.ResourceConfiguration;
import org.sirix.access.trx.node.xml.XmlResourceManagerImpl;
import org.sirix.api.Database;
import org.sirix.api.xml.XmlResourceManager;
import org.sirix.cache.BufferManager;
import org.sirix.io.Storage;
import org.sirix.io.StorageType;
import org.sirix.page.UberPage;

public final class XmlResourceStore
extends AbstractResourceStore<XmlResourceManager> {
    public XmlResourceStore() {
        super(new ConcurrentHashMap());
    }

    @Override
    public XmlResourceManager openResource(@Nonnull Database<XmlResourceManager> database, @Nonnull ResourceConfiguration resourceConfig, @Nonnull BufferManager bufferManager, @Nonnull Path resourceFile) {
        Preconditions.checkNotNull(database);
        Preconditions.checkNotNull((Object)resourceConfig);
        Preconditions.checkNotNull((Object)bufferManager);
        Preconditions.checkNotNull((Object)resourceFile);
        return this.mResourceManagers.computeIfAbsent(resourceFile, k -> {
            Storage storage = StorageType.getStorage(resourceConfig);
            UberPage uberPage = this.getUberPage(storage);
            Semaphore readSem = Databases.computeReadSempahoreIfAbsent(resourceConfig.getResource(), database.getDatabaseConfig().getMaxResourceReadTrx());
            Lock writeLock = Databases.computeWriteLockIfAbsent(resourceConfig.getResource());
            XmlResourceManagerImpl resourceManager = new XmlResourceManagerImpl(database, this, resourceConfig, bufferManager, StorageType.getStorage(resourceConfig), uberPage, readSem, writeLock);
            Databases.putResourceManager(resourceFile, resourceManager);
            return resourceManager;
        });
    }
}

