/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.axis;

import com.google.common.base.Preconditions;
import java.util.ArrayDeque;
import java.util.Deque;
import javax.annotation.Nonnegative;
import org.sirix.api.NodeCursor;
import org.sirix.api.xml.XmlNodeReadOnlyTrx;
import org.sirix.axis.AbstractAxis;
import org.sirix.axis.IncludeSelf;
import org.sirix.node.Kind;

public final class LevelOrderAxis
extends AbstractAxis {
    private Deque<Long> mFirstChilds;
    private final IncludeNodes mIncludeNodes;
    private boolean mFirst;
    private int mFilterLevel = Integer.MAX_VALUE;
    private int mLevel;

    public static Builder newBuilder(NodeCursor rtx) {
        return new Builder(rtx);
    }

    private LevelOrderAxis(Builder builder) {
        super(builder.mRtx, builder.mIncludeSelf);
        this.mIncludeNodes = builder.mIncludeNodes;
        this.mFilterLevel = builder.mFilterLevel;
    }

    @Override
    public void reset(long pNodeKey) {
        super.reset(pNodeKey);
        this.mFirst = true;
        this.mFirstChilds = new ArrayDeque<Long>();
    }

    @Override
    protected long nextKey() {
        NodeCursor cursor = this.getCursor();
        if (this.mFirst) {
            this.mFirst = false;
            if (cursor.getKind() == Kind.ATTRIBUTE || cursor.getKind() == Kind.NAMESPACE) {
                return this.done();
            }
            if (this.isSelfIncluded() == IncludeSelf.YES) {
                return cursor.getNodeKey();
            }
            if (cursor.hasRightSibling()) {
                return cursor.getRightSiblingKey();
            }
            if (cursor.hasFirstChild()) {
                return cursor.getFirstChildKey();
            }
            return this.done();
        }
        if (cursor.hasRightSibling()) {
            this.processElement();
            if (cursor.hasFirstChild()) {
                this.mFirstChilds.add(cursor.getFirstChildKey());
            }
            return cursor.getRightSiblingKey();
        }
        this.processElement();
        if (cursor.hasFirstChild()) {
            this.mFirstChilds.add(cursor.getFirstChildKey());
        }
        if (!this.mFirstChilds.isEmpty()) {
            ++this.mLevel;
            if (this.mLevel > this.mFilterLevel) {
                return this.done();
            }
            return this.mFirstChilds.pollFirst();
        }
        if (cursor.hasFirstChild()) {
            ++this.mLevel;
            if (this.mLevel > this.mFilterLevel) {
                return this.done();
            }
            return cursor.getFirstChildKey();
        }
        return this.done();
    }

    public int getCurrentLevel() {
        return this.mLevel;
    }

    private void processElement() {
        XmlNodeReadOnlyTrx rtx;
        if (this.getCursor() instanceof XmlNodeReadOnlyTrx && (rtx = this.asXdmNodeReadTrx()).getKind() == Kind.ELEMENT && this.mIncludeNodes == IncludeNodes.NONSTRUCTURAL) {
            int i;
            int nspCount = rtx.getNamespaceCount();
            for (i = 0; i < nspCount; ++i) {
                rtx.moveToNamespace(i);
                this.mFirstChilds.add(rtx.getNodeKey());
                rtx.moveToParent();
            }
            int attCount = rtx.getAttributeCount();
            for (i = 0; i < attCount; ++i) {
                rtx.moveToAttribute(i);
                this.mFirstChilds.add(rtx.getNodeKey());
                rtx.moveToParent();
            }
        }
    }

    public static class Builder {
        private IncludeNodes mIncludeNodes = IncludeNodes.STRUCTURAL;
        private int mFilterLevel = Integer.MAX_VALUE;
        private final NodeCursor mRtx;
        private IncludeSelf mIncludeSelf = IncludeSelf.NO;

        public Builder(NodeCursor rtx) {
            this.mRtx = (NodeCursor)Preconditions.checkNotNull((Object)rtx);
        }

        public Builder includeNonStructuralNodes() {
            this.mIncludeNodes = IncludeNodes.NONSTRUCTURAL;
            return this;
        }

        public Builder includeSelf() {
            this.mIncludeSelf = IncludeSelf.YES;
            return this;
        }

        public Builder filterLevel(@Nonnegative int filterLevel) {
            Preconditions.checkArgument((filterLevel >= 0 ? 1 : 0) != 0, (Object)"filterLevel must be >= 0!");
            this.mFilterLevel = filterLevel;
            return this;
        }

        public LevelOrderAxis build() {
            return new LevelOrderAxis(this);
        }
    }

    private static enum IncludeNodes {
        STRUCTURAL,
        NONSTRUCTURAL;

    }
}

