/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.axis;

import org.sirix.api.NodeCursor;
import org.sirix.axis.AbstractAxis;
import org.sirix.axis.IncludeSelf;
import org.sirix.settings.Fixed;

public final class PostOrderAxis
extends AbstractAxis {
    private boolean mMovedToParent;
    private boolean mIsStartKey;

    public PostOrderAxis(NodeCursor cursor) {
        super(cursor);
    }

    public PostOrderAxis(NodeCursor cursor, IncludeSelf includeSelf) {
        super(cursor, includeSelf);
    }

    @Override
    public void reset(long nodeKey) {
        super.reset(nodeKey);
        this.mMovedToParent = false;
        this.mIsStartKey = false;
    }

    @Override
    protected long nextKey() {
        NodeCursor cursor = this.getCursor();
        if (!cursor.hasFirstChild() && cursor.getNodeKey() == this.getStartKey() || this.mIsStartKey) {
            if (!this.mIsStartKey && this.isSelfIncluded() == IncludeSelf.YES) {
                this.mIsStartKey = true;
                return cursor.getNodeKey();
            }
            return this.done();
        }
        long currKey = cursor.getNodeKey();
        if (!this.mMovedToParent && cursor.hasFirstChild() || cursor.hasRightSibling() && cursor.moveToRightSibling().hasMoved()) {
            while (cursor.hasFirstChild()) {
                cursor.moveToFirstChild();
            }
            long key = cursor.getNodeKey();
            cursor.moveTo(currKey);
            return key;
        }
        long key = 0L;
        if (cursor.hasRightSibling()) {
            key = cursor.getRightSiblingKey();
        } else {
            key = cursor.getParentKey();
            this.mMovedToParent = true;
        }
        if (key == Fixed.NULL_NODE_KEY.getStandardProperty()) {
            return key;
        }
        if (key == this.getStartKey()) {
            if (this.isSelfIncluded() == IncludeSelf.YES) {
                this.mIsStartKey = true;
                return key;
            }
            return this.done();
        }
        cursor.moveTo(currKey);
        return key;
    }
}

