/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.axis;

import java.util.ArrayDeque;
import java.util.Deque;
import org.sirix.api.NodeCursor;
import org.sirix.axis.AbstractAxis;
import org.sirix.node.Kind;

public final class PrecedingAxis
extends AbstractAxis {
    private boolean mIsFirst = true;
    private Deque<Long> mStack = new ArrayDeque<Long>();

    public PrecedingAxis(NodeCursor cursor) {
        super(cursor);
    }

    @Override
    public void reset(long nodeKey) {
        super.reset(nodeKey);
        this.mIsFirst = true;
        this.mStack = new ArrayDeque<Long>();
    }

    @Override
    protected long nextKey() {
        NodeCursor cursor = this.getCursor();
        if (this.mIsFirst) {
            this.mIsFirst = false;
            if (cursor.getKind() == Kind.ATTRIBUTE || cursor.getKind() == Kind.NAMESPACE) {
                return this.done();
            }
        }
        long key = cursor.getNodeKey();
        if (!this.mStack.isEmpty()) {
            return this.mStack.pop();
        }
        if (cursor.hasLeftSibling()) {
            cursor.moveToLeftSibling();
            this.getLastChild();
            long nodeKey = cursor.getNodeKey();
            cursor.moveTo(key);
            return nodeKey;
        }
        while (cursor.hasParent()) {
            cursor.moveToParent();
            if (!cursor.hasLeftSibling()) continue;
            cursor.moveToLeftSibling();
            this.getLastChild();
            long nodeKey = cursor.getNodeKey();
            cursor.moveTo(key);
            return nodeKey;
        }
        return this.done();
    }

    private void getLastChild() {
        NodeCursor cursor = this.getCursor();
        long parent = cursor.getNodeKey();
        if (cursor.hasFirstChild()) {
            while (cursor.hasFirstChild()) {
                this.mStack.push(cursor.getNodeKey());
                cursor.moveToFirstChild();
            }
            while (cursor.hasRightSibling()) {
                this.mStack.push(cursor.getNodeKey());
                cursor.moveToRightSibling();
                this.getLastChild();
            }
            if (cursor.hasParent() && cursor.getParentKey() != parent) {
                this.mStack.push(cursor.getNodeKey());
                while (cursor.hasParent() && cursor.getParentKey() != parent) {
                    cursor.moveToParent();
                    while (cursor.hasRightSibling()) {
                        cursor.moveToRightSibling();
                        this.getLastChild();
                        this.mStack.push(cursor.getNodeKey());
                    }
                }
                cursor.moveTo(this.mStack.pop());
            }
        }
    }
}

