/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.axis.concurrent;

import com.google.common.base.Preconditions;
import java.util.concurrent.BlockingQueue;
import javax.annotation.Nonnull;
import org.sirix.api.Axis;
import org.sirix.settings.Fixed;
import org.sirix.utils.LogWrapper;
import org.slf4j.LoggerFactory;

public class ConcurrentAxisHelper
implements Runnable {
    public static final LogWrapper LOGWRAPPER = new LogWrapper(LoggerFactory.getLogger(ConcurrentAxisHelper.class));
    private final Axis mAxis;
    private BlockingQueue<Long> mResults;

    public ConcurrentAxisHelper(Axis axis, @Nonnull BlockingQueue<Long> results) {
        this.mAxis = (Axis)Preconditions.checkNotNull((Object)axis);
        this.mResults = (BlockingQueue)Preconditions.checkNotNull(results);
    }

    @Override
    public void run() {
        while (this.mAxis.hasNext()) {
            long nodeKey = (Long)this.mAxis.next();
            try {
                this.mResults.put(nodeKey);
            }
            catch (InterruptedException e) {
                LOGWRAPPER.error(e.getMessage(), e);
            }
        }
        try {
            this.mResults.put(Fixed.NULL_NODE_KEY.getStandardProperty());
        }
        catch (InterruptedException e) {
            LOGWRAPPER.error(e.getMessage(), e);
        }
    }
}

