/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.axis.filter;

import java.util.ArrayList;
import java.util.List;
import org.sirix.api.Axis;
import org.sirix.api.Filter;
import org.sirix.api.NodeCursor;
import org.sirix.api.NodeReadOnlyTrx;
import org.sirix.axis.AbstractAxis;

public final class FilterAxis<R extends NodeReadOnlyTrx & NodeCursor>
extends AbstractAxis {
    private final Axis mAxis;
    private final List<Filter<R>> mAxisFilter;

    @SafeVarargs
    public FilterAxis(Axis axis, Filter<R> firstAxisTest, Filter<R> ... axisTest) {
        super(axis.getCursor());
        this.mAxis = axis;
        this.mAxisFilter = new ArrayList<Filter<R>>();
        this.mAxisFilter.add(firstAxisTest);
        if (!this.mAxis.getCursor().equals(this.mAxisFilter.get(0).getTrx())) {
            throw new IllegalArgumentException("The filter must be bound to the same transaction as the axis!");
        }
        if (axisTest != null) {
            for (Filter<R> filter : axisTest) {
                this.mAxisFilter.add(filter);
                if (this.mAxis.getCursor().equals(this.mAxisFilter.get(this.mAxisFilter.size() - 1).getTrx())) continue;
                throw new IllegalArgumentException("The filter must be bound to the same transaction as the axis!");
            }
        }
    }

    @Override
    public void reset(long nodeKey) {
        super.reset(nodeKey);
        if (this.mAxis != null) {
            this.mAxis.reset(nodeKey);
        }
    }

    @Override
    protected long nextKey() {
        while (this.mAxis.hasNext()) {
            long nodeKey = (Long)this.mAxis.next();
            boolean filterResult = true;
            for (Filter<R> filter : this.mAxisFilter) {
                if (filterResult = filterResult && filter.filter()) continue;
                break;
            }
            if (!filterResult) continue;
            return nodeKey;
        }
        return this.done();
    }

    public Axis getAxis() {
        return this.mAxis;
    }
}

