/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.axis.filter;

import com.google.common.base.Preconditions;
import org.sirix.api.Axis;
import org.sirix.api.NodeCursor;
import org.sirix.api.xml.XmlNodeReadOnlyTrx;
import org.sirix.axis.AbstractAxis;

public final class PredicateFilterAxis
extends AbstractAxis {
    private boolean mIsFirst = true;
    private final Axis mPredicate;

    public PredicateFilterAxis(NodeCursor nodeCursor, Axis predicate) {
        super(nodeCursor);
        this.mPredicate = (Axis)Preconditions.checkNotNull((Object)predicate);
    }

    @Override
    public final void reset(long nodeKey) {
        super.reset(nodeKey);
        if (this.mPredicate != null) {
            this.mPredicate.reset(nodeKey);
        }
        this.mIsFirst = true;
    }

    @Override
    protected long nextKey() {
        if (this.mIsFirst) {
            this.mIsFirst = false;
            long currKey = this.getCursor().getNodeKey();
            this.mPredicate.reset(currKey);
            if (this.mPredicate.hasNext()) {
                this.mPredicate.next();
                if (this.isBooleanFalse()) {
                    return this.done();
                }
                return currKey;
            }
        }
        return this.done();
    }

    private boolean isBooleanFalse() {
        if (this.getTrx() instanceof XmlNodeReadOnlyTrx) {
            XmlNodeReadOnlyTrx rtx = this.asXdmNodeReadTrx();
            if (rtx.getNodeKey() >= 0L) {
                return false;
            }
            if (rtx.getTypeKey() == rtx.keyForName("xs:boolean")) {
                return !Boolean.parseBoolean(rtx.getValue());
            }
            return false;
        }
        return false;
    }
}

