/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.axis.filter.xml;

import com.google.common.base.Preconditions;
import org.sirix.api.xml.XmlNodeReadOnlyTrx;
import org.sirix.axis.filter.AbstractFilter;
import org.sirix.node.Kind;

public final class WildcardFilter
extends AbstractFilter<XmlNodeReadOnlyTrx> {
    private final EType mType;
    private final int mKnownPartKey;

    public WildcardFilter(XmlNodeReadOnlyTrx rtx, String knownPart, EType type) {
        super(rtx);
        this.mType = (EType)((Object)Preconditions.checkNotNull((Object)((Object)type)));
        this.mKnownPartKey = ((XmlNodeReadOnlyTrx)this.getTrx()).keyForName((String)Preconditions.checkNotNull((Object)knownPart));
    }

    @Override
    public final boolean filter() {
        Kind kind = ((XmlNodeReadOnlyTrx)this.getTrx()).getKind();
        switch (kind) {
            case ELEMENT: {
                if (this.mType == EType.LOCALNAME) {
                    return this.localNameMatch();
                }
                int prefixKey = this.mKnownPartKey;
                int nsCount = ((XmlNodeReadOnlyTrx)this.getTrx()).getNamespaceCount();
                for (int i = 0; i < nsCount; ++i) {
                    ((XmlNodeReadOnlyTrx)this.getTrx()).moveToNamespace(i);
                    if (((XmlNodeReadOnlyTrx)this.getTrx()).getPrefixKey() == prefixKey) {
                        ((XmlNodeReadOnlyTrx)this.getTrx()).moveToParent();
                        return true;
                    }
                    ((XmlNodeReadOnlyTrx)this.getTrx()).moveToParent();
                }
                return false;
            }
            case ATTRIBUTE: {
                if (this.mType == EType.LOCALNAME) {
                    return this.localNameMatch();
                }
                String prefix = ((XmlNodeReadOnlyTrx)this.getTrx()).nameForKey(((XmlNodeReadOnlyTrx)this.getTrx()).getPrefixKey());
                int prefixKey = ((XmlNodeReadOnlyTrx)this.getTrx()).keyForName(prefix);
                return prefixKey == this.mKnownPartKey;
            }
        }
        return false;
    }

    private boolean localNameMatch() {
        int localnameKey = ((XmlNodeReadOnlyTrx)this.getTrx()).keyForName(((XmlNodeReadOnlyTrx)this.getTrx()).getName().getLocalName());
        return localnameKey == this.mKnownPartKey;
    }

    public static enum EType {
        PREFIX,
        LOCALNAME;

    }
}

