/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.axis.temporal;

import com.google.common.base.Preconditions;
import java.util.Optional;
import org.sirix.api.NodeCursor;
import org.sirix.api.NodeReadOnlyTrx;
import org.sirix.api.NodeTrx;
import org.sirix.api.ResourceManager;
import org.sirix.axis.AbstractTemporalAxis;

public final class NextAxis<R extends NodeReadOnlyTrx & NodeCursor, W extends NodeTrx & NodeCursor>
extends AbstractTemporalAxis<R, W> {
    private final ResourceManager<R, W> mResourceManager;
    private boolean mFirst;
    private int mRevision;
    private long mNodeKey;

    public NextAxis(ResourceManager<R, W> resourceManager, R rtx) {
        this.mResourceManager = (ResourceManager)Preconditions.checkNotNull(resourceManager);
        this.mRevision = 0;
        this.mNodeKey = rtx.getNodeKey();
        this.mRevision = rtx.getRevisionNumber() + 1;
        this.mFirst = true;
    }

    protected R computeNext() {
        if (this.mRevision <= this.mResourceManager.getMostRecentRevisionNumber() && this.mFirst) {
            this.mFirst = false;
            Optional<R> optionalRtx = this.mResourceManager.getNodeReadTrxByRevisionNumber(this.mRevision);
            NodeReadOnlyTrx rtx = optionalRtx.isPresent() ? (NodeReadOnlyTrx)optionalRtx.get() : this.mResourceManager.beginNodeReadOnlyTrx(this.mRevision);
            ++this.mRevision;
            if (rtx.moveTo(this.mNodeKey).hasMoved()) {
                return (R)rtx;
            }
            rtx.close();
            return (R)((NodeReadOnlyTrx)this.endOfData());
        }
        return (R)((NodeReadOnlyTrx)this.endOfData());
    }

    @Override
    public ResourceManager<R, W> getResourceManager() {
        return this.mResourceManager;
    }
}

