/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.cache;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.RemovalListener;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.sirix.cache.Cache;
import org.sirix.page.PageReference;
import org.sirix.page.interfaces.Page;

public final class PageCache
implements Cache<PageReference, Page> {
    private final com.github.benmanes.caffeine.cache.Cache<PageReference, Page> mPageCache;

    public PageCache() {
        RemovalListener removalListener = (key, value, cause) -> key.setPage(null);
        this.mPageCache = Caffeine.newBuilder().maximumSize(1000L).expireAfterWrite(5000L, TimeUnit.SECONDS).expireAfterAccess(5000L, TimeUnit.SECONDS).removalListener(removalListener).build();
    }

    @Override
    public void clear() {
        this.mPageCache.invalidateAll();
    }

    @Override
    public Page get(PageReference key) {
        return (Page)this.mPageCache.getIfPresent((Object)key);
    }

    @Override
    public void put(PageReference key, Page value) {
        this.mPageCache.put((Object)key, (Object)value);
    }

    @Override
    public void putAll(Map<? extends PageReference, ? extends Page> map) {
        this.mPageCache.putAll(map);
    }

    @Override
    public void toSecondCache() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<PageReference, Page> getAll(Iterable<? extends PageReference> keys) {
        return this.mPageCache.getAllPresent(keys);
    }

    @Override
    public void remove(PageReference key) {
        this.mPageCache.invalidate((Object)key);
    }

    @Override
    public void close() {
    }
}

