/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.cache;

import com.google.common.base.Preconditions;
import org.sirix.api.PageReadOnlyTrx;
import org.sirix.cache.PageContainer;
import org.sirix.io.Writer;
import org.sirix.page.PageReference;
import org.sirix.page.interfaces.KeyValuePage;
import org.sirix.page.interfaces.Page;

public final class PersistentFileCache
implements AutoCloseable {
    private final Writer mWriter;

    public PersistentFileCache(Writer writer) {
        this.mWriter = (Writer)Preconditions.checkNotNull((Object)writer);
    }

    public PageContainer get(PageReference reference, PageReadOnlyTrx pageReadTrx) {
        Page completePage;
        Preconditions.checkNotNull((Object)pageReadTrx);
        if (reference.getPersistentLogKey() < 0L) {
            return PageContainer.emptyInstance();
        }
        Page modifiedPage = this.mWriter.read(reference, pageReadTrx);
        if (modifiedPage instanceof KeyValuePage) {
            long peristKey = reference.getPersistentLogKey();
            reference.setPersistentLogKey(peristKey + (long)reference.getLength());
            completePage = this.mWriter.read(reference, pageReadTrx);
            reference.setPersistentLogKey(peristKey);
        } else {
            completePage = modifiedPage;
        }
        return PageContainer.getInstance(completePage, modifiedPage);
    }

    public PersistentFileCache put(PageReference reference, PageContainer container) {
        reference.setPage(container.getModified());
        this.mWriter.write(reference);
        if (container.getModified() instanceof KeyValuePage) {
            long offset = reference.getPersistentLogKey();
            int length = reference.getLength();
            reference.setPage(container.getComplete());
            this.mWriter.write(reference);
            reference.setPersistentLogKey(offset);
            reference.setLength(length += reference.getLength());
        }
        return this;
    }

    public PersistentFileCache truncate() {
        this.mWriter.truncate();
        return this;
    }

    @Override
    public void close() {
        this.mWriter.close();
    }
}

