/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.cache;

import com.google.common.base.MoreObjects;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.sirix.api.PageReadOnlyTrx;
import org.sirix.cache.PageContainer;
import org.sirix.cache.PersistentFileCache;
import org.sirix.page.PageReference;

public final class TransactionIntentLog
implements AutoCloseable {
    private static final int CACHE_CAPACITY = 32;
    private final Map<PageReference, PageContainer> mMap;
    private final BiMap<Integer, Long> mMapToPersistentLogKey;
    private final PersistentFileCache mSecondCache;
    private int mLogKey;

    public TransactionIntentLog(PersistentFileCache secondCache) {
        assert (secondCache != null);
        this.mLogKey = 0;
        this.mSecondCache = secondCache;
        this.mMapToPersistentLogKey = HashBiMap.create();
        this.mMap = new LinkedHashMap<PageReference, PageContainer>(32){
            private static final long serialVersionUID = 1L;

            @Override
            protected boolean removeEldestEntry(@Nullable Map.Entry<PageReference, PageContainer> eldest) {
                boolean returnVal = false;
                if (this.size() > 32) {
                    if (eldest != null) {
                        PageReference key = eldest.getKey();
                        assert (key.getLogKey() != -15);
                        PageContainer value = eldest.getValue();
                        if (key != null && value != null) {
                            TransactionIntentLog.this.mSecondCache.put(key, value);
                            TransactionIntentLog.this.mMapToPersistentLogKey.put((Object)key.getLogKey(), (Object)key.getPersistentLogKey());
                        }
                    }
                    returnVal = true;
                }
                return returnVal;
            }
        };
    }

    public PageContainer get(PageReference key, PageReadOnlyTrx pageRtx) {
        PageContainer value = this.mMap.get(key);
        if (value == null) {
            Long persistentKey;
            if (key.getLogKey() != -15 && (persistentKey = (Long)this.mMapToPersistentLogKey.get((Object)key.getLogKey())) != null) {
                key.setPersistentLogKey(persistentKey);
            }
            if ((value = this.mSecondCache.get(key, pageRtx)) != null && !PageContainer.emptyInstance().equals(value)) {
                key.setPersistentLogKey(-15L);
                this.put(key, value);
            }
        }
        return value;
    }

    public void put(PageReference key, PageContainer value) {
        if (this.mMap.containsKey(key)) {
            this.mMap.remove(key);
        }
        key.setKey(-15L);
        key.setLogKey(this.mLogKey++);
        this.mMap.put(key, value);
    }

    public void clear() {
        this.mLogKey = 0;
        this.mMap.clear();
    }

    public int usedEntries() {
        return this.mMap.size();
    }

    public Collection<Map.Entry<? super PageReference, ? super PageContainer>> getAll() {
        return new ArrayList<Map.Entry<? super PageReference, ? super PageContainer>>(this.mMap.entrySet());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("First Cache", this.mMap).add("Second Cache", (Object)this.mSecondCache).toString();
    }

    public Map<PageReference, PageContainer> getMap() {
        return Collections.unmodifiableMap(this.mMap);
    }

    public TransactionIntentLog truncate() {
        this.mSecondCache.close();
        this.mMapToPersistentLogKey.clear();
        this.mMap.clear();
        return this;
    }

    @Override
    public void close() {
        this.mMap.clear();
        this.mSecondCache.close();
    }
}

