/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.diff;

import java.util.Objects;
import org.sirix.api.json.JsonNodeReadOnlyTrx;
import org.sirix.api.json.JsonNodeTrx;
import org.sirix.diff.AbstractDiff;
import org.sirix.diff.DiffDepth;
import org.sirix.diff.DiffFactory;

final class JsonDiff
extends AbstractDiff<JsonNodeReadOnlyTrx, JsonNodeTrx> {
    public JsonDiff(DiffFactory.Builder<JsonNodeReadOnlyTrx, JsonNodeTrx> builder) {
        super(builder);
    }

    @Override
    boolean checkNodes(JsonNodeReadOnlyTrx newRtx, JsonNodeReadOnlyTrx oldRtx) {
        boolean found = false;
        if (newRtx.getNodeKey() == oldRtx.getNodeKey() && newRtx.getParentKey() == oldRtx.getParentKey() && newRtx.getKind() == oldRtx.getKind()) {
            found = this.checkNamesOrValues(newRtx, oldRtx);
        }
        return found;
    }

    private boolean checkNamesOrValues(JsonNodeReadOnlyTrx newRtx, JsonNodeReadOnlyTrx oldRtx) {
        boolean found = false;
        switch (newRtx.getKind()) {
            case ARRAY: 
            case OBJECT: 
            case NULL_VALUE: {
                found = true;
                break;
            }
            case OBJECT_RECORD: {
                if (!newRtx.getName().equals((Object)oldRtx.getName())) break;
                found = true;
                break;
            }
            case BOOLEAN_VALUE: {
                if (newRtx.getBooleanValue() != oldRtx.getBooleanValue()) break;
                found = true;
                break;
            }
            case NUMBER_VALUE: {
                if (!newRtx.getNumberValue().equals(oldRtx.getNumberValue())) break;
                found = true;
                break;
            }
            case STRING_VALUE: {
                if (!Objects.equals(newRtx.getValue(), oldRtx.getValue())) break;
                found = true;
                break;
            }
        }
        return found;
    }

    @Override
    void emitNonStructuralDiff(JsonNodeReadOnlyTrx newRtx, JsonNodeReadOnlyTrx oldRtx, DiffDepth depth, DiffFactory.DiffType diff) {
    }

    @Override
    boolean checkNodeNamesOrValues(JsonNodeReadOnlyTrx newRtx, JsonNodeReadOnlyTrx oldRtx) {
        return this.checkNamesOrValues(newRtx, oldRtx);
    }
}

