/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.diff;

import org.sirix.api.xml.XmlNodeReadOnlyTrx;
import org.sirix.api.xml.XmlNodeTrx;
import org.sirix.diff.AbstractDiff;
import org.sirix.diff.DiffDepth;
import org.sirix.diff.DiffFactory;

final class XmlStructuralDiff
extends AbstractDiff<XmlNodeReadOnlyTrx, XmlNodeTrx> {
    public XmlStructuralDiff(DiffFactory.Builder<XmlNodeReadOnlyTrx, XmlNodeTrx> builder) {
        super(builder);
    }

    @Override
    boolean checkNodes(XmlNodeReadOnlyTrx newRtx, XmlNodeReadOnlyTrx oldRtx) {
        boolean found = false;
        if (newRtx.getNodeKey() == oldRtx.getNodeKey() && newRtx.getParentKey() == oldRtx.getParentKey() && newRtx.getKind() == oldRtx.getKind()) {
            switch (newRtx.getKind()) {
                case ELEMENT: {
                    if (!newRtx.getName().equals((Object)oldRtx.getName())) break;
                    found = true;
                    break;
                }
                case PROCESSING_INSTRUCTION: {
                    found = newRtx.getValue().equals(oldRtx.getValue()) && newRtx.getName().equals((Object)oldRtx.getName());
                    break;
                }
                case COMMENT: 
                case TEXT: {
                    if (!newRtx.getValue().equals(oldRtx.getValue())) break;
                    found = true;
                    break;
                }
            }
        }
        return found;
    }

    @Override
    boolean checkNodeNamesOrValues(XmlNodeReadOnlyTrx newRtx, XmlNodeReadOnlyTrx oldRtx) {
        boolean found = false;
        if (newRtx.getKind() == oldRtx.getKind()) {
            switch (newRtx.getKind()) {
                case ELEMENT: 
                case PROCESSING_INSTRUCTION: {
                    if (!newRtx.getName().equals((Object)oldRtx.getName())) break;
                    found = true;
                    break;
                }
                case COMMENT: 
                case TEXT: {
                    if (!newRtx.getValue().equals(oldRtx.getValue())) break;
                    found = true;
                    break;
                }
            }
        }
        return found;
    }

    @Override
    void emitNonStructuralDiff(XmlNodeReadOnlyTrx newRtx, XmlNodeReadOnlyTrx oldRtx, DiffDepth depth, DiffFactory.DiffType diff) {
    }
}

