/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.diff.algorithm.fmse;

import org.brackit.xquery.atomic.QNm;
import org.sirix.api.xml.XmlNodeReadOnlyTrx;
import org.sirix.diff.algorithm.fmse.FMSENodeComparisonUtils;
import org.sirix.diff.algorithm.fmse.NodeComparator;
import org.sirix.index.path.summary.PathNode;
import org.sirix.index.path.summary.PathSummaryReader;
import org.sirix.node.Kind;

final class LeafNodeComparator
implements NodeComparator<Long> {
    public static final double FMESF = 0.5;
    private final QNm mId;
    private final XmlNodeReadOnlyTrx mOldRtx;
    private final XmlNodeReadOnlyTrx mNewRtx;
    private final PathSummaryReader mOldPathSummary;
    private final PathSummaryReader mNewPathSummary;
    private final FMSENodeComparisonUtils mNodeComparisonUtils;

    public LeafNodeComparator(QNm id, XmlNodeReadOnlyTrx oldRtx, XmlNodeReadOnlyTrx newRtx, PathSummaryReader oldPathSummary, PathSummaryReader newPathSummary, FMSENodeComparisonUtils nodeComparisonUtils) {
        this.mId = id;
        this.mOldRtx = oldRtx;
        this.mNewRtx = newRtx;
        this.mOldPathSummary = oldPathSummary;
        this.mNewPathSummary = newPathSummary;
        this.mNodeComparisonUtils = nodeComparisonUtils;
    }

    @Override
    public boolean isEqual(Long firstNode, Long secondNode) {
        assert (firstNode != null);
        assert (secondNode != null);
        this.mOldRtx.moveTo(firstNode);
        this.mNewRtx.moveTo(secondNode);
        assert (this.mOldRtx.getKind() == this.mNewRtx.getKind());
        double ratio = 0.0;
        if (this.mOldRtx.getKind() == Kind.ATTRIBUTE || this.mOldRtx.getKind() == Kind.NAMESPACE || this.mOldRtx.getKind() == Kind.PROCESSING_INSTRUCTION) {
            if (this.mOldRtx.getName().equals((Object)this.mNewRtx.getName())) {
                ratio = 1.0;
                if ((this.mOldRtx.getKind() == Kind.ATTRIBUTE || this.mOldRtx.getKind() == Kind.PROCESSING_INSTRUCTION) && (ratio = (double)this.mNodeComparisonUtils.calculateRatio(this.mOldRtx.getValue(), this.mNewRtx.getValue())) > 0.5) {
                    Path paths = this.checkPaths();
                    ratio = this.adaptRatioByUsingThePathChecks(paths);
                }
            }
        } else {
            ratio = this.mNodeComparisonUtils.nodeValuesEqual(firstNode, secondNode, this.mOldRtx, this.mNewRtx) ? 1.0 : (double)this.mNodeComparisonUtils.calculateRatio(this.mNodeComparisonUtils.getNodeValue(firstNode, this.mOldRtx), this.mNodeComparisonUtils.getNodeValue(secondNode, this.mNewRtx));
            if (ratio > 0.5) {
                this.mOldRtx.moveToParent();
                this.mNewRtx.moveToParent();
                ratio = this.mNodeComparisonUtils.calculateRatio(this.mNodeComparisonUtils.getNodeValue(this.mOldRtx.getNodeKey(), this.mOldRtx), this.mNodeComparisonUtils.getNodeValue(this.mNewRtx.getNodeKey(), this.mNewRtx));
                if (ratio > 0.5) {
                    Path paths = this.checkPaths();
                    ratio = this.adaptRatioByUsingThePathChecks(paths);
                }
            }
        }
        if (ratio > 0.5 && this.mId != null && this.mNodeComparisonUtils.checkIfAncestorIdsMatch(this.mOldRtx.getNodeKey(), this.mNewRtx.getNodeKey(), this.mId)) {
            ratio = 1.0;
        }
        this.mOldRtx.moveTo(firstNode);
        this.mNewRtx.moveTo(secondNode);
        return ratio > 0.5;
    }

    private double adaptRatioByUsingThePathChecks(Path paths) {
        double ratio = paths != Path.PATH_LENGTH_IS_NOT_EQUAL && this.mId != null ? (this.mNodeComparisonUtils.checkIfAncestorIdsMatch(this.mOldRtx.getNodeKey(), this.mNewRtx.getNodeKey(), this.mId) ? 1.0 : 0.0) : (paths == Path.MATCHES ? 1.0 : (paths == Path.NO_PATH ? (this.mNodeComparisonUtils.checkAncestors(this.mOldRtx.getNodeKey(), this.mNewRtx.getNodeKey()) ? 1.0 : 0.0) : 0.0));
        return ratio;
    }

    private Path checkPaths() {
        if (this.mOldRtx.getPathNodeKey() == 0L || this.mNewRtx.getPathNodeKey() == 0L) {
            return Path.NO_PATH;
        }
        PathNode oldPathNode = this.mNewPathSummary.getPathNodeForPathNodeKey(this.mNewRtx.getPathNodeKey());
        org.brackit.xquery.util.path.Path<QNm> oldPath = oldPathNode.getPath(this.mNewPathSummary);
        PathNode newPathNode = this.mOldPathSummary.getPathNodeForPathNodeKey(this.mOldRtx.getPathNodeKey());
        org.brackit.xquery.util.path.Path<QNm> newPath = newPathNode.getPath(this.mOldPathSummary);
        if (oldPath.getLength() != newPath.getLength()) {
            return Path.PATH_LENGTH_IS_NOT_EQUAL;
        }
        if (oldPath.matches(newPath)) {
            return Path.MATCHES;
        }
        return Path.NO_MATCH_NO_LENGTH_EQUALS;
    }

    private static enum Path {
        NO_PATH,
        MATCHES,
        PATH_LENGTH_IS_NOT_EQUAL,
        NO_MATCH_NO_LENGTH_EQUALS;

    }
}

