/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.diff.algorithm.fmse;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnegative;
import org.sirix.api.xml.XmlNodeReadOnlyTrx;
import org.sirix.axis.DescendantAxis;
import org.sirix.axis.IncludeSelf;
import org.sirix.diff.algorithm.fmse.ConnectionMap;
import org.sirix.node.Kind;

public final class Matching {
    private final Map<Long, Long> mMapping;
    private final Map<Long, Long> mReverseMapping;
    private final ConnectionMap<Long> mIsInSubtree;
    private final XmlNodeReadOnlyTrx mRtxOld;
    private final XmlNodeReadOnlyTrx mRtxNew;

    public Matching(XmlNodeReadOnlyTrx rtxOld, XmlNodeReadOnlyTrx rtxNew) {
        this.mMapping = new HashMap<Long, Long>();
        this.mReverseMapping = new HashMap<Long, Long>();
        this.mIsInSubtree = new ConnectionMap();
        this.mRtxOld = (XmlNodeReadOnlyTrx)Preconditions.checkNotNull((Object)rtxOld);
        this.mRtxNew = (XmlNodeReadOnlyTrx)Preconditions.checkNotNull((Object)rtxNew);
    }

    public Matching(Matching match) {
        this.mMapping = new HashMap<Long, Long>(match.mMapping);
        this.mReverseMapping = new HashMap<Long, Long>(match.mReverseMapping);
        this.mIsInSubtree = new ConnectionMap<Long>(match.mIsInSubtree);
        this.mRtxOld = match.mRtxOld;
        this.mRtxNew = match.mRtxNew;
    }

    public void add(@Nonnegative long nodeX, @Nonnegative long nodeY) {
        this.mRtxOld.moveTo(nodeX);
        this.mRtxNew.moveTo(nodeY);
        if (this.mRtxOld.getKind() != this.mRtxNew.getKind()) {
            throw new AssertionError();
        }
        this.mMapping.put(nodeX, nodeY);
        this.mReverseMapping.put(nodeY, nodeX);
        this.updateSubtreeMap(nodeX, this.mRtxOld);
        this.updateSubtreeMap(nodeY, this.mRtxNew);
    }

    public boolean remove(@Nonnegative long nodeX) {
        this.mReverseMapping.remove(this.mMapping.get(nodeX));
        return this.mMapping.remove(nodeX) != null;
    }

    private void updateSubtreeMap(@Nonnegative long key, XmlNodeReadOnlyTrx rtx) {
        assert (key >= 0L);
        assert (rtx != null);
        this.mIsInSubtree.set(key, key, true);
        rtx.moveTo(key);
        if (rtx.hasParent()) {
            while (rtx.hasParent()) {
                rtx.moveToParent();
                this.mIsInSubtree.set(rtx.getNodeKey(), key, true);
            }
            rtx.moveTo(key);
        }
    }

    public boolean contains(@Nonnegative long nodeX, @Nonnegative long nodeY) {
        return this.mMapping.get(nodeX) == null ? false : this.mMapping.get(nodeX).equals(nodeY);
    }

    public long containedDescendants(@Nonnegative long nodeX, @Nonnegative long nodeY) {
        long retVal = 0L;
        this.mRtxOld.moveTo(nodeX);
        DescendantAxis axis = new DescendantAxis(this.mRtxOld, IncludeSelf.YES);
        while (axis.hasNext()) {
            int i;
            axis.next();
            retVal += this.mIsInSubtree.get(nodeY, this.partner(this.mRtxOld.getNodeKey())) ? 1L : 0L;
            if (this.mRtxOld.getKind() != Kind.ELEMENT) continue;
            int nspCount = this.mRtxOld.getNamespaceCount();
            for (i = 0; i < nspCount; ++i) {
                this.mRtxOld.moveToNamespace(i);
                retVal += this.mIsInSubtree.get(nodeY, this.partner(axis.asXdmNodeReadTrx().getNodeKey())) ? 1L : 0L;
                this.mRtxOld.moveToParent();
            }
            int attCount = this.mRtxOld.getAttributeCount();
            for (i = 0; i < attCount; ++i) {
                this.mRtxOld.moveToAttribute(i);
                retVal += this.mIsInSubtree.get(nodeY, this.partner(axis.asXdmNodeReadTrx().getNodeKey())) ? 1L : 0L;
                this.mRtxOld.moveToParent();
            }
        }
        return retVal;
    }

    public Long partner(@Nonnegative long node) {
        return this.mMapping.get(node);
    }

    public Long reversePartner(@Nonnegative long node) {
        return this.mReverseMapping.get(node);
    }

    public void reset() {
        this.mMapping.clear();
        this.mReverseMapping.clear();
        this.mIsInSubtree.reset();
    }
}

