/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.diff.service;

import com.google.common.base.Preconditions;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import javax.annotation.Nonnull;
import javax.xml.stream.XMLEventReader;
import org.brackit.xquery.atomic.QNm;
import org.sirix.access.DatabaseConfiguration;
import org.sirix.access.Databases;
import org.sirix.access.ResourceConfiguration;
import org.sirix.api.Database;
import org.sirix.api.xml.XmlNodeReadOnlyTrx;
import org.sirix.api.xml.XmlNodeTrx;
import org.sirix.api.xml.XmlResourceManager;
import org.sirix.diff.algorithm.fmse.DefaultNodeComparisonFactory;
import org.sirix.diff.algorithm.fmse.FMSE;
import org.sirix.exception.SirixException;
import org.sirix.exception.SirixIOException;
import org.sirix.service.xml.shredder.InsertPosition;
import org.sirix.service.xml.shredder.XmlShredder;
import org.sirix.utils.LogWrapper;
import org.sirix.utils.SirixFiles;
import org.slf4j.LoggerFactory;

public final class FMSEImport {
    private static final LogWrapper LOGWRAPPER = new LogWrapper(LoggerFactory.getLogger(FMSEImport.class));

    public void shredder(Path resNewRev, @Nonnull Path newRev) {
        assert (resNewRev != null);
        assert (newRev != null);
        DatabaseConfiguration conf = new DatabaseConfiguration(newRev);
        Databases.removeDatabase(newRev);
        Databases.createXmlDatabase(conf);
        try (Database<XmlResourceManager> db = Databases.openXmlDatabase(newRev);){
            db.createResource(new ResourceConfiguration.Builder("shredded").buildPathSummary(true).useDeweyIDs(true).build());
            try (XmlResourceManager resMgr = db.openResourceManager("shredded");
                 XmlNodeTrx wtx = (XmlNodeTrx)resMgr.beginNodeTrx();
                 FileInputStream fis = new FileInputStream(resNewRev.toFile());){
                XMLEventReader fileReader = XmlShredder.createFileReader(fis);
                XmlShredder shredder = new XmlShredder.Builder(wtx, fileReader, InsertPosition.AS_FIRST_CHILD).commitAfterwards().build();
                shredder.call();
            }
            catch (IOException e) {
                throw new SirixIOException(e.getCause());
            }
        }
    }

    public void xmlDataImport(Path resOldRev, @Nonnull Path resNewRev, QNm idName) {
        this.importData(resOldRev, resNewRev, idName);
    }

    private void xmlDataImport(Path resOldRev, @Nonnull Path resNewRev) {
        this.importData(resOldRev, resNewRev, null);
    }

    private void importData(Path resOldRev, Path resNewRev, QNm idName) {
        try {
            Path newRevTarget = Files.createTempDirectory(resNewRev.getFileName().toString(), new FileAttribute[0]);
            if (Files.exists(newRevTarget, new LinkOption[0])) {
                SirixFiles.recursiveRemove(newRevTarget);
            }
            this.shredder((Path)Preconditions.checkNotNull((Object)resNewRev), newRevTarget);
            try (Database<XmlResourceManager> databaseOld = Databases.openXmlDatabase(resOldRev);
                 XmlResourceManager resMgrOld = databaseOld.openResourceManager("shredded");
                 XmlNodeTrx wtx = (XmlNodeTrx)resMgrOld.beginNodeTrx();
                 Database<XmlResourceManager> databaseNew = Databases.openXmlDatabase(newRevTarget);
                 XmlResourceManager resourceNew = databaseNew.openResourceManager("shredded");
                 XmlNodeReadOnlyTrx rtx = (XmlNodeReadOnlyTrx)resourceNew.beginNodeReadOnlyTrx();
                 FMSE fmes = idName == null ? FMSE.createInstance(new DefaultNodeComparisonFactory()) : FMSE.createWithIdentifier(idName, new DefaultNodeComparisonFactory());){
                fmes.diff(wtx, rtx);
            }
        }
        catch (IOException | SirixException e) {
            LOGWRAPPER.error(e.getMessage(), e);
        }
    }

    public static void main(String[] args) {
        if (args.length < 2 || args.length > 4) {
            throw new IllegalArgumentException("Usage: FSME oldResource newXMLDocument [startNodeKeyOld] [startNodeKeyNew]");
        }
        Path resOldRev = Paths.get(args[0], new String[0]);
        Path resNewRev = Paths.get(args[1], new String[0]);
        if (args.length == 3) {
            new FMSEImport().xmlDataImport(resOldRev, resNewRev, new QNm(args[2]));
        } else {
            new FMSEImport().xmlDataImport(resOldRev, resNewRev);
        }
    }
}

