/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.index;

import com.google.common.base.Preconditions;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import org.brackit.xquery.atomic.Atomic;
import org.brackit.xquery.atomic.QNm;
import org.brackit.xquery.atomic.Una;
import org.brackit.xquery.node.parser.FragmentHelper;
import org.brackit.xquery.util.path.Path;
import org.brackit.xquery.util.serialize.SubtreePrinter;
import org.brackit.xquery.xdm.DocumentException;
import org.brackit.xquery.xdm.Type;
import org.brackit.xquery.xdm.node.Node;
import org.sirix.index.IndexType;
import org.sirix.index.Materializable;

public final class IndexDef
implements Materializable {
    private static final QNm EXCLUDING_TAG = new QNm("excluding");
    private static final QNm INCLUDING_TAG = new QNm("including");
    private static final QNm PATH_TAG = new QNm("path");
    private static final QNm UNIQUE_ATTRIBUTE = new QNm("unique");
    private static final QNm CONTENT_TYPE_ATTRIBUTE = new QNm("keyType");
    private static final QNm TYPE_ATTRIBUTE = new QNm("type");
    private static final QNm ID_ATTRIBUTE = new QNm("id");
    public static final QNm INDEX_TAG = new QNm("index");
    private IndexType mType;
    private boolean mUnique = false;
    private Type mContentType;
    private int mID;
    private final Set<Path<QNm>> mPaths = new HashSet<Path<QNm>>();
    private final Set<QNm> mExcluded = new HashSet<QNm>();
    private final Set<QNm> mIncluded = new HashSet<QNm>();

    public IndexDef() {
    }

    IndexDef(Set<QNm> included, Set<QNm> excluded, int indexDefNo) {
        this.mType = IndexType.NAME;
        this.mIncluded.addAll(included);
        this.mExcluded.addAll(excluded);
        this.mID = indexDefNo;
    }

    IndexDef(Set<Path<QNm>> paths, int indexDefNo) {
        this.mType = IndexType.PATH;
        this.mPaths.addAll(paths);
        this.mID = indexDefNo;
    }

    IndexDef(Type contentType, Set<Path<QNm>> paths, boolean unique, int indexDefNo) {
        this.mType = IndexType.CAS;
        this.mContentType = (Type)Preconditions.checkNotNull((Object)contentType);
        this.mPaths.addAll(paths);
        this.mUnique = unique;
        this.mID = indexDefNo;
    }

    @Override
    public Node<?> materialize() throws DocumentException {
        StringBuilder buf;
        FragmentHelper tmp = new FragmentHelper();
        tmp.openElement(INDEX_TAG);
        tmp.attribute(TYPE_ATTRIBUTE, (Atomic)new Una(this.mType.toString()));
        tmp.attribute(ID_ATTRIBUTE, (Atomic)new Una(Integer.toString(this.mID)));
        if (this.mContentType != null) {
            tmp.attribute(CONTENT_TYPE_ATTRIBUTE, (Atomic)new Una(this.mContentType.toString()));
        }
        if (this.mUnique) {
            tmp.attribute(UNIQUE_ATTRIBUTE, (Atomic)new Una(Boolean.toString(this.mUnique)));
        }
        if (this.mPaths != null && !this.mPaths.isEmpty()) {
            for (Path<QNm> path : this.mPaths) {
                tmp.openElement(PATH_TAG);
                tmp.content(path.toString());
                tmp.closeElement();
            }
        }
        if (!this.mExcluded.isEmpty()) {
            tmp.openElement(EXCLUDING_TAG);
            buf = new StringBuilder();
            for (QNm s : this.mExcluded) {
                buf.append(s + ",");
            }
            buf.deleteCharAt(buf.length() - 1);
            tmp.content(buf.toString());
            tmp.closeElement();
        }
        if (!this.mIncluded.isEmpty()) {
            tmp.openElement(INCLUDING_TAG);
            buf = new StringBuilder();
            for (QNm incl : this.mIncluded) {
                buf.append(incl + ",");
            }
            buf.deleteCharAt(buf.length() - 1);
            tmp.content(buf.toString());
            tmp.closeElement();
        }
        tmp.closeElement();
        return tmp.getRoot();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void init(Node<?> root) throws DocumentException {
        name = root.getName();
        if (!name.equals((Object)IndexDef.INDEX_TAG)) {
            throw new DocumentException("Expected tag '%s' but found '%s'", new Object[]{IndexDef.INDEX_TAG, name});
        }
        attribute = root.getAttribute(IndexDef.ID_ATTRIBUTE);
        if (attribute != null) {
            this.mID = Integer.valueOf(attribute.getValue().stringValue());
        }
        if ((attribute = root.getAttribute(IndexDef.TYPE_ATTRIBUTE)) != null) {
            this.mType = IndexType.valueOf(attribute.getValue().stringValue());
        }
        if ((attribute = root.getAttribute(IndexDef.CONTENT_TYPE_ATTRIBUTE)) != null) {
            this.mContentType = IndexDef.resolveType(attribute.getValue().stringValue());
        }
        if ((attribute = root.getAttribute(IndexDef.UNIQUE_ATTRIBUTE)) != null) {
            this.mUnique = Boolean.valueOf(attribute.getValue().stringValue());
        }
        children = root.getChildren();
lbl14:
        // 3 sources

        try {
            while ((child = (Node)children.next()) != null) {
                block13: {
                    childName = child.getName();
                    value = child.getValue().stringValue();
                    if (childName.equals((Object)IndexDef.PATH_TAG)) {
                        path = value;
                        this.mPaths.add((Path<QNm>)Path.parse((String)path));
                        continue;
                    }
                    if (!childName.equals((Object)IndexDef.INCLUDING_TAG)) break block13;
                    for (String s : value.split(",")) {
                        if (s.length() <= 0) continue;
                        this.mIncluded.add(new QNm(s));
                    }
                    ** GOTO lbl14
                }
                if (!childName.equals((Object)IndexDef.EXCLUDING_TAG)) continue;
                for (String s : value.split(",")) {
                    if (s.length() <= 0) continue;
                    this.mExcluded.add(new QNm(s));
                }
                ** GOTO lbl14
            }
        }
        finally {
            children.close();
        }
    }

    private static Type resolveType(String s) throws DocumentException {
        QNm name = new QNm("http://www.w3.org/2001/XMLSchema", "xs", s.substring("xs".length() + 1));
        for (Type type : Type.builtInTypes) {
            if (!type.getName().getLocalName().equals(name.getLocalName())) continue;
            return type;
        }
        throw new DocumentException("Unknown content type type: '%s'", new Object[]{name});
    }

    public boolean isNameIndex() {
        return this.mType == IndexType.NAME;
    }

    public boolean isCasIndex() {
        return this.mType == IndexType.CAS;
    }

    public boolean isPathIndex() {
        return this.mType == IndexType.PATH;
    }

    public boolean isUnique() {
        return this.mUnique;
    }

    public int getID() {
        return this.mID;
    }

    public IndexType getType() {
        return this.mType;
    }

    public Set<Path<QNm>> getPaths() {
        return Collections.unmodifiableSet(this.mPaths);
    }

    public Set<QNm> getIncluded() {
        return Collections.unmodifiableSet(this.mIncluded);
    }

    public Set<QNm> getExcluded() {
        return Collections.unmodifiableSet(this.mExcluded);
    }

    public String toString() {
        try {
            ByteArrayOutputStream buf = new ByteArrayOutputStream();
            SubtreePrinter.print(this.materialize(), (PrintStream)new PrintStream(buf));
            return buf.toString();
        }
        catch (DocumentException e) {
            return e.getMessage();
        }
    }

    public Type getContentType() {
        return this.mContentType;
    }

    public int hashCode() {
        int result = this.mID;
        result = 31 * result + (this.mType == null ? 0 : this.mType.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof IndexDef)) {
            return false;
        }
        IndexDef other = (IndexDef)obj;
        return this.mID == other.mID && this.mType == other.mType;
    }
}

