/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.index;

import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import java.util.Iterator;
import java.util.Set;
import org.sirix.index.Filter;
import org.sirix.index.avltree.AVLNode;
import org.sirix.index.avltree.keyvalue.NodeReferences;

public final class IndexFilterAxis<K extends Comparable<? super K>>
extends AbstractIterator<NodeReferences> {
    private final Iterator<AVLNode<K, NodeReferences>> mIter;
    private final Set<? extends Filter> mFilter;

    public IndexFilterAxis(Iterator<AVLNode<K, NodeReferences>> iter, Set<? extends Filter> filter) {
        this.mIter = (Iterator)Preconditions.checkNotNull(iter);
        this.mFilter = (Set)Preconditions.checkNotNull(filter);
    }

    protected NodeReferences computeNext() {
        while (this.mIter.hasNext()) {
            AVLNode<K, NodeReferences> node = this.mIter.next();
            boolean filterResult = true;
            for (Filter filter : this.mFilter) {
                if (filterResult = filterResult && filter.filter(node)) continue;
                break;
            }
            if (!filterResult) continue;
            return node.getValue();
        }
        return (NodeReferences)this.endOfData();
    }
}

