/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.index.avltree.keyvalue;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnegative;
import javax.annotation.Nullable;
import org.sirix.index.avltree.interfaces.References;

public final class NodeReferences
implements References {
    private final Set<Long> mNodeKeys;

    public NodeReferences() {
        this.mNodeKeys = new HashSet<Long>();
    }

    public NodeReferences(Set<Long> nodeKeys) {
        this.mNodeKeys = nodeKeys;
    }

    @Override
    public boolean isPresent(@Nonnegative long nodeKey) {
        return this.mNodeKeys.contains(nodeKey);
    }

    @Override
    public Set<Long> getNodeKeys() {
        return Collections.unmodifiableSet(this.mNodeKeys);
    }

    @Override
    public NodeReferences addNodeKey(@Nonnegative long nodeKey) {
        this.mNodeKeys.add(nodeKey);
        return this;
    }

    @Override
    public boolean removeNodeKey(@Nonnegative long nodeKey) {
        return this.mNodeKeys.remove(nodeKey);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mNodeKeys});
    }

    public boolean equals(@Nullable Object obj) {
        if (obj instanceof NodeReferences) {
            NodeReferences refs = (NodeReferences)obj;
            return this.mNodeKeys.equals(refs.mNodeKeys);
        }
        return false;
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((Object)this);
        for (long nodeKey : this.mNodeKeys) {
            helper.add("referenced node key", nodeKey);
        }
        return helper.toString();
    }

    @Override
    public boolean hasNodeKeys() {
        return !this.mNodeKeys.isEmpty();
    }

    @Override
    public boolean contains(@Nonnegative long nodeKey) {
        return this.mNodeKeys.contains(nodeKey);
    }
}

