/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.index.cas;

import java.util.Optional;
import java.util.Set;
import org.brackit.xquery.atomic.Atomic;
import org.brackit.xquery.atomic.QNm;
import org.brackit.xquery.atomic.Str;
import org.brackit.xquery.util.path.Path;
import org.brackit.xquery.util.path.PathException;
import org.brackit.xquery.xdm.Type;
import org.sirix.api.visitor.VisitResult;
import org.sirix.api.visitor.VisitResultType;
import org.sirix.exception.SirixIOException;
import org.sirix.exception.SirixRuntimeException;
import org.sirix.index.AtomicUtil;
import org.sirix.index.SearchMode;
import org.sirix.index.avltree.AVLTreeReader;
import org.sirix.index.avltree.AVLTreeWriter;
import org.sirix.index.avltree.keyvalue.CASValue;
import org.sirix.index.avltree.keyvalue.NodeReferences;
import org.sirix.index.path.summary.PathSummaryReader;
import org.sirix.node.interfaces.immutable.ImmutableNode;
import org.sirix.node.interfaces.immutable.ImmutableValueNode;
import org.sirix.utils.LogWrapper;
import org.slf4j.LoggerFactory;

public final class CASIndexBuilder {
    private static final LogWrapper LOGGER = new LogWrapper(LoggerFactory.getLogger(CASIndexBuilder.class));
    private final AVLTreeWriter<CASValue, NodeReferences> mAVLTreeWriter;
    private final PathSummaryReader mPathSummaryReader;
    private final Set<Path<QNm>> mPaths;
    private final Type mType;

    public CASIndexBuilder(AVLTreeWriter<CASValue, NodeReferences> avlTreeWriter, PathSummaryReader pathSummaryReader, Set<Path<QNm>> paths, Type type) {
        this.mPathSummaryReader = pathSummaryReader;
        this.mPaths = paths;
        this.mAVLTreeWriter = avlTreeWriter;
        this.mType = type;
    }

    public VisitResult process(ImmutableNode node, long pathNodeKey) {
        block8: {
            try {
                if (!this.mPaths.isEmpty() && !this.mPathSummaryReader.getPCRsForPaths(this.mPaths, true).contains(pathNodeKey)) break block8;
                Str strValue = new Str(((ImmutableValueNode)((Object)node)).getValue());
                boolean isOfType = false;
                try {
                    if (this.mType != Type.STR) {
                        AtomicUtil.toType((Atomic)strValue, this.mType);
                    }
                    isOfType = true;
                }
                catch (SirixRuntimeException sirixRuntimeException) {
                    // empty catch block
                }
                if (isOfType) {
                    CASValue value = new CASValue((Atomic)strValue, this.mType, pathNodeKey);
                    Optional<NodeReferences> textReferences = this.mAVLTreeWriter.get(value, SearchMode.EQUAL);
                    if (textReferences.isPresent()) {
                        this.setNodeReferences(node, textReferences.get(), value);
                    } else {
                        this.setNodeReferences(node, new NodeReferences(), value);
                    }
                }
            }
            catch (PathException | SirixIOException e) {
                LOGGER.error(e.getMessage(), e);
            }
        }
        return VisitResultType.CONTINUE;
    }

    private void setNodeReferences(ImmutableNode node, NodeReferences references, CASValue value) throws SirixIOException {
        this.mAVLTreeWriter.index(value, references.addNodeKey(node.getNodeKey()), AVLTreeReader.MoveCursor.NO_MOVE);
    }
}

