/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.index.cas.json;

import org.sirix.access.trx.node.json.AbstractJsonNodeVisitor;
import org.sirix.api.json.JsonNodeReadOnlyTrx;
import org.sirix.api.visitor.VisitResult;
import org.sirix.index.cas.CASIndexBuilder;
import org.sirix.node.immutable.json.ImmutableBooleanNode;
import org.sirix.node.immutable.json.ImmutableNumberNode;
import org.sirix.node.immutable.json.ImmutableStringNode;
import org.sirix.node.interfaces.immutable.ImmutableNode;
import org.sirix.node.json.ObjectRecordNode;

final class JsonCASIndexBuilder
extends AbstractJsonNodeVisitor {
    private final CASIndexBuilder mIndexBuilderDelegate;
    private final JsonNodeReadOnlyTrx mRtx;

    JsonCASIndexBuilder(CASIndexBuilder indexBuilderDelegate, JsonNodeReadOnlyTrx rtx) {
        this.mIndexBuilderDelegate = indexBuilderDelegate;
        this.mRtx = rtx;
    }

    @Override
    public VisitResult visit(ImmutableStringNode node) {
        long PCR = this.getPathClassRecord(node);
        return this.mIndexBuilderDelegate.process(node, PCR);
    }

    @Override
    public VisitResult visit(ImmutableBooleanNode node) {
        long PCR = this.getPathClassRecord(node);
        return this.mIndexBuilderDelegate.process(node, PCR);
    }

    @Override
    public VisitResult visit(ImmutableNumberNode node) {
        long PCR = this.getPathClassRecord(node);
        return this.mIndexBuilderDelegate.process(node, PCR);
    }

    private long getPathClassRecord(ImmutableNode node) {
        this.mRtx.moveTo(node.getParentKey());
        long PCR = this.mRtx.isDocumentRoot() ? 0L : (this.mRtx.isObjectKey() ? ((ObjectRecordNode)this.mRtx.getNode()).getPathNodeKey() : (this.mRtx.moveToParent().trx().isDocumentRoot() ? 0L : ((ObjectRecordNode)this.mRtx.getNode()).getPathNodeKey()));
        return PCR;
    }
}

