/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.index.name;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.Set;
import org.brackit.xquery.atomic.QNm;
import org.sirix.index.Filter;
import org.sirix.index.avltree.AVLNode;
import org.sirix.index.avltree.keyvalue.NodeReferences;

public final class NameFilter
implements Filter {
    private final Set<QNm> mIncludes;
    private final Set<QNm> mExcludes;

    public NameFilter(Set<QNm> included, Set<QNm> excluded) {
        this.mIncludes = (Set)Preconditions.checkNotNull(included);
        this.mExcludes = (Set)Preconditions.checkNotNull(excluded);
    }

    public Set<QNm> getIncludes() {
        return Collections.unmodifiableSet(this.mIncludes);
    }

    public Set<QNm> getExcludes() {
        return Collections.unmodifiableSet(this.mExcludes);
    }

    @Override
    public <K extends Comparable<? super K>> boolean filter(AVLNode<K, NodeReferences> node) {
        boolean excluded;
        if (!(node.getKey() instanceof QNm)) {
            throw new IllegalStateException("Key is not of type QNm!");
        }
        QNm name = (QNm)node.getKey();
        boolean included = this.mIncludes.isEmpty() || this.mIncludes.contains(name);
        boolean bl = excluded = !this.mExcludes.isEmpty() && this.mExcludes.contains(name);
        return included && !excluded;
    }
}

