/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.index.name;

import com.google.common.base.Preconditions;
import java.util.Set;
import org.brackit.xquery.atomic.QNm;
import org.sirix.api.PageTrx;
import org.sirix.index.IndexDef;
import org.sirix.index.IndexType;
import org.sirix.index.avltree.AVLTreeWriter;
import org.sirix.index.avltree.keyvalue.NodeReferences;
import org.sirix.index.name.NameIndexBuilder;
import org.sirix.node.interfaces.Record;
import org.sirix.page.UnorderedKeyValuePage;

public final class NameIndexBuilderFactory {
    public NameIndexBuilder create(PageTrx<Long, Record, UnorderedKeyValuePage> pageWriteTrx, IndexDef indexDefinition) {
        Set includes = (Set)Preconditions.checkNotNull(indexDefinition.getIncluded());
        Set excludes = (Set)Preconditions.checkNotNull(indexDefinition.getExcluded());
        assert (indexDefinition.getType() == IndexType.NAME);
        AVLTreeWriter<QNm, NodeReferences> avlTreeWriter = AVLTreeWriter.getInstance(pageWriteTrx, indexDefinition.getType(), indexDefinition.getID());
        return new NameIndexBuilder(includes, excludes, avlTreeWriter);
    }
}

