/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.index.name;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashBiMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.sirix.settings.Constants;

public final class Names {
    private final Map<Integer, byte[]> mNameMap;
    private final Map<Integer, Integer> mCountNameMapping;

    private Names() {
        this.mNameMap = new HashMap<Integer, byte[]>();
        this.mCountNameMapping = new HashMap<Integer, Integer>();
    }

    private Names(DataInput in) throws IOException {
        int mapSize = in.readInt();
        this.mNameMap = HashBiMap.create((int)mapSize);
        this.mCountNameMapping = new HashMap<Integer, Integer>(mapSize);
        int l = mapSize;
        for (int i = 0; i < l; ++i) {
            int key = in.readInt();
            int valSize = in.readInt();
            byte[] bytes = new byte[valSize];
            for (int j = 0; j < bytes.length; ++j) {
                bytes[j] = in.readByte();
            }
            this.mNameMap.put(key, bytes);
            this.mCountNameMapping.put(key, in.readInt());
        }
    }

    public void serialize(DataOutput out) throws IOException {
        out.writeInt(this.mNameMap.size());
        for (Map.Entry<Integer, byte[]> entry : this.mNameMap.entrySet()) {
            out.writeInt(entry.getKey());
            byte[] bytes = entry.getValue();
            out.writeInt(bytes.length);
            for (byte byteVal : bytes) {
                out.writeByte(byteVal);
            }
            out.writeInt(this.mCountNameMapping.get(entry.getKey()));
        }
    }

    public void removeName(int key) {
        Integer prevValue = this.mCountNameMapping.get(key);
        if (prevValue != null) {
            if (prevValue - 1 == 0) {
                this.mNameMap.remove(key);
                this.mCountNameMapping.remove(key);
            } else {
                this.mCountNameMapping.put(key, prevValue - 1);
            }
        }
    }

    private static byte[] getBytes(String name) {
        return name.getBytes(Constants.DEFAULT_ENCODING);
    }

    public void setName(int pKey, String name) {
        Integer prevValue = this.mCountNameMapping.get(pKey);
        if (prevValue == null) {
            this.mNameMap.put(pKey, (byte[])Preconditions.checkNotNull((Object)Names.getBytes(name)));
            this.mCountNameMapping.put(pKey, 1);
        } else {
            this.mCountNameMapping.put(pKey, prevValue + 1);
        }
    }

    public String getName(int key) {
        byte[] name = this.mNameMap.get(key);
        if (name == null) {
            return null;
        }
        return new String(name, Constants.DEFAULT_ENCODING);
    }

    public int getCount(int key) {
        Integer names = this.mCountNameMapping.get(key);
        if (names == null) {
            names = 0;
        }
        return names;
    }

    public byte[] getRawName(int key) {
        return this.mNameMap.get(key);
    }

    public static Names getInstance() {
        return new Names();
    }

    public static Names clone(DataInput in) throws IOException {
        return new Names(in);
    }
}

