/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.index.path;

import java.util.Optional;
import java.util.Set;
import org.brackit.xquery.atomic.QNm;
import org.brackit.xquery.util.path.Path;
import org.brackit.xquery.util.path.PathException;
import org.sirix.api.visitor.VisitResult;
import org.sirix.api.visitor.VisitResultType;
import org.sirix.exception.SirixIOException;
import org.sirix.index.SearchMode;
import org.sirix.index.avltree.AVLTreeReader;
import org.sirix.index.avltree.AVLTreeWriter;
import org.sirix.index.avltree.keyvalue.NodeReferences;
import org.sirix.index.path.summary.PathSummaryReader;
import org.sirix.node.interfaces.immutable.ImmutableNode;
import org.sirix.utils.LogWrapper;
import org.slf4j.LoggerFactory;

public final class PathIndexBuilder {
    private static final LogWrapper LOGGER = new LogWrapper(LoggerFactory.getLogger(PathIndexBuilder.class));
    private final Set<Path<QNm>> mPaths;
    private final PathSummaryReader mPathSummaryReader;
    private final AVLTreeWriter<Long, NodeReferences> mAVLTreeWriter;

    public PathIndexBuilder(AVLTreeWriter<Long, NodeReferences> avlTreeWriter, PathSummaryReader pathSummaryReader, Set<Path<QNm>> paths) {
        this.mPathSummaryReader = pathSummaryReader;
        this.mPaths = paths;
        this.mAVLTreeWriter = avlTreeWriter;
    }

    public VisitResult process(ImmutableNode node, long pathNodeKey) {
        try {
            long PCR = pathNodeKey;
            if (this.mPathSummaryReader.getPCRsForPaths(this.mPaths, true).contains(PCR) || this.mPaths.isEmpty()) {
                Optional<NodeReferences> textReferences = this.mAVLTreeWriter.get(PCR, SearchMode.EQUAL);
                if (textReferences.isPresent()) {
                    this.setNodeReferences(node, textReferences.get(), PCR);
                } else {
                    this.setNodeReferences(node, new NodeReferences(), PCR);
                }
            }
        }
        catch (PathException | SirixIOException e) {
            LOGGER.error(e.getMessage(), e);
        }
        return VisitResultType.CONTINUE;
    }

    private void setNodeReferences(ImmutableNode node, NodeReferences references, long pathNodeKey) throws SirixIOException {
        this.mAVLTreeWriter.index(pathNodeKey, references.addNodeKey(node.getNodeKey()), AVLTreeReader.MoveCursor.NO_MOVE);
    }
}

