/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.index.path;

import com.google.common.base.Preconditions;
import java.util.Set;
import org.sirix.api.PageTrx;
import org.sirix.index.IndexDef;
import org.sirix.index.IndexType;
import org.sirix.index.avltree.AVLTreeWriter;
import org.sirix.index.avltree.keyvalue.NodeReferences;
import org.sirix.index.path.PathIndexBuilder;
import org.sirix.index.path.summary.PathSummaryReader;
import org.sirix.node.interfaces.Record;
import org.sirix.page.UnorderedKeyValuePage;

public final class PathIndexBuilderFactory {
    public PathIndexBuilder create(PageTrx<Long, Record, UnorderedKeyValuePage> pageWriteTrx, PathSummaryReader pathSummaryReader, IndexDef indexDef) {
        PathSummaryReader pathSummary = (PathSummaryReader)Preconditions.checkNotNull((Object)pathSummaryReader);
        Set paths = (Set)Preconditions.checkNotNull(indexDef.getPaths());
        assert (indexDef.getType() == IndexType.PATH);
        AVLTreeWriter<Long, NodeReferences> avlTreeWriter = AVLTreeWriter.getInstance(pageWriteTrx, indexDef.getType(), indexDef.getID());
        return new PathIndexBuilder(avlTreeWriter, pathSummary, paths);
    }
}

